/*
 * Decompiled with CFR 0.152.
 */
package com.zzh.lib.views;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import androidx.recyclerview.widget.RecyclerView;
import com.zzh.lib.views.R;
import com.zzh.lib.views.def.HStateEmptyStrategy;
import com.zzh.lib.views.state.HStateLayout;
import com.zzh.lib.views.state.empty.AdapterViewEmptyStrategy;
import com.zzh.lib.views.state.empty.CombineEmptyStrategy;
import com.zzh.lib.views.state.empty.RecyclerViewEmptyStrategy;
import com.zzh.lib.views.state.empty.SourceCountEmptyStrategy;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class HAutoEmptyStateLayout
extends HStateLayout {
    private String hText;
    private boolean hAutoReplace = false;
    private boolean mAutoEmpty = false;

    public HAutoEmptyStateLayout(Context context) {
        super(context);
    }

    public HAutoEmptyStateLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public HAutoEmptyStateLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.HAutoEmptyStateLayout);
        if (ta.hasValue(R.styleable.HAutoEmptyStateLayout_zh_auto_empty)) {
            this.mAutoEmpty = ta.getBoolean(R.styleable.HAutoEmptyStateLayout_zh_auto_empty, false);
        }
        if (ta.hasValue(R.styleable.HAutoEmptyStateLayout_zh_auto_replace)) {
            this.hAutoReplace = ta.getBoolean(R.styleable.HAutoEmptyStateLayout_zh_auto_replace, false);
        }
        if (ta.hasValue(R.styleable.HAutoEmptyStateLayout_zh_text)) {
            this.hText = ta.getString(R.styleable.HAutoEmptyStateLayout_zh_text);
        }
        ta.recycle();
    }

    public void autoEmpty() {
        this.mAutoEmpty = true;
        this.applyAutoEmptyStrategy(this.getContentView());
    }

    @Override
    public void setEmptyStrategy(HStateEmptyStrategy strategy) {
        this.mAutoEmpty = false;
        super.setEmptyStrategy(strategy);
    }

    @Override
    protected void onContentViewChanged(View oldView, View newView) {
        super.onContentViewChanged(oldView, newView);
        this.applyAutoEmptyStrategy(newView);
    }

    private void applyAutoEmptyStrategy(View view) {
        if (!this.mAutoEmpty) {
            return;
        }
        if (view == null) {
            this.cancelAutoEmptyStrategy();
            return;
        }
        LinkedList<SourceCountEmptyStrategy> listStrategy = new LinkedList<SourceCountEmptyStrategy>();
        List<View> list = HAutoEmptyStateLayout.getAllViews(view);
        for (View item : list) {
            if (item instanceof AdapterView) {
                listStrategy.add(new AdapterViewEmptyStrategy((AdapterView)item));
                continue;
            }
            if (!(item instanceof RecyclerView)) continue;
            listStrategy.add(new RecyclerViewEmptyStrategy((RecyclerView)item));
        }
        int count = listStrategy.size();
        if (count <= 0) {
            this.cancelAutoEmptyStrategy();
            return;
        }
        if (count == 1) {
            super.setEmptyStrategy(new AutoEmptyStrategy((HStateEmptyStrategy)listStrategy.get(0)));
        } else {
            HStateEmptyStrategy[] array = new HStateEmptyStrategy[count];
            super.setEmptyStrategy(new AutoEmptyStrategy(new CombineEmptyStrategy(listStrategy.toArray(array))));
        }
    }

    private void cancelAutoEmptyStrategy() {
        if (this.getEmptyStrategy() instanceof AutoEmptyStrategy) {
            super.setEmptyStrategy(null);
        }
    }

    private static List<View> getAllViews(View view) {
        if (view == null) {
            throw new IllegalArgumentException("view is null when getAllViews()");
        }
        ArrayList<View> list = new ArrayList<View>();
        list.add(view);
        if (view instanceof ViewGroup) {
            ViewGroup viewGroup = (ViewGroup)view;
            int count = viewGroup.getChildCount();
            for (int i = 0; i < count; ++i) {
                View child = viewGroup.getChildAt(i);
                if (child == null) continue;
                list.addAll(HAutoEmptyStateLayout.getAllViews(child));
            }
        }
        return list;
    }

    public String getShowText() {
        return this.hText == null ? "" : this.hText;
    }

    public HAutoEmptyStateLayout setShowText(String hText) {
        this.hText = hText;
        return this;
    }

    public boolean ishAutoReplace() {
        return this.hAutoReplace;
    }

    public HAutoEmptyStateLayout sethAutoReplace(boolean hAutoReplace) {
        this.hAutoReplace = hAutoReplace;
        return this;
    }

    private static class AutoEmptyStrategy
    implements HStateEmptyStrategy {
        private final HStateEmptyStrategy mStrategy;

        public AutoEmptyStrategy(HStateEmptyStrategy strategy) {
            if (strategy == null) {
                throw new IllegalArgumentException("strategy is null when create " + AutoEmptyStrategy.class.getSimpleName());
            }
            this.mStrategy = strategy;
        }

        @Override
        public boolean isDestroyed() {
            return this.mStrategy.isDestroyed();
        }

        @Override
        public HStateEmptyStrategy.Result getResult() {
            return this.mStrategy.getResult();
        }
    }
}

