/*
 * Decompiled with CFR 0.152.
 */
package com.zzh.lib.views;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.zzh.lib.views.R;
import com.zzh.lib.views.loader.HImageLoader;

public class HBadgeRadioButton
extends FrameLayout {
    private Context context;
    private ImageView mTopImageIcon;
    private TextView textView;
    private TextView badgeView;
    private final int id = 0;
    int unSelect;
    int select;
    String text;
    boolean isSelected = false;
    boolean zhNetIcon = false;
    private int selectTextColor = -16776961;
    private int unSelectTextColor = -16777216;
    private int badgeTextColor = -1;
    private int badgeBgColor = Color.parseColor((String)"#e84d3e");
    private int textSize = 14;
    private int badgeTextSize = 10;
    private int badgeIconDis = 8;
    private int iconSize = 25;
    private Drawable mSelectDrawable;
    private Drawable mUnSelectDrawable;
    private String mSelectUrl;
    private String mUnSelectUrl;
    OnCheckChangeListener mOnCheckChangeListener;
    private HImageLoader mImageLoader;

    public void setRadioButton(String text, int unSelect, int select, View.OnClickListener onClickListener) {
        this.text = text;
        this.unSelect = unSelect;
        this.select = select;
        this.textView.setText((CharSequence)text);
        if (this.isSelected) {
            this.mTopImageIcon.setBackgroundResource(select);
            this.textView.setTextColor(this.selectTextColor);
        } else {
            this.mTopImageIcon.setBackgroundResource(unSelect);
            this.textView.setTextColor(this.unSelectTextColor);
        }
        if (onClickListener != null) {
            this.setOnClickListener(onClickListener);
        }
    }

    public HBadgeRadioButton setUnSelectTextColor(int unSelectTextColor) {
        this.unSelectTextColor = unSelectTextColor;
        return this;
    }

    public void setSelected(boolean b) {
        this.isSelected = b;
        this.updateTextWidget();
    }

    public boolean isSelected() {
        return this.isSelected;
    }

    public void setImage(Drawable drawable) {
        if (drawable != null) {
            this.mTopImageIcon.setBackground(drawable);
        }
    }

    public void setNum(int num) {
        if (num < 1) {
            this.badgeView.setVisibility(8);
        } else {
            this.badgeView.setVisibility(0);
            if (num > 99) {
                this.badgeView.setText((CharSequence)"99+");
            } else {
                this.badgeView.setText((CharSequence)String.valueOf(num));
            }
        }
    }

    public String getNum() {
        String num = this.badgeView.getText().toString().trim();
        if (null == num || "".equals(num)) {
            num = "0";
        }
        return num;
    }

    public HBadgeRadioButton setText(String text) {
        this.text = text;
        return this;
    }

    public HBadgeRadioButton setSelectTextColor(int color) {
        this.selectTextColor = color;
        return this;
    }

    public HBadgeRadioButton setSelectUrl(String selectUrl) {
        this.mSelectUrl = selectUrl;
        return this;
    }

    public HBadgeRadioButton setUnSelectUrl(String unSelectUrl) {
        this.mUnSelectUrl = unSelectUrl;
        return this;
    }

    public void update() {
        this.textView.setText((CharSequence)this.text);
        this.updateTextWidget();
    }

    public String getText() {
        return "";
    }

    public HBadgeRadioButton(Context context) {
        this(context, null);
    }

    public HBadgeRadioButton(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    private void init(Context context, AttributeSet attrs) {
        this.context = context;
        LayoutInflater.from((Context)context).inflate(R.layout.h_badge_rb, (ViewGroup)this, true);
        if (this.isInEditMode()) {
            return;
        }
        this.mTopImageIcon = (ImageView)this.findViewById(R.id.iv_radio_item);
        this.textView = (TextView)this.findViewById(R.id.tv_radio_item);
        this.badgeView = (TextView)this.findViewById(R.id.tv_radio_num);
        TypedArray mTypedArray = context.obtainStyledAttributes(attrs, R.styleable.HBadgeRadioButton);
        this.selectTextColor = mTypedArray.getColor(R.styleable.HBadgeRadioButton_zh_select_text_color, -65536);
        this.textSize = mTypedArray.getDimensionPixelSize(R.styleable.HBadgeRadioButton_zh_text_size, 14);
        this.badgeTextColor = mTypedArray.getColor(R.styleable.HBadgeRadioButton_zh_badge_text_color, -16711936);
        this.badgeBgColor = mTypedArray.getColor(R.styleable.HBadgeRadioButton_zh_badge_color, -16711936);
        this.badgeTextSize = mTypedArray.getDimensionPixelSize(R.styleable.HBadgeRadioButton_zh_badge_text_size, 10);
        this.iconSize = mTypedArray.getDimensionPixelSize(R.styleable.HBadgeRadioButton_zh_icon_size, 58);
        this.unSelectTextColor = mTypedArray.getColor(R.styleable.HBadgeRadioButton_zh_un_select_text_color, 14);
        this.badgeIconDis = mTypedArray.getDimensionPixelSize(R.styleable.HBadgeRadioButton_zh_text_icon_size, 8);
        this.mSelectDrawable = mTypedArray.getDrawable(R.styleable.HBadgeRadioButton_zh_icon_selected);
        this.mUnSelectDrawable = mTypedArray.getDrawable(R.styleable.HBadgeRadioButton_zh_icon_unselect);
        this.text = mTypedArray.getString(R.styleable.HBadgeRadioButton_zh_text);
        this.isSelected = mTypedArray.getBoolean(R.styleable.HBadgeRadioButton_zh_select, false);
        this.zhNetIcon = mTypedArray.getBoolean(R.styleable.HBadgeRadioButton_zh_icon_net, false);
        this.mSelectUrl = mTypedArray.getString(R.styleable.HBadgeRadioButton_zh_icon_select_url);
        this.mUnSelectUrl = mTypedArray.getString(R.styleable.HBadgeRadioButton_zh_icon_unselect_url);
        mTypedArray.recycle();
        this.drawBadge();
        this.drawTextWidget();
        this.drawIconWidget();
        this.updateTextWidget();
        this.setOnClickListener(v -> {
            this.isSelected = !this.isSelected;
            this.updateTextWidget();
            if (this.mOnCheckChangeListener != null) {
                this.mOnCheckChangeListener.onCheckChange(this, this.isSelected);
            }
        });
    }

    private void drawIconWidget() {
        RelativeLayout.LayoutParams layoutParams = (RelativeLayout.LayoutParams)this.mTopImageIcon.getLayoutParams();
        if (layoutParams != null) {
            layoutParams.width = this.iconSize;
            layoutParams.height = this.iconSize;
        }
        this.mTopImageIcon.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
    }

    private void drawBadge() {
        GradientDrawable gd = new GradientDrawable();
        gd.setCornerRadius(20.0f);
        gd.setColor(this.badgeBgColor);
        this.badgeView.setBackground((Drawable)gd);
        this.badgeView.setTextColor(this.badgeTextColor);
        this.badgeView.setTextSize(0, (float)this.badgeTextSize);
    }

    private void drawTextWidget() {
        RelativeLayout.LayoutParams layoutParams = (RelativeLayout.LayoutParams)this.textView.getLayoutParams();
        if (layoutParams != null) {
            layoutParams.topMargin = this.badgeIconDis;
        }
        this.textView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        this.textView.setText((CharSequence)this.text);
        this.textView.setTextSize(0, (float)this.textSize);
    }

    void updateTextColor() {
        if (this.isSelected) {
            this.textView.setTextColor(this.selectTextColor);
        } else {
            this.textView.setTextColor(this.unSelectTextColor);
        }
    }

    void updateTopImage() {
        if (this.zhNetIcon) {
            if (this.isSelected) {
                this.mTopImageIcon.setImageDrawable(this.mSelectDrawable);
                if (this.mImageLoader != null) {
                    this.mImageLoader.loadImage(this.mTopImageIcon, this.mSelectUrl);
                }
            } else if (this.mImageLoader != null) {
                this.mImageLoader.loadImage(this.mTopImageIcon, this.mUnSelectUrl);
            }
        } else if (this.isSelected) {
            this.mTopImageIcon.setImageDrawable(this.mSelectDrawable);
        } else {
            this.mTopImageIcon.setImageDrawable(this.mUnSelectDrawable);
        }
    }

    void updateTextWidget() {
        this.updateTextColor();
        this.updateTopImage();
    }

    public HBadgeRadioButton(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    public HBadgeRadioButton(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init(context, attrs);
    }

    public void setImageLoader(HImageLoader imageLoader) {
        this.mImageLoader = imageLoader;
        this.update();
    }

    public OnCheckChangeListener getOnCheckChangeListener() {
        return this.mOnCheckChangeListener;
    }

    public void setOnCheckChangeListener(OnCheckChangeListener onCheckChangeListener) {
        this.mOnCheckChangeListener = onCheckChangeListener;
    }

    public HBadgeRadioButton setTextVisibility(int visible) {
        if (this.textView != null) {
            this.textView.setVisibility(visible);
        }
        return this;
    }

    public int getTextVisibility() {
        return this.textView.getVisibility();
    }

    public static interface OnCheckChangeListener {
        public void onCheckChange(HBadgeRadioButton var1, boolean var2);
    }
}

