/*
 * Decompiled with CFR 0.152.
 */
package com.zzh.lib.views;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.CountDownTimer;
import android.util.AttributeSet;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.widget.AppCompatTextView;
import com.zzh.lib.views.R;

public class HCountDownTextView
extends AppCompatTextView {
    long millisInFuture = 60000L;
    long countDownInterval = 1000L;
    private HCountDownCallback mCountDownCallback;
    private CountDownTimer mCountDownTimer = null;

    public HCountDownTextView(@NonNull Context context) {
        super(context);
        this.init(context, null);
    }

    public HCountDownTextView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public HCountDownTextView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    public void setCountDownCallback(HCountDownCallback countDownCallback) {
        this.mCountDownCallback = countDownCallback;
    }

    public long getMillisInFuture() {
        return this.millisInFuture;
    }

    public long getCountDownInterval() {
        return this.countDownInterval;
    }

    public void setMIFAndCDI(long millisInFuture, long countDownInterval) {
        this.checkArgs(millisInFuture, countDownInterval);
        this.millisInFuture = millisInFuture;
        this.countDownInterval = countDownInterval;
    }

    private void checkArgs(long millisInFuture, long countDownInterval) {
        if (millisInFuture <= 0L || countDownInterval <= 0L || millisInFuture < countDownInterval) {
            throw new RuntimeException("\u8bbe\u7f6e\u5012\u8ba1\u65f6\u65f6\u95f4\u548c\u95f4\u9694 \u53c2\u6570\u9519\u8bef\uff1a\u8981\u6c42millisInFuture > 0 && countDownInterval > 0 && countDownInterval >= millisInFuture");
        }
    }

    private void init(Context context, AttributeSet attrs) {
        if (attrs != null) {
            TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.HCountDownTextView);
            this.millisInFuture = ta.getInteger(R.styleable.HCountDownTextView_zh_millis_in_future, 60000);
            this.countDownInterval = ta.getInteger(R.styleable.HCountDownTextView_zh_count_down_interval, 1000);
            ta.recycle();
            this.checkArgs(this.millisInFuture, this.countDownInterval);
        }
        super.setOnClickListener(v -> {
            boolean clickContinue = true;
            if (this.mCountDownCallback != null) {
                clickContinue = this.mCountDownCallback.onClick(this);
            }
            if (clickContinue) {
                this.startTimer();
            }
        });
    }

    public void setOnClickListener(@Nullable View.OnClickListener l) {
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.cancelTimer();
        this.mCountDownTimer = null;
    }

    public void startTimer() {
        this.startTimer(this.millisInFuture, this.countDownInterval);
        this.setEnabled(false);
    }

    public void startTimer(long millisInFuture, long countDownInterval) {
        if (this.mCountDownTimer == null && this.mCountDownTimer == null) {
            this.mCountDownTimer = new CountDownTimer(millisInFuture, countDownInterval){

                public void onTick(long millisUntilFinished) {
                    if (HCountDownTextView.this.mCountDownCallback != null) {
                        HCountDownTextView.this.mCountDownCallback.onTick(HCountDownTextView.this, millisUntilFinished);
                    }
                    HCountDownTextView.this.setEnabled(false);
                }

                public void onFinish() {
                    if (HCountDownTextView.this.mCountDownCallback != null) {
                        HCountDownTextView.this.mCountDownCallback.onFinish(HCountDownTextView.this);
                    }
                    HCountDownTextView.this.setEnabled(true);
                }
            };
        }
        this.setEnabled(false);
        this.mCountDownTimer.start();
    }

    public void cancelTimer() {
        if (this.mCountDownTimer != null) {
            this.mCountDownTimer.cancel();
            if (this.mCountDownCallback != null) {
                this.mCountDownCallback.onCancel(this);
            }
        }
        this.setEnabled(true);
    }

    public static abstract class HCountDownCallback {
        public abstract void onTick(HCountDownTextView var1, long var2);

        public abstract void onFinish(HCountDownTextView var1);

        public boolean onClick(HCountDownTextView textView) {
            return true;
        }

        public void onCancel(HCountDownTextView textView) {
        }
    }
}

