/*
 * Decompiled with CFR 0.152.
 */
package com.zzh.lib.views;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.view.View;
import androidx.annotation.ColorInt;
import androidx.recyclerview.widget.RecyclerView;

public class HDivideLine
extends RecyclerView.ItemDecoration {
    private static final int HORIZONTAL_LIST = 0;
    private static final int VERTICAL_LIST = 1;
    private int mSpace = 1;
    private final Rect mRect = new Rect(0, 0, 0, 0);
    private final Paint mPaint = new Paint();
    private final int mOrientation;

    private HDivideLine(int orientation, @ColorInt int color, int space) {
        this.mOrientation = orientation;
        if (space > 0) {
            this.mSpace = space;
        }
        this.mPaint.setColor(color);
    }

    public void onDraw(Canvas c, RecyclerView parent, RecyclerView.State state) {
        super.onDraw(c, parent, state);
        if (this.mOrientation == 1) {
            this.drawVertical(c, parent);
        } else {
            this.drawHorizontal(c, parent);
        }
    }

    public void drawVertical(Canvas c, RecyclerView parent) {
        int left = parent.getPaddingLeft();
        int right = parent.getWidth() - parent.getPaddingRight();
        int childCount = parent.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            View child = parent.getChildAt(i);
            RecyclerView.LayoutParams params = (RecyclerView.LayoutParams)child.getLayoutParams();
            int top = child.getBottom() + params.bottomMargin;
            int bottom = top + this.mSpace;
            this.mRect.set(left, top, right, bottom);
            c.drawRect(this.mRect, this.mPaint);
        }
    }

    public void drawHorizontal(Canvas c, RecyclerView parent) {
        int top = parent.getPaddingTop();
        int bottom = parent.getHeight() - parent.getPaddingBottom();
        int childCount = parent.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            View child = parent.getChildAt(i);
            RecyclerView.LayoutParams params = (RecyclerView.LayoutParams)child.getLayoutParams();
            int left = child.getRight() + params.rightMargin;
            int right = left + this.mSpace;
            this.mRect.set(left, top, right, bottom);
            c.drawRect(this.mRect, this.mPaint);
        }
    }

    public void getItemOffsets(Rect outRect, View view, RecyclerView parent, RecyclerView.State state) {
        super.getItemOffsets(outRect, view, parent, state);
        if (this.mOrientation == 1) {
            outRect.set(0, 0, 0, this.mSpace);
        } else {
            outRect.set(0, 0, this.mSpace, 0);
        }
    }

    public static HDivideLine createVertical(@ColorInt int color, int height) {
        return new HDivideLine(1, color, height);
    }

    public static HDivideLine createHorizontal(@ColorInt int color, int width) {
        return new HDivideLine(0, color, width);
    }
}

