/*
 * Decompiled with CFR 0.152.
 */
package com.zzh.lib.views;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.Typeface;
import android.util.AttributeSet;
import android.view.View;
import com.zzh.lib.views.R;
import java.math.BigDecimal;
import java.math.MathContext;

public class HRoundProgressBar
extends View {
    private final Paint paint = new Paint();
    private int roundColor;
    private int roundProgressColor;
    private int textColor;
    private float textSize;
    private float roundWidth;
    private int max;
    private int progress;
    private final boolean textIsDisplayable;
    private final int style;
    public static final int STROKE = 0;
    public static final int FILL = 1;

    public HRoundProgressBar(Context context) {
        this(context, null);
    }

    public HRoundProgressBar(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public HRoundProgressBar(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        TypedArray mTypedArray = context.obtainStyledAttributes(attrs, R.styleable.HRoundProgressBar);
        this.roundColor = mTypedArray.getColor(R.styleable.HRoundProgressBar_zh_round_color, -65536);
        this.roundProgressColor = mTypedArray.getColor(R.styleable.HRoundProgressBar_zh_round_progress_color, -16711936);
        this.textColor = mTypedArray.getColor(R.styleable.HRoundProgressBar_zh_text_color, -16711936);
        this.textSize = mTypedArray.getDimensionPixelSize(R.styleable.HRoundProgressBar_zh_text_size, 32);
        this.roundWidth = mTypedArray.getDimension(R.styleable.HRoundProgressBar_zh_round_width, 15.0f);
        this.max = mTypedArray.getInteger(R.styleable.HRoundProgressBar_zh_max, 60);
        this.textIsDisplayable = mTypedArray.getBoolean(R.styleable.HRoundProgressBar_zh_text_is_displayable, false);
        this.style = mTypedArray.getInt(R.styleable.HRoundProgressBar_zh_style, 0);
        mTypedArray.recycle();
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        int centre = this.getWidth() / 2;
        int radius = (int)((float)centre - this.roundWidth / 2.0f);
        this.paint.setColor(this.roundColor);
        this.paint.setStyle(Paint.Style.STROKE);
        this.paint.setStrokeWidth(this.roundWidth);
        this.paint.setAntiAlias(true);
        canvas.drawCircle((float)centre, (float)centre, (float)radius, this.paint);
        this.paint.setStrokeWidth(0.0f);
        this.paint.setColor(this.textColor);
        this.paint.setTextSize(this.textSize);
        this.paint.setTypeface(Typeface.DEFAULT_BOLD);
        int percent = (int)((float)this.progress / (float)this.max * 100.0f);
        float textWidth = this.paint.measureText(percent + "%");
        if (this.textIsDisplayable && percent != 0 && this.style == 0) {
            canvas.drawText(percent + "%", (float)centre - textWidth / 2.0f, (float)centre + this.textSize / 2.0f, this.paint);
        }
        this.paint.setStrokeWidth(this.roundWidth);
        this.paint.setColor(this.roundProgressColor);
        RectF oval = new RectF((float)(centre - radius), (float)(centre - radius), (float)(centre + radius), (float)(centre + radius));
        switch (this.style) {
            case 0: {
                this.paint.setStyle(Paint.Style.STROKE);
                canvas.drawArc(oval, 0.0f, (float)(360 * this.progress / this.max), false, this.paint);
                break;
            }
            case 1: {
                BigDecimal pro = new BigDecimal(Integer.toString(this.progress));
                BigDecimal mMax = new BigDecimal(Integer.toString(this.max));
                int scale = 2;
                float result = pro.divide(mMax, new MathContext(3)).floatValue();
                this.paint.setStyle(Paint.Style.FILL_AND_STROKE);
                if (this.progress == 0) break;
                canvas.drawArc(oval, 0.0f, 360.0f * result, true, this.paint);
                break;
            }
        }
    }

    public synchronized int getMax() {
        return this.max;
    }

    public synchronized void setMax(int max) {
        if (max < 0) {
            throw new IllegalArgumentException("max not less than 0");
        }
        this.max = max;
    }

    public synchronized int getProgress() {
        return this.progress;
    }

    public synchronized void setProgress(int progress) {
        if (progress < 0) {
            throw new IllegalArgumentException("progress not less than 0");
        }
        if (progress > this.max) {
            progress = this.max;
        }
        if (progress <= this.max) {
            this.progress = progress;
            this.postInvalidate();
        }
    }

    public int getCricleColor() {
        return this.roundColor;
    }

    public void setCricleColor(int cricleColor) {
        this.roundColor = cricleColor;
    }

    public int getCricleProgressColor() {
        return this.roundProgressColor;
    }

    public void setCricleProgressColor(int cricleProgressColor) {
        this.roundProgressColor = cricleProgressColor;
    }

    public int getTextColor() {
        return this.textColor;
    }

    public void setTextColor(int textColor) {
        this.textColor = textColor;
    }

    public float getTextSize() {
        return this.textSize;
    }

    public void setTextSize(float textSize) {
        this.textSize = textSize;
    }

    public float getRoundWidth() {
        return this.roundWidth;
    }

    public void setRoundWidth(float roundWidth) {
        this.roundWidth = roundWidth;
    }
}

