/*
 * Decompiled with CFR 0.152.
 */
package com.zzh.lib.views;

import android.content.Context;
import android.graphics.Canvas;
import android.util.AttributeSet;
import androidx.annotation.Nullable;
import com.zzh.lib.views.banner.AttrsController;
import com.zzh.lib.views.banner.BaseIndicatorView;
import com.zzh.lib.views.banner.IndicatorOptions;
import com.zzh.lib.views.drawer.BaseDrawer;
import com.zzh.lib.views.drawer.DrawerProxy;

public class IndicatorView
extends BaseIndicatorView {
    private DrawerProxy mDrawerProxy;

    private void initPIV(AttributeSet attrs) {
        AttrsController.initAttrs(this.context, attrs, this.mIndicatorOptions);
        this.mDrawerProxy = new DrawerProxy(this.mIndicatorOptions);
    }

    public IndicatorView(Context context) {
        super(context);
        this.initPIV(null);
    }

    public IndicatorView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.initPIV(attrs);
    }

    public IndicatorView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initPIV(attrs);
    }

    public IndicatorView(Context context, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.initPIV(attrs);
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        this.mDrawerProxy.onLayout(changed, left, top, right, bottom);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        BaseDrawer.MeasureResult measureResult = this.mDrawerProxy.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.setMeasuredDimension(measureResult.getMeasureWidth(), measureResult.getMeasureHeight());
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        this.rotateCanvas(canvas);
        this.mDrawerProxy.onDraw(canvas);
    }

    @Override
    public void setIndicatorOptions(IndicatorOptions options) {
        super.setIndicatorOptions(options);
        this.mDrawerProxy.setIndicatorOptions(options);
    }

    @Override
    public void notifyDataChanged() {
        this.mDrawerProxy = new DrawerProxy(this.mIndicatorOptions);
        super.notifyDataChanged();
    }

    public void rotateCanvas(Canvas canvas) {
        if (this.mIndicatorOptions.getOrientation() == 1) {
            canvas.rotate(90.0f, (float)this.getWidth() / 2.0f, (float)this.getWidth() / 2.0f);
        } else if (this.mIndicatorOptions.getOrientation() == 3) {
            canvas.rotate(180.0f, (float)this.getHeight() / 2.0f, (float)this.getHeight() / 2.0f);
        }
    }

    public void setOrientation(int orientation) {
        this.mIndicatorOptions.setOrientation(orientation);
    }
}

