/*
 * Decompiled with CFR 0.152.
 */
package com.zzh.lib.views.adapter;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import com.zzh.lib.views.adapter.holder.HSuperViewHolder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public abstract class HBaseAdapter<T>
extends BaseAdapter {
    protected List<T> mData = new ArrayList<T>();

    public int getCount() {
        return this.mData.size();
    }

    public T getItem(int position) {
        return this.mData.get(position);
    }

    public long getItemId(int position) {
        return position;
    }

    public void setNewInstance(List<T> data) {
        if (data != null) {
            this.mData = data;
        } else {
            this.mData.addAll(data);
        }
        this.notifyDataSetChanged();
    }

    public void addAll(Collection<? extends T> data) {
        this.mData.addAll(data);
        this.notifyDataSetChanged();
    }

    public void add(T data) {
        this.mData.add(data);
        this.notifyDataSetChanged();
    }

    public void clear() {
        this.mData.clear();
        this.notifyDataSetChanged();
    }

    public void remove(T data) {
        this.mData.remove(data);
        this.notifyDataSetChanged();
    }

    public void remove(int index) {
        this.mData.remove(index);
        this.notifyDataSetChanged();
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        HSuperViewHolder holder;
        if (convertView == null) {
            convertView = LayoutInflater.from((Context)parent.getContext()).inflate(this.getLayoutRes(), parent, false);
            holder = new HSuperViewHolder(convertView);
            convertView.setTag((Object)holder);
        } else {
            holder = (HSuperViewHolder)((Object)convertView.getTag());
        }
        this.onBindViewData(holder, this.getItem(position), position);
        return convertView;
    }

    protected abstract int getLayoutRes();

    protected abstract void onBindViewData(HSuperViewHolder var1, T var2, int var3);
}

