/*
 * Decompiled with CFR 0.152.
 */
package com.zzh.lib.views.adapter;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.viewpager.widget.PagerAdapter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public abstract class HBaseViewPagerAdapter<T>
extends PagerAdapter {
    Context context;
    private List<T> dataList = new ArrayList<T>();

    public HBaseViewPagerAdapter(Context context) {
        this.context = context;
    }

    protected abstract View getItemView(Context var1, T var2, int var3);

    public int getCount() {
        if (this.dataList.size() <= 1) {
            return this.dataList.size();
        }
        return Integer.MAX_VALUE;
    }

    public int getListSize() {
        return this.dataList.size();
    }

    public void setNewInstance(Collection<? extends T> data) {
        if (data == null) {
            this.dataList.clear();
        } else {
            this.dataList.clear();
            this.dataList.addAll(data);
        }
        this.notifyDataSetChanged();
    }

    public void addData(T data) {
        this.dataList.add(data);
        this.notifyDataSetChanged();
    }

    public void addData(Collection<? extends T> data) {
        this.dataList.addAll(data);
        this.notifyDataSetChanged();
    }

    public boolean isViewFromObject(@NonNull View view, @NonNull Object object) {
        return view == object;
    }

    public Object instantiateItem(@NonNull ViewGroup container, int position) {
        int p = position % this.dataList.size();
        T data = this.dataList.get(p);
        View view = this.getItemView(this.context, data, position);
        container.addView(view);
        return view;
    }

    public void destroyItem(ViewGroup container, int position, Object object) {
        container.removeView((View)object);
    }
}

