/*
 * Decompiled with CFR 0.152.
 */
package com.zzh.lib.views.adapter.holder;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.util.SparseArray;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.ColorInt;
import androidx.annotation.ColorRes;
import androidx.annotation.DrawableRes;
import androidx.annotation.IdRes;
import androidx.annotation.StringRes;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.RecyclerView;

public class HSuperViewHolder
extends RecyclerView.ViewHolder {
    private final SparseArray<View> views = new SparseArray();

    public HSuperViewHolder(View itemView) {
        super(itemView);
    }

    public <T extends View> T getView(int viewId) {
        View view = (View)this.views.get(viewId);
        if (view == null) {
            view = this.itemView.findViewById(viewId);
            this.views.put(viewId, (Object)view);
        }
        return (T)view;
    }

    public <V extends View> V findViewById(int viewId) {
        return (V)this.getView(viewId);
    }

    public void setText(int viewId, CharSequence text) {
        Object view = this.findViewById(viewId);
        if (view instanceof TextView) {
            ((TextView)view).setText(text);
        }
    }

    public void setText(int viewId, @StringRes int textId) {
        Object view = this.findViewById(viewId);
        if (view instanceof TextView) {
            ((TextView)view).setText(textId);
        }
    }

    public void setTextColor(int viewId, @ColorInt int colorId) {
        Object view = this.findViewById(viewId);
        if (view instanceof TextView) {
            ((TextView)view).setTextColor(colorId);
        }
    }

    public void setTextColorRes(@IdRes int viewId, @ColorRes int colorRes) {
        Object view = this.findViewById(viewId);
        if (view instanceof TextView) {
            ((TextView)view).setTextColor(ContextCompat.getColor((Context)this.itemView.getContext(), (int)colorRes));
        }
    }

    public void setOnClickListener(int viewId, View.OnClickListener clickListener) {
        this.findViewById(viewId).setOnClickListener(clickListener);
    }

    public void setBackgroundResource(int viewId, @DrawableRes int resId) {
        this.findViewById(viewId).setBackgroundResource(resId);
    }

    public void setBackgroundColor(int viewId, @ColorInt int colorId) {
        this.findViewById(viewId).setBackgroundColor(colorId);
    }

    public void setImageResource(@IdRes int viewId, @DrawableRes int resId) {
        Object view = this.findViewById(viewId);
        if (view instanceof ImageView) {
            ((ImageView)view).setImageResource(resId);
        }
    }

    public void setImageDrawable(@IdRes int viewId, Drawable drawable) {
        Object view = this.findViewById(viewId);
        if (view instanceof ImageView) {
            ((ImageView)view).setImageDrawable(drawable);
        }
    }

    public void setImageBitmap(@IdRes int viewId, Bitmap bitmap) {
        ImageView view = (ImageView)this.findViewById(viewId);
        view.setImageBitmap(bitmap);
    }

    public void setVisibility(@IdRes int resId, int visibility) {
        this.findViewById(resId).setVisibility(visibility);
    }
}

