/*
 * Decompiled with CFR 0.152.
 */
package com.zzh.lib.views.banner;

import android.content.Context;
import android.os.Build;
import android.util.AttributeSet;
import androidx.annotation.NonNull;
import androidx.viewpager2.widget.CompositePageTransformer;
import androidx.viewpager2.widget.MarginPageTransformer;
import androidx.viewpager2.widget.ViewPager2;
import com.zzh.lib.views.banner.AttributeController;
import com.zzh.lib.views.banner.BannerOptions;
import com.zzh.lib.views.transform.OverlapPageTransformer;
import com.zzh.lib.views.transform.ScaleInTransformer;

public class BannerManager {
    private BannerOptions mBannerOptions = new BannerOptions();
    private final AttributeController mAttributeController = new AttributeController(this.mBannerOptions);
    private final CompositePageTransformer mCompositePageTransformer = new CompositePageTransformer();
    private MarginPageTransformer mMarginPageTransformer;
    private ViewPager2.PageTransformer mDefaultPageTransformer;

    public BannerOptions getBannerOptions() {
        if (this.mBannerOptions == null) {
            this.mBannerOptions = new BannerOptions();
        }
        return this.mBannerOptions;
    }

    public void initAttrs(Context context, AttributeSet attrs) {
        this.mAttributeController.init(context, attrs);
    }

    public CompositePageTransformer getCompositePageTransformer() {
        return this.mCompositePageTransformer;
    }

    public void addTransformer(@NonNull ViewPager2.PageTransformer transformer) {
        this.mCompositePageTransformer.addTransformer(transformer);
    }

    public void removeTransformer(@NonNull ViewPager2.PageTransformer transformer) {
        this.mCompositePageTransformer.removeTransformer(transformer);
    }

    public void removeMarginPageTransformer() {
        if (this.mMarginPageTransformer != null) {
            this.mCompositePageTransformer.removeTransformer((ViewPager2.PageTransformer)this.mMarginPageTransformer);
        }
    }

    public void removeDefaultPageTransformer() {
        if (this.mDefaultPageTransformer != null) {
            this.mCompositePageTransformer.removeTransformer(this.mDefaultPageTransformer);
        }
    }

    public void setPageMargin(int pageMargin) {
        this.mBannerOptions.setPageMargin(pageMargin);
    }

    public void createMarginTransformer() {
        this.removeMarginPageTransformer();
        this.mMarginPageTransformer = new MarginPageTransformer(this.mBannerOptions.getPageMargin());
        this.mCompositePageTransformer.addTransformer((ViewPager2.PageTransformer)this.mMarginPageTransformer);
    }

    public void setMultiPageStyle(boolean overlap, float scale) {
        this.removeDefaultPageTransformer();
        this.mDefaultPageTransformer = overlap && Build.VERSION.SDK_INT >= 21 ? new OverlapPageTransformer(this.mBannerOptions.getOrientation(), scale, 0.0f, 1.0f, 0.0f) : new ScaleInTransformer(scale);
        this.mCompositePageTransformer.addTransformer(this.mDefaultPageTransformer);
    }
}

