/*
 * Decompiled with CFR 0.152.
 */
package com.zzh.lib.views.banner;

import android.animation.ValueAnimator;
import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import androidx.annotation.ColorInt;
import androidx.annotation.Nullable;
import androidx.viewpager.widget.ViewPager;
import androidx.viewpager2.widget.ViewPager2;
import com.zzh.lib.views.banner.IndicatorOptions;
import com.zzh.lib.views.def.IIndicator;

public class BaseIndicatorView
extends View
implements IIndicator {
    public static final long DEFAULT_ANIMATION_DURATION = 200L;
    public ValueAnimator valueAnimator = ValueAnimator.ofFloat((float[])new float[]{-1.0f, 1.0f});
    protected Context context;
    protected IndicatorOptions mIndicatorOptions;
    private ViewPager mViewPager = null;
    private ViewPager2 mViewPager2 = null;
    private ViewPager2.OnPageChangeCallback mOnPageChangeCallback = new ViewPager2.OnPageChangeCallback(){

        public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
            BaseIndicatorView.this.onPageScrolled(position, positionOffset, positionOffsetPixels);
        }

        public void onPageSelected(int position) {
            BaseIndicatorView.this.onPageSelected(position);
        }

        public void onPageScrollStateChanged(int state) {
            BaseIndicatorView.this.onPageScrollStateChanged(state);
        }
    };

    public BaseIndicatorView(Context context) {
        super(context);
        this.init(context);
    }

    private void init(Context context) {
        this.context = context;
        this.mIndicatorOptions = new IndicatorOptions();
        this.valueAnimator.setDuration(200L);
    }

    public BaseIndicatorView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public BaseIndicatorView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context);
    }

    public BaseIndicatorView(Context context, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init(context);
    }

    public void onPageSelected(int position) {
        if (this.getSlideMode() == 0) {
            this.setCurrentPosition(position);
            this.setSlideProgress(0.0f);
            this.invalidate();
        }
    }

    public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
        if (this.getSlideMode() != 0 && this.getPageSize() > 1) {
            this.scrollSlider(position, positionOffset);
            this.invalidate();
        }
    }

    private void scrollSlider(int position, float positionOffset) {
        if (this.mIndicatorOptions.getSlideMode() == 4 || this.mIndicatorOptions.getSlideMode() == 5) {
            this.setCurrentPosition(position);
            this.setSlideProgress(positionOffset);
        } else if (position % this.getPageSize() == this.getPageSize() - 1) {
            if ((double)positionOffset < 0.5) {
                this.setCurrentPosition(position);
                this.setSlideProgress(0.0f);
            } else {
                this.setCurrentPosition(0);
                this.setSlideProgress(0.0f);
            }
        } else {
            this.setCurrentPosition(position);
            this.setSlideProgress(positionOffset);
        }
    }

    @Override
    public void notifyDataChanged() {
        this.setupViewPager();
        this.requestLayout();
        this.invalidate();
    }

    private void setupViewPager() {
        if (this.mViewPager != null) {
            this.mViewPager.removeOnPageChangeListener((ViewPager.OnPageChangeListener)this);
            this.mViewPager.addOnPageChangeListener((ViewPager.OnPageChangeListener)this);
            if (this.mViewPager.getAdapter() != null) {
                this.setPageSize(this.mViewPager.getAdapter().getCount());
            }
        }
        if (this.mViewPager2 != null) {
            this.mViewPager2.unregisterOnPageChangeCallback(this.mOnPageChangeCallback);
            this.mViewPager2.registerOnPageChangeCallback(this.mOnPageChangeCallback);
            if (this.mViewPager2.getAdapter() != null) {
                this.setPageSize(this.mViewPager2.getAdapter().getItemCount());
            }
        }
    }

    public float getNormalSlideWidth() {
        return this.mIndicatorOptions.getNormalSliderWidth();
    }

    public void setNormalSlideWidth(float normalSliderWidth) {
        this.mIndicatorOptions.setNormalSliderWidth(normalSliderWidth);
    }

    public float getCheckedSlideWidth() {
        return this.mIndicatorOptions.getCheckedSliderWidth();
    }

    public void setCheckedSlideWidth(float checkedSliderWidth) {
        this.mIndicatorOptions.setCheckedSliderWidth(checkedSliderWidth);
    }

    public void setCurrentPosition(int currentPosition) {
        this.mIndicatorOptions.setCurrentPosition(currentPosition);
    }

    public int getCurrentPosition() {
        return this.mIndicatorOptions.getCurrentPosition();
    }

    public void getIndicatorGap(float indicatorGap) {
        this.mIndicatorOptions.setSliderGap(indicatorGap);
    }

    public void setIndicatorGap(float indicatorGap) {
        this.mIndicatorOptions.setSliderGap(indicatorGap);
    }

    public void setCheckedColor(@ColorInt int normalColor) {
        this.mIndicatorOptions.setCheckedSliderColor(normalColor);
    }

    public int getCheckedColor() {
        return this.mIndicatorOptions.getCheckedSliderColor();
    }

    public void setNormalColor(@ColorInt int normalColor) {
        this.mIndicatorOptions.setNormalSliderColor(normalColor);
    }

    public float getSlideProgress() {
        return this.mIndicatorOptions.getSlideProgress();
    }

    public void setSlideProgress(float slideProgress) {
        this.mIndicatorOptions.setSlideProgress(slideProgress);
    }

    public int getPageSize() {
        return this.mIndicatorOptions.getPageSize();
    }

    public BaseIndicatorView setPageSize(int pageSize) {
        this.mIndicatorOptions.setPageSize(pageSize);
        return this;
    }

    public BaseIndicatorView setSliderColor(@ColorInt int normalColor, @ColorInt int selectedColor) {
        this.mIndicatorOptions.setSliderColor(normalColor, selectedColor);
        return this;
    }

    public BaseIndicatorView setSliderWidth(float sliderWidth) {
        this.mIndicatorOptions.setSliderWidth(sliderWidth);
        return this;
    }

    public BaseIndicatorView setSliderWidth(float normalSliderWidth, float selectedSliderWidth) {
        this.mIndicatorOptions.setSliderWidth(normalSliderWidth, selectedSliderWidth);
        return this;
    }

    public BaseIndicatorView setSliderGap(float sliderGap) {
        this.mIndicatorOptions.setSliderGap(sliderGap);
        return this;
    }

    public int getSlideMode() {
        return this.mIndicatorOptions.getSlideMode();
    }

    public BaseIndicatorView setSlideMode(int slideMode) {
        this.mIndicatorOptions.setSlideMode(slideMode);
        return this;
    }

    public BaseIndicatorView setIndicatorStyle(int indicatorStyle) {
        this.mIndicatorOptions.setIndicatorStyle(indicatorStyle);
        return this;
    }

    public BaseIndicatorView setSliderHeight(float sliderHeight) {
        this.mIndicatorOptions.setSliderHeight(sliderHeight);
        return this;
    }

    public void setupWithViewPager(ViewPager viewPager) {
        this.mViewPager = viewPager;
        this.notifyDataChanged();
    }

    public void setupWithViewPager(ViewPager2 viewPager2) {
        this.mViewPager2 = viewPager2;
        this.notifyDataChanged();
    }

    public void showIndicatorWhenOneItem(boolean showIndicatorWhenOneItem) {
        this.mIndicatorOptions.showIndicatorOneItem = showIndicatorWhenOneItem;
    }

    public void onPageScrollStateChanged(int state) {
    }

    @Override
    public void setIndicatorOptions(IndicatorOptions options) {
        this.mIndicatorOptions = options;
    }
}

