/*
 * Decompiled with CFR 0.152.
 */
package com.zzh.lib.views.drag;

import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.ItemTouchHelper;
import androidx.recyclerview.widget.RecyclerView;

public class OnDragItemTouchCallback
extends ItemTouchHelper.Callback {
    private final ItemTouchAdapter itemTouchAdapter;
    private Drawable background = null;
    private int bkcolor = -1;
    private OnDragListener onDragListener;

    public OnDragItemTouchCallback(ItemTouchAdapter itemTouchAdapter) {
        this.itemTouchAdapter = itemTouchAdapter;
    }

    public OnDragItemTouchCallback setOnDragListener(OnDragListener onDragListener) {
        this.onDragListener = onDragListener;
        return this;
    }

    public int getMovementFlags(RecyclerView recyclerView, RecyclerView.ViewHolder viewHolder) {
        if (recyclerView.getLayoutManager() instanceof GridLayoutManager) {
            int dragFlags = 15;
            boolean swipeFlags = false;
            return OnDragItemTouchCallback.makeMovementFlags((int)15, (int)0);
        }
        int dragFlags = 3;
        boolean swipeFlags = false;
        return OnDragItemTouchCallback.makeMovementFlags((int)3, (int)0);
    }

    public boolean onMove(RecyclerView recyclerView, RecyclerView.ViewHolder viewHolder, RecyclerView.ViewHolder target) {
        int fromPosition = viewHolder.getBindingAdapterPosition();
        int toPosition = target.getBindingAdapterPosition();
        this.itemTouchAdapter.onMove(fromPosition, toPosition);
        return true;
    }

    public void onSwiped(RecyclerView.ViewHolder viewHolder, int direction) {
        int position = viewHolder.getBindingAdapterPosition();
        this.itemTouchAdapter.onSwiped(position);
    }

    public void onChildDraw(Canvas c, RecyclerView recyclerView, RecyclerView.ViewHolder viewHolder, float dX, float dY, int actionState, boolean isCurrentlyActive) {
        if (actionState == 1) {
            float alpha = 1.0f - Math.abs(dX) / (float)viewHolder.itemView.getWidth();
            viewHolder.itemView.setAlpha(alpha);
            viewHolder.itemView.setTranslationX(dX);
        } else {
            super.onChildDraw(c, recyclerView, viewHolder, dX, dY, actionState, isCurrentlyActive);
        }
    }

    public void onSelectedChanged(RecyclerView.ViewHolder viewHolder, int actionState) {
        if (actionState != 0) {
            if (this.background == null && this.bkcolor == -1) {
                Drawable drawable = viewHolder.itemView.getBackground();
                if (drawable == null) {
                    this.bkcolor = 0;
                } else {
                    this.background = drawable;
                }
            }
            viewHolder.itemView.setBackgroundColor(0);
        }
        super.onSelectedChanged(viewHolder, actionState);
    }

    public void clearView(RecyclerView recyclerView, RecyclerView.ViewHolder viewHolder) {
        super.clearView(recyclerView, viewHolder);
        viewHolder.itemView.setAlpha(1.0f);
        if (this.background != null) {
            viewHolder.itemView.setBackground(this.background);
        }
        if (this.bkcolor != -1) {
            viewHolder.itemView.setBackgroundColor(this.bkcolor);
        }
        if (this.onDragListener != null) {
            this.onDragListener.onFinishDrag();
        }
    }

    public boolean isLongPressDragEnabled() {
        return false;
    }

    public boolean isItemViewSwipeEnabled() {
        return true;
    }

    public static interface OnDragListener {
        public void onFinishDrag();
    }

    public static interface ItemTouchAdapter {
        public void onMove(int var1, int var2);

        public void onSwiped(int var1);
    }
}

