/*
 * Decompiled with CFR 0.152.
 */
package com.zzh.lib.views.drawer;

import android.animation.ArgbEvaluator;
import android.graphics.Paint;
import com.zzh.lib.views.banner.IndicatorOptions;
import com.zzh.lib.views.drawer.IDrawer;

public abstract class BaseDrawer
implements IDrawer {
    public static final int INDICATOR_PADDING_ADDITION = 6;
    public static final int INDICATOR_PADDING = 3;
    private MeasureResult mMeasureResult;
    public float maxWidth = 0.0f;
    public float minWidth = 0.0f;
    public Paint mPaint = new Paint();
    public ArgbEvaluator argbEvaluator = null;
    protected IndicatorOptions mIndicatorOptions;

    public BaseDrawer(IndicatorOptions indicatorOptions) {
        this.mIndicatorOptions = indicatorOptions;
        this.initBaseDrawer();
    }

    private void initBaseDrawer() {
        this.mPaint.setAntiAlias(true);
        this.mMeasureResult = new MeasureResult();
        if (this.mIndicatorOptions.getSlideMode() == 4 || this.mIndicatorOptions.getSlideMode() == 5) {
            this.argbEvaluator = new ArgbEvaluator();
        }
    }

    @Override
    public MeasureResult onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        if (this.mIndicatorOptions.getNormalSliderWidth() > this.mIndicatorOptions.getCheckedSliderWidth()) {
            this.maxWidth = this.mIndicatorOptions.getNormalSliderWidth();
            this.minWidth = this.mIndicatorOptions.getCheckedSliderWidth();
        } else {
            this.maxWidth = this.mIndicatorOptions.getCheckedSliderWidth();
            this.minWidth = this.mIndicatorOptions.getNormalSliderWidth();
        }
        if (this.mIndicatorOptions.getOrientation() == 1) {
            this.mMeasureResult.setMeasureResult(this.measureHeight(), this.measureWidth());
        } else {
            this.mMeasureResult.setMeasureResult(this.measureWidth(), this.measureHeight());
        }
        return this.mMeasureResult;
    }

    @Override
    public void onLayout(boolean changed, int left, int top, int right, int bottom) {
    }

    public boolean isWidthEquals() {
        return this.mIndicatorOptions.getNormalSliderWidth() == this.mIndicatorOptions.getCheckedSliderWidth();
    }

    protected int measureHeight() {
        return (int)this.mIndicatorOptions.getSliderHeight() + 3;
    }

    private int measureWidth() {
        int pageSize = this.mIndicatorOptions.getPageSize();
        float indicatorGap = this.mIndicatorOptions.getSliderGap();
        return (int)((float)(pageSize - 1) * indicatorGap + this.maxWidth + (float)(pageSize - 1) * this.minWidth) + 6;
    }

    public static class MeasureResult {
        int measureWidth = 0;
        int measureHeight = 0;

        public int getMeasureWidth() {
            return this.measureWidth;
        }

        public MeasureResult setMeasureWidth(int measureWidth) {
            this.measureWidth = measureWidth;
            return this;
        }

        public int getMeasureHeight() {
            return this.measureHeight;
        }

        public MeasureResult setMeasureHeight(int measureHeight) {
            this.measureHeight = measureHeight;
            return this;
        }

        public void setMeasureResult(int measureWidth, int measureHeight) {
            this.measureWidth = measureWidth;
            this.measureHeight = measureHeight;
        }
    }
}

