/*
 * Decompiled with CFR 0.152.
 */
package com.zzh.lib.views.drawer;

import android.graphics.Canvas;
import android.graphics.RectF;
import com.zzh.lib.views.banner.IndicatorOptions;
import com.zzh.lib.views.drawer.BaseDrawer;
import com.zzh.lib.views.utils.BannerUtils;

public class CircleDrawer
extends BaseDrawer {
    private RectF rectF = new RectF();

    @Override
    protected int measureHeight() {
        return (int)(this.maxWidth + 6.0f);
    }

    public CircleDrawer(IndicatorOptions indicatorOptions) {
        super(indicatorOptions);
    }

    @Override
    public void onDraw(Canvas canvas) {
        int pageSize = this.mIndicatorOptions.pageSize;
        if (pageSize > 1 || this.mIndicatorOptions.showIndicatorOneItem && pageSize == 1) {
            this.drawNormal(canvas);
            this.drawSlider(canvas);
        }
    }

    private void drawNormal(Canvas canvas) {
        float normalIndicatorWidth = this.mIndicatorOptions.normalSliderWidth;
        this.mPaint.setColor(this.mIndicatorOptions.normalSliderColor);
        for (int i = 0; i < this.mIndicatorOptions.pageSize; ++i) {
            float coordinateX = BannerUtils.getCoordinateX(this.mIndicatorOptions, this.maxWidth, i);
            float coordinateY = BannerUtils.getCoordinateY(this.maxWidth);
            this.drawCircle(canvas, coordinateX, coordinateY, normalIndicatorWidth / 2.0f);
        }
    }

    private void drawSlider(Canvas canvas) {
        this.mPaint.setColor(this.mIndicatorOptions.checkedSliderColor);
        switch (this.mIndicatorOptions.slideMode) {
            case 0: 
            case 2: {
                this.drawCircleSlider(canvas);
                break;
            }
            case 3: {
                this.drawWormSlider(canvas);
                break;
            }
            case 4: {
                this.drawScaleSlider(canvas);
                break;
            }
            case 5: {
                this.drawColor(canvas);
            }
        }
    }

    private void drawColor(Canvas canvas) {
        int currentPosition = this.mIndicatorOptions.currentPosition;
        float slideProgress = this.mIndicatorOptions.slideProgress;
        float coordinateX = BannerUtils.getCoordinateX(this.mIndicatorOptions, this.maxWidth, currentPosition);
        float coordinateY = BannerUtils.getCoordinateY(this.maxWidth);
        float evaluate = ((Float)this.argbEvaluator.evaluate(slideProgress, (Object)this.mIndicatorOptions.checkedSliderColor, (Object)this.mIndicatorOptions.normalSliderColor)).floatValue();
        this.mPaint.setColor((int)evaluate);
        this.drawCircle(canvas, coordinateX, coordinateY, this.mIndicatorOptions.normalSliderWidth / 2.0f);
        evaluate = ((Float)this.argbEvaluator.evaluate(1.0f - slideProgress, (Object)this.mIndicatorOptions.checkedSliderColor, (Object)this.mIndicatorOptions.normalSliderColor)).floatValue();
        this.mPaint.setColor((int)evaluate);
        float nextCoordinateX = currentPosition == this.mIndicatorOptions.pageSize - 1 ? BannerUtils.getCoordinateX(this.mIndicatorOptions, this.maxWidth, 0) : coordinateX + this.mIndicatorOptions.sliderGap + this.mIndicatorOptions.normalSliderWidth;
        this.drawCircle(canvas, nextCoordinateX, coordinateY, this.mIndicatorOptions.checkedSliderWidth / 2.0f);
    }

    private void drawScaleSlider(Canvas canvas) {
        float nextCoordinateX;
        float evaluate;
        int currentPosition = this.mIndicatorOptions.currentPosition;
        float slideProgress = this.mIndicatorOptions.slideProgress;
        float coordinateX = BannerUtils.getCoordinateX(this.mIndicatorOptions, this.maxWidth, currentPosition);
        float coordinateY = BannerUtils.getCoordinateY(this.maxWidth);
        if (slideProgress < 1.0f) {
            evaluate = ((Float)this.argbEvaluator.evaluate(slideProgress, (Object)this.mIndicatorOptions.checkedSliderColor, (Object)this.mIndicatorOptions.normalSliderColor)).floatValue();
            this.mPaint.setColor((int)evaluate);
            float radius = this.mIndicatorOptions.checkedSliderWidth / 2.0f - (this.mIndicatorOptions.checkedSliderWidth / 2.0f - this.mIndicatorOptions.normalSliderWidth / 2.0f) * slideProgress;
            this.drawCircle(canvas, coordinateX, coordinateY, radius);
        }
        if (currentPosition == this.mIndicatorOptions.pageSize - 1) {
            evaluate = ((Float)this.argbEvaluator.evaluate(slideProgress, (Object)this.mIndicatorOptions.normalSliderColor, (Object)this.mIndicatorOptions.checkedSliderColor)).floatValue();
            this.mPaint.setColor((int)evaluate);
            nextCoordinateX = this.maxWidth / 2.0f;
            float nextRadius = this.minWidth / 2.0f + (this.maxWidth / 2.0f - this.minWidth / 2.0f) * slideProgress;
            this.drawCircle(canvas, nextCoordinateX, coordinateY, nextRadius);
        } else if (slideProgress > 0.0f) {
            evaluate = ((Float)this.argbEvaluator.evaluate(slideProgress, (Object)this.mIndicatorOptions.normalSliderColor, (Object)this.mIndicatorOptions.checkedSliderColor)).floatValue();
            this.mPaint.setColor((int)evaluate);
            nextCoordinateX = coordinateX + this.mIndicatorOptions.sliderGap + this.mIndicatorOptions.normalSliderWidth;
            float nextRadius = this.mIndicatorOptions.normalSliderWidth / 2.0f + (this.mIndicatorOptions.checkedSliderWidth / 2.0f - this.mIndicatorOptions.normalSliderWidth / 2.0f) * slideProgress;
            this.drawCircle(canvas, nextCoordinateX, coordinateY, nextRadius);
        }
    }

    private void drawCircleSlider(Canvas canvas) {
        int currentPosition = this.mIndicatorOptions.currentPosition;
        float startCoordinateX = BannerUtils.getCoordinateX(this.mIndicatorOptions, this.maxWidth, currentPosition);
        float endCoordinateX = BannerUtils.getCoordinateX(this.mIndicatorOptions, this.maxWidth, (currentPosition + 1) % this.mIndicatorOptions.pageSize);
        float coordinateX = startCoordinateX + (endCoordinateX - startCoordinateX) * this.mIndicatorOptions.slideProgress;
        float coordinateY = BannerUtils.getCoordinateY(this.maxWidth);
        float radius = this.mIndicatorOptions.checkedSliderWidth / 2.0f;
        this.drawCircle(canvas, coordinateX, coordinateY, radius);
    }

    private void drawWormSlider(Canvas canvas) {
        float sliderHeight = this.mIndicatorOptions.normalSliderWidth;
        float slideProgress = this.mIndicatorOptions.slideProgress;
        int currentPosition = this.mIndicatorOptions.currentPosition;
        float distance = this.mIndicatorOptions.sliderGap + this.mIndicatorOptions.normalSliderWidth;
        float startCoordinateX = BannerUtils.getCoordinateX(this.mIndicatorOptions, this.maxWidth, currentPosition);
        float v = distance * (slideProgress - 0.5f) * 2.0f;
        if (v < 0.0f) {
            v = 0.0f;
        }
        float left = startCoordinateX + v - this.mIndicatorOptions.normalSliderWidth / 2.0f + 3.0f;
        float v1 = distance * slideProgress * 2.0f;
        if (v1 > distance) {
            v1 = distance;
        }
        float right = startCoordinateX + v1 + this.mIndicatorOptions.normalSliderWidth / 2.0f + 3.0f;
        this.rectF.set(left, 3.0f, right, sliderHeight + 3.0f);
        canvas.drawRoundRect(this.rectF, sliderHeight, sliderHeight, this.mPaint);
    }

    private void drawCircle(Canvas canvas, float coordinateX, float coordinateY, float radius) {
        canvas.drawCircle(coordinateX + 3.0f, coordinateY + 3.0f, radius, this.mPaint);
    }
}

