/*
 * Decompiled with CFR 0.152.
 */
package com.zzh.lib.views.drawer;

import android.graphics.Canvas;
import android.graphics.RectF;
import com.zzh.lib.views.banner.IndicatorOptions;
import com.zzh.lib.views.drawer.BaseDrawer;
import com.zzh.lib.views.utils.BannerUtils;

public class RectDrawer
extends BaseDrawer {
    protected RectF mRectF = new RectF();

    public RectDrawer(IndicatorOptions indicatorOptions) {
        super(indicatorOptions);
    }

    @Override
    public void onDraw(Canvas canvas) {
        int pageSize = this.mIndicatorOptions.getPageSize();
        if (pageSize > 1 || this.mIndicatorOptions.showIndicatorOneItem && pageSize == 1) {
            if (this.isWidthEquals() && this.mIndicatorOptions.getSlideMode() != 0) {
                this.drawUncheckedSlider(canvas, pageSize);
                this.drawCheckedSlider(canvas);
            } else if (this.mIndicatorOptions.getSlideMode() == 4) {
                for (int i = 0; i < pageSize; ++i) {
                    this.drawScaleSlider(canvas, i);
                }
            } else {
                this.drawInequalitySlider(canvas, pageSize);
            }
        }
    }

    private void drawScaleSlider(Canvas canvas, int i) {
        int checkedColor = this.mIndicatorOptions.getCheckedSliderColor();
        float indicatorGap = this.mIndicatorOptions.getSliderGap();
        float sliderHeight = this.mIndicatorOptions.getSliderHeight();
        int currentPosition = this.mIndicatorOptions.getCurrentPosition();
        float normalWidth = this.mIndicatorOptions.getNormalSliderWidth();
        float checkedWidth = this.mIndicatorOptions.getCheckedSliderWidth();
        if (i < currentPosition) {
            this.mPaint.setColor(this.mIndicatorOptions.getNormalSliderColor());
            float left = currentPosition == this.mIndicatorOptions.pageSize - 1 ? (float)i * normalWidth + (float)i * indicatorGap + (checkedWidth - normalWidth) * this.mIndicatorOptions.slideProgress : (float)i * normalWidth + (float)i * indicatorGap;
            this.mRectF.set(left, 0.0f, left + normalWidth, sliderHeight);
            this.drawRoundRect(canvas, sliderHeight, sliderHeight);
        } else if (i == currentPosition) {
            float right;
            float left;
            float left2;
            float right2;
            float evaluate;
            this.mPaint.setColor(checkedColor);
            float slideProgress = this.mIndicatorOptions.slideProgress;
            if (currentPosition == this.mIndicatorOptions.pageSize - 1) {
                evaluate = Float.parseFloat(this.argbEvaluator.evaluate(slideProgress, (Object)checkedColor, (Object)this.mIndicatorOptions.normalSliderColor).toString());
                this.mPaint.setColor((int)evaluate);
                right2 = (float)(this.mIndicatorOptions.pageSize - 1) * (normalWidth + this.mIndicatorOptions.sliderGap) + checkedWidth;
                left2 = right2 - checkedWidth + (checkedWidth - normalWidth) * slideProgress;
                this.mRectF.set(left2, 0.0f, right2, sliderHeight);
                this.drawRoundRect(canvas, sliderHeight, sliderHeight);
            } else if (slideProgress < 1.0f) {
                evaluate = ((Float)this.argbEvaluator.evaluate(slideProgress, (Object)checkedColor, (Object)this.mIndicatorOptions.normalSliderColor)).floatValue();
                this.mPaint.setColor((int)evaluate);
                left = (float)i * normalWidth + (float)i * indicatorGap;
                right = left + normalWidth + (checkedWidth - normalWidth) * (1.0f - slideProgress);
                this.mRectF.set(left, 0.0f, right, sliderHeight);
                this.drawRoundRect(canvas, sliderHeight, sliderHeight);
            }
            if (currentPosition == this.mIndicatorOptions.pageSize - 1) {
                if (slideProgress > 0.0f) {
                    evaluate = ((Float)this.argbEvaluator.evaluate(1.0f - slideProgress, (Object)checkedColor, (Object)this.mIndicatorOptions.normalSliderColor)).floatValue();
                    this.mPaint.setColor((int)evaluate);
                    left = 0.0f;
                    right = left + normalWidth + (checkedWidth - normalWidth) * slideProgress;
                    this.mRectF.set(left, 0.0f, right, sliderHeight);
                    this.drawRoundRect(canvas, sliderHeight, sliderHeight);
                }
            } else if (slideProgress > 0.0f) {
                evaluate = ((Float)this.argbEvaluator.evaluate(1.0f - slideProgress, (Object)checkedColor, (Object)this.mIndicatorOptions.normalSliderColor)).floatValue();
                this.mPaint.setColor((int)evaluate);
                right2 = (float)i * normalWidth + (float)i * indicatorGap + normalWidth + (indicatorGap + checkedWidth);
                left2 = right2 - normalWidth - (checkedWidth - normalWidth) * slideProgress;
                this.mRectF.set(left2, 0.0f, right2, sliderHeight);
                this.drawRoundRect(canvas, sliderHeight, sliderHeight);
            }
        } else if (currentPosition + 1 != i || this.mIndicatorOptions.slideProgress == 0.0f) {
            this.mPaint.setColor(this.mIndicatorOptions.normalSliderColor);
            float left = (float)i * this.minWidth + (float)i * indicatorGap + (checkedWidth - this.minWidth);
            this.mRectF.set(left, 0.0f, left + this.minWidth, sliderHeight);
            this.drawRoundRect(canvas, sliderHeight, sliderHeight);
        }
    }

    private void drawUncheckedSlider(Canvas canvas, int pageSize) {
        for (int i = 0; i < pageSize; ++i) {
            this.mPaint.setColor(this.mIndicatorOptions.normalSliderColor);
            float left = (float)i * this.maxWidth + (float)i * this.mIndicatorOptions.sliderGap + (this.maxWidth - this.minWidth);
            this.mRectF.set(left, 0.0f, left + this.minWidth, this.mIndicatorOptions.sliderHeight);
            this.drawRoundRect(canvas, this.mIndicatorOptions.sliderHeight, this.mIndicatorOptions.sliderHeight);
        }
    }

    private void drawInequalitySlider(Canvas canvas, int pageSize) {
        float left = 0.0f;
        for (int i = 0; i < pageSize; ++i) {
            float sliderWidth = 0.0f;
            sliderWidth = i == this.mIndicatorOptions.currentPosition ? this.maxWidth : this.minWidth;
            if (i == this.mIndicatorOptions.currentPosition) {
                this.mPaint.setColor(this.mIndicatorOptions.checkedSliderColor);
            } else {
                this.mPaint.setColor(this.mIndicatorOptions.normalSliderColor);
            }
            this.mRectF.set(left, 0.0f, left + sliderWidth, this.mIndicatorOptions.sliderHeight);
            this.drawRoundRect(canvas, this.mIndicatorOptions.sliderHeight, this.mIndicatorOptions.sliderHeight);
            left += sliderWidth + this.mIndicatorOptions.sliderGap;
        }
    }

    private void drawCheckedSlider(Canvas canvas) {
        this.mPaint.setColor(this.mIndicatorOptions.checkedSliderColor);
        switch (this.mIndicatorOptions.slideMode) {
            case 2: {
                this.drawSmoothSlider(canvas);
                break;
            }
            case 3: {
                this.drawWormSlider(canvas);
                break;
            }
            case 5: {
                this.drawColorSlider(canvas);
            }
        }
    }

    private void drawColorSlider(Canvas canvas) {
        int currentPosition = this.mIndicatorOptions.currentPosition;
        float slideProgress = this.mIndicatorOptions.slideProgress;
        float left = (float)currentPosition * this.minWidth + (float)currentPosition * this.mIndicatorOptions.sliderGap;
        if ((double)slideProgress < 0.99) {
            float evaluate = ((Float)this.argbEvaluator.evaluate(slideProgress, (Object)this.mIndicatorOptions.checkedSliderColor, (Object)this.mIndicatorOptions.normalSliderColor)).floatValue();
            this.mPaint.setColor((int)evaluate);
            this.mRectF.set(left, 0.0f, left + this.minWidth, this.mIndicatorOptions.sliderHeight);
            this.drawRoundRect(canvas, this.mIndicatorOptions.sliderHeight, this.mIndicatorOptions.sliderHeight);
        }
        float nextSliderLeft = left + this.mIndicatorOptions.sliderGap + this.mIndicatorOptions.normalSliderWidth;
        if (currentPosition == this.mIndicatorOptions.pageSize - 1) {
            nextSliderLeft = 0.0f;
        }
        float evaluate = ((Float)this.argbEvaluator.evaluate(1.0f - slideProgress, (Object)this.mIndicatorOptions.checkedSliderColor, (Object)this.mIndicatorOptions.normalSliderColor)).floatValue();
        this.mPaint.setColor((int)evaluate);
        this.mRectF.set(nextSliderLeft, 0.0f, nextSliderLeft + this.minWidth, this.mIndicatorOptions.sliderHeight);
        this.drawRoundRect(canvas, this.mIndicatorOptions.sliderHeight, this.mIndicatorOptions.sliderHeight);
    }

    private void drawWormSlider(Canvas canvas) {
        float sliderHeight = this.mIndicatorOptions.sliderHeight;
        float slideProgress = this.mIndicatorOptions.slideProgress;
        int currentPosition = this.mIndicatorOptions.currentPosition;
        float distance = this.mIndicatorOptions.sliderGap + this.mIndicatorOptions.normalSliderWidth;
        float startCoordinateX = BannerUtils.getCoordinateX(this.mIndicatorOptions, this.maxWidth, currentPosition);
        float coerceAtLeast = distance * (slideProgress - 0.5f) * 2.0f;
        if (coerceAtLeast < 0.0f) {
            coerceAtLeast = 0.0f;
        }
        float left = startCoordinateX + coerceAtLeast - this.mIndicatorOptions.normalSliderWidth / 2.0f;
        float vDis = distance * slideProgress * 2.0f;
        if (vDis > distance) {
            vDis = distance;
        }
        float right = startCoordinateX + vDis + this.mIndicatorOptions.normalSliderWidth / 2.0f;
        this.mRectF.set(left, 0.0f, right, sliderHeight);
        this.drawRoundRect(canvas, sliderHeight, sliderHeight);
    }

    protected void drawSmoothSlider(Canvas canvas) {
        int currentPosition = this.mIndicatorOptions.currentPosition;
        float indicatorGap = this.mIndicatorOptions.sliderGap;
        float sliderHeight = this.mIndicatorOptions.sliderHeight;
        float left = (float)currentPosition * this.maxWidth + (float)currentPosition * indicatorGap + (this.maxWidth + indicatorGap) * this.mIndicatorOptions.slideProgress;
        this.mRectF.set(left, 0.0f, left + this.maxWidth, sliderHeight);
        this.drawRoundRect(canvas, sliderHeight, sliderHeight);
    }

    protected void drawRoundRect(Canvas canvas, float rx, float ry) {
        this.drawDash(canvas);
    }

    protected void drawDash(Canvas canvas) {
    }
}

