/*
 * Decompiled with CFR 0.152.
 */
package com.zzh.lib.views.gesture;

import android.util.Log;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.ViewGroup;
import com.zzh.lib.views.gesture.HScroller;
import com.zzh.lib.views.gesture.HTouchHelper;

public class HGestureManager {
    private final ViewGroup mViewGroup;
    private HTouchHelper mTouchHelper;
    private final TagHolder mTagHolder;
    private final HScroller mScroller;
    private State mState = State.Idle;
    private LifecycleInfo mLifecycleInfo;
    private final IdleRunnable mIdleRunnable = new IdleRunnable();
    private VelocityTracker mVelocityTracker;
    private boolean mDebug;
    private final Callback mCallback;

    public HGestureManager(ViewGroup viewGroup, Callback callback) {
        if (viewGroup == null || callback == null) {
            throw new NullPointerException();
        }
        this.mViewGroup = viewGroup;
        this.mCallback = callback;
        this.mTagHolder = new TagHolder(){

            @Override
            protected void onTagConsumeChanged(boolean tag) {
                if (tag) {
                    HGestureManager.this.setState(State.Consume);
                }
                super.onTagConsumeChanged(tag);
            }
        };
        this.mScroller = new HScroller(viewGroup.getContext()){

            @Override
            protected void onScrollerStart() {
                HGestureManager.this.setState(State.Fling);
                super.onScrollerStart();
            }

            @Override
            protected void onScrollerCompute(int lastX, int lastY, int currX, int currY) {
                HGestureManager.this.mCallback.onScrollerCompute(lastX, lastY, currX, currY);
                super.onScrollerCompute(lastX, lastY, currX, currY);
            }

            @Override
            protected void onScrollerFinish(boolean isAbort) {
                if (HGestureManager.this.mDebug) {
                    Log.e((String)HGestureManager.class.getSimpleName(), (String)("onScrollerFinish isAbort:" + isAbort));
                }
                if (HGestureManager.this.mTagHolder.isTagConsume()) {
                    HGestureManager.this.setState(State.Consume);
                } else {
                    HGestureManager.this.mIdleRunnable.post();
                }
                super.onScrollerFinish(isAbort);
            }
        };
    }

    public void setDebug(boolean debug) {
        this.mDebug = debug;
    }

    public HTouchHelper getTouchHelper() {
        if (this.mTouchHelper == null) {
            this.mTouchHelper = new HTouchHelper();
        }
        return this.mTouchHelper;
    }

    public TagHolder getTagHolder() {
        return this.mTagHolder;
    }

    public HScroller getScroller() {
        return this.mScroller;
    }

    public State getState() {
        return this.mState;
    }

    public LifecycleInfo getLifecycleInfo() {
        if (this.mLifecycleInfo == null) {
            this.mLifecycleInfo = new LifecycleInfo();
        }
        return this.mLifecycleInfo;
    }

    private void setState(State state) {
        if (state == null) {
            throw new NullPointerException();
        }
        if (this.mDebug) {
            Log.i((String)HGestureManager.class.getSimpleName(), (String)("setState:" + (Object)((Object)this.mState) + " -> " + (Object)((Object)state)));
        }
        this.mIdleRunnable.cancel();
        State old = this.mState;
        if (old != state) {
            this.mState = state;
            this.mCallback.onStateChanged(old, state);
        }
    }

    private VelocityTracker getVelocityTracker() {
        if (this.mVelocityTracker == null) {
            this.mVelocityTracker = VelocityTracker.obtain();
        }
        return this.mVelocityTracker;
    }

    private void releaseVelocityTracker() {
        if (this.mVelocityTracker != null) {
            this.mVelocityTracker.recycle();
            this.mVelocityTracker = null;
        }
    }

    public void cancelConsumeEvent() {
        if (this.mTagHolder.isTagConsume()) {
            if (this.mDebug) {
                Log.i((String)HGestureManager.class.getSimpleName(), (String)"cancelConsumeEvent");
            }
            this.getLifecycleInfo().setCancelConsumeEvent(true);
            if (this.getScroller().isFinished()) {
                this.mIdleRunnable.post();
            }
            this.mTagHolder.reset();
            this.mCallback.onCancelConsumeEvent();
        }
    }

    public boolean onInterceptTouchEvent(MotionEvent event) {
        this.getTouchHelper().processTouchEvent(event);
        this.getVelocityTracker().addMovement(event);
        int action = event.getAction();
        if (action == 1 || action == 3) {
            this.onEventFinish(event);
        } else {
            if (action == 0) {
                this.onEventStart(event);
            }
            if (!this.mTagHolder.isTagIntercept()) {
                this.mTagHolder.setTagIntercept(this.mCallback.shouldInterceptEvent(event));
            }
        }
        return this.mTagHolder.isTagIntercept();
    }

    public boolean onTouchEvent(MotionEvent event) {
        this.getTouchHelper().processTouchEvent(event);
        this.getVelocityTracker().addMovement(event);
        int action = event.getAction();
        if (action == 1 || action == 3) {
            this.onEventFinish(event);
        } else {
            if (action == 0) {
                this.onEventStart(event);
                return this.mCallback.onEventActionDown(event);
            }
            if (!this.getLifecycleInfo().isCancelConsumeEvent()) {
                if (!this.mTagHolder.isTagConsume()) {
                    this.mTagHolder.setTagConsume(this.mCallback.shouldConsumeEvent(event));
                } else {
                    this.mCallback.onEventConsume(event);
                    this.getLifecycleInfo().setHasConsumeEvent(true);
                }
            }
        }
        return this.mTagHolder.isTagConsume();
    }

    private void onEventStart(MotionEvent event) {
    }

    private void onEventFinish(MotionEvent event) {
        this.mTagHolder.reset();
        this.mCallback.onEventFinish(this.getVelocityTracker(), event);
        this.releaseVelocityTracker();
        this.getLifecycleInfo().reset();
        if (this.mState == State.Consume) {
            this.setState(State.Idle);
        }
    }

    public static class TagHolder {
        private boolean mTagIntercept = false;
        private boolean mTagConsume = false;
        private Callback mCallback;

        private TagHolder() {
        }

        public void setCallback(Callback callback) {
            this.mCallback = callback;
        }

        public boolean isTagIntercept() {
            return this.mTagIntercept;
        }

        public boolean isTagConsume() {
            return this.mTagConsume;
        }

        void setTagIntercept(boolean tag) {
            if (this.mTagIntercept != tag) {
                this.mTagIntercept = tag;
                this.onTagInterceptChanged(tag);
            }
        }

        void setTagConsume(boolean tag) {
            if (this.mTagConsume != tag) {
                this.mTagConsume = tag;
                this.onTagConsumeChanged(tag);
            }
        }

        void reset() {
            this.setTagIntercept(false);
            this.setTagConsume(false);
        }

        protected void onTagInterceptChanged(boolean tag) {
            if (this.mCallback != null) {
                this.mCallback.onTagInterceptChanged(tag);
            }
        }

        protected void onTagConsumeChanged(boolean tag) {
            if (this.mCallback != null) {
                this.mCallback.onTagConsumeChanged(tag);
            }
        }

        public static interface Callback {
            public void onTagInterceptChanged(boolean var1);

            public void onTagConsumeChanged(boolean var1);
        }
    }

    public static abstract class Callback {
        public boolean shouldInterceptEvent(MotionEvent event) {
            return false;
        }

        public boolean onEventActionDown(MotionEvent event) {
            return true;
        }

        public abstract boolean shouldConsumeEvent(MotionEvent var1);

        public abstract void onEventConsume(MotionEvent var1);

        public void onCancelConsumeEvent() {
        }

        public abstract void onEventFinish(VelocityTracker var1, MotionEvent var2);

        public abstract void onStateChanged(State var1, State var2);

        public abstract void onScrollerCompute(int var1, int var2, int var3, int var4);
    }

    public static enum State {
        Idle,
        Consume,
        Fling;

    }

    public static final class LifecycleInfo {
        private boolean mHasConsumeEvent;
        private boolean mIsCancelConsumeEvent;

        public boolean hasConsumeEvent() {
            return this.mHasConsumeEvent;
        }

        public boolean isCancelConsumeEvent() {
            return this.mIsCancelConsumeEvent;
        }

        void setHasConsumeEvent(boolean has) {
            this.mHasConsumeEvent = has;
        }

        void setCancelConsumeEvent(boolean cancel) {
            this.mIsCancelConsumeEvent = cancel;
        }

        void reset() {
            this.mHasConsumeEvent = false;
            this.mIsCancelConsumeEvent = false;
        }
    }

    private final class IdleRunnable
    implements Runnable {
        private boolean mPost;

        private IdleRunnable() {
        }

        @Override
        public void run() {
            if (HGestureManager.this.mDebug) {
                Log.i((String)HGestureManager.class.getSimpleName(), (String)"IdleRunnable run");
            }
            this.mPost = false;
            HGestureManager.this.setState(State.Idle);
        }

        public void post() {
            if (HGestureManager.this.mDebug) {
                Log.i((String)HGestureManager.class.getSimpleName(), (String)"IdleRunnable post");
            }
            HGestureManager.this.mViewGroup.post((Runnable)this);
            this.mPost = true;
        }

        public void cancel() {
            if (HGestureManager.this.mDebug && this.mPost) {
                Log.i((String)HGestureManager.class.getSimpleName(), (String)"IdleRunnable cancel");
            }
            HGestureManager.this.mViewGroup.removeCallbacks((Runnable)this);
            this.mPost = false;
        }
    }
}

