/*
 * Decompiled with CFR 0.152.
 */
package com.zzh.lib.views.gesture;

import android.content.Context;
import android.os.Build;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.ViewParent;
import java.util.LinkedList;
import java.util.List;

public class HTouchHelper {
    private float mCurrentX;
    private float mCurrentY;
    private float mLastX;
    private float mLastY;
    private float mDownX;
    private float mDownY;

    public void processTouchEvent(MotionEvent event) {
        this.mLastX = this.mCurrentX;
        this.mLastY = this.mCurrentY;
        this.mCurrentX = event.getRawX();
        this.mCurrentY = event.getRawY();
        switch (event.getAction()) {
            case 0: {
                this.mDownX = this.mCurrentX;
                this.mDownY = this.mCurrentY;
                break;
            }
        }
    }

    public float getCurrentX() {
        return this.mCurrentX;
    }

    public float getCurrentY() {
        return this.mCurrentY;
    }

    public float getLastX() {
        return this.mLastX;
    }

    public float getLastY() {
        return this.mLastY;
    }

    public float getDownX() {
        return this.mDownX;
    }

    public float getDownY() {
        return this.mDownY;
    }

    public float getDeltaX() {
        return this.mCurrentX - this.mLastX;
    }

    public float getDeltaY() {
        return this.mCurrentY - this.mLastY;
    }

    public float getDeltaXFromDown() {
        return this.mCurrentX - this.mDownX;
    }

    public float getDeltaYFromDown() {
        return this.mCurrentY - this.mDownY;
    }

    public double getDegreeX() {
        float dx = this.getDeltaX();
        if (dx == 0.0f) {
            return 0.0;
        }
        float dy = this.getDeltaY();
        float angle = Math.abs(dy) / Math.abs(dx);
        return Math.toDegrees(Math.atan(angle));
    }

    public double getDegreeY() {
        float dy = this.getDeltaY();
        if (dy == 0.0f) {
            return 0.0;
        }
        float dx = this.getDeltaX();
        float angle = Math.abs(dx) / Math.abs(dy);
        return Math.toDegrees(Math.atan(angle));
    }

    public double getDegreeXFromDown() {
        float dx = this.getDeltaXFromDown();
        if (dx == 0.0f) {
            return 0.0;
        }
        float dy = this.getDeltaYFromDown();
        float angle = Math.abs(dy) / Math.abs(dx);
        return Math.toDegrees(Math.atan(angle));
    }

    public double getDegreeYFromDown() {
        float dy = this.getDeltaYFromDown();
        if (dy == 0.0f) {
            return 0.0;
        }
        float dx = this.getDeltaXFromDown();
        float angle = Math.abs(dx) / Math.abs(dy);
        return Math.toDegrees(Math.atan(angle));
    }

    public boolean isClick(MotionEvent event, Context context) {
        if (event.getAction() == 1) {
            long clickTimeout = ViewConfiguration.getPressedStateDuration() + ViewConfiguration.getTapTimeout();
            int touchSlop = ViewConfiguration.get((Context)context).getScaledTouchSlop();
            long duration = event.getEventTime() - event.getDownTime();
            int dx = (int)this.getDeltaXFromDown();
            int dy = (int)this.getDeltaYFromDown();
            return duration < clickTimeout && dx < touchSlop && dy < touchSlop;
        }
        return false;
    }

    public static int getLegalDelta(int current, int min, int max, int delta) {
        if (delta == 0) {
            return 0;
        }
        int future = current + delta;
        if (future < min) {
            delta += min - future;
        } else if (future > max) {
            delta += max - future;
        }
        return delta;
    }

    public static void requestDisallowInterceptTouchEvent(View view, boolean disallowIntercept) {
        ViewParent parent = view.getParent();
        if (parent != null) {
            parent.requestDisallowInterceptTouchEvent(disallowIntercept);
        }
    }

    public static boolean isViewUnder(View view, int x, int y) {
        return x >= view.getLeft() && x < view.getRight() && y >= view.getTop() && y < view.getBottom();
    }

    public static boolean isViewUnderScreen(View view, int x, int y) {
        int[] location = new int[2];
        view.getLocationOnScreen(location);
        return x >= location[0] && x < location[0] + view.getWidth() && y >= location[1] && y < location[1] + view.getHeight();
    }

    public static List<View> findChildrenUnder(ViewGroup parent, int x, int y) {
        LinkedList<View> list = new LinkedList<View>();
        int count = parent.getChildCount();
        for (int i = count - 1; i >= 0; --i) {
            View child = parent.getChildAt(i);
            if (!HTouchHelper.isViewUnder(child, x, y)) continue;
            list.add(child);
        }
        return list;
    }

    public static View findTopChildUnder(ViewGroup parent, int x, int y) {
        if (Build.VERSION.SDK_INT < 21) {
            return parent.getChildAt(parent.getChildCount() - 1);
        }
        List<View> list = HTouchHelper.findChildrenUnder(parent, x, y);
        if (list.isEmpty()) {
            return null;
        }
        View target = list.remove(0);
        for (View item : list) {
            if (!(item.getZ() > target.getZ())) continue;
            target = item;
        }
        return target;
    }

    public static boolean isScrollToLeft(View view) {
        return !view.canScrollHorizontally(-1);
    }

    public static boolean isScrollToTop(View view) {
        return !view.canScrollVertically(-1);
    }

    public static boolean isScrollToRight(View view) {
        return !view.canScrollHorizontally(1);
    }

    public static boolean isScrollToBottom(View view) {
        return !view.canScrollVertically(1);
    }
}

