/*
 * Decompiled with CFR 0.152.
 */
package com.zzh.lib.views.guide;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import com.zzh.lib.views.guide.Common;
import com.zzh.lib.views.guide.Component;
import com.zzh.lib.views.guide.Configuration;
import com.zzh.lib.views.guide.GuideBuilder;
import com.zzh.lib.views.guide.MaskView;
import com.zzh.lib.views.utils.DimenUtil;

public class Guide
implements View.OnKeyListener,
View.OnTouchListener {
    private static final int SLIDE_THRESHOLD = 30;
    private Configuration mConfiguration;
    private MaskView mMaskView;
    private Component[] mComponents;
    private boolean mShouldCheckLocInWindow = true;
    private GuideBuilder.OnVisibilityChangedListener mOnVisibilityChangedListener;
    private GuideBuilder.OnSlideListener mOnSlideListener;
    float startY = -1.0f;

    Guide() {
    }

    void setConfiguration(Configuration configuration) {
        this.mConfiguration = configuration;
    }

    void setComponents(Component[] components) {
        this.mComponents = components;
    }

    void setCallback(GuideBuilder.OnVisibilityChangedListener listener) {
        this.mOnVisibilityChangedListener = listener;
    }

    public void setOnSlideListener(GuideBuilder.OnSlideListener onSlideListener) {
        this.mOnSlideListener = onSlideListener;
    }

    public void show(Activity activity) {
        this.show(activity, null);
    }

    public void show(Activity activity, ViewGroup overlay) {
        this.mMaskView = this.onCreateView(activity, overlay);
        if (overlay == null) {
            overlay = (ViewGroup)activity.getWindow().getDecorView();
        }
        if (this.mMaskView.getParent() == null && this.mConfiguration.mTargetView != null) {
            overlay.addView((View)this.mMaskView);
            if (this.mConfiguration.mEnterAnimationId != -1) {
                Animation anim2 = AnimationUtils.loadAnimation((Context)activity, (int)this.mConfiguration.mEnterAnimationId);
                assert (anim2 != null);
                anim2.setAnimationListener(new Animation.AnimationListener(){

                    public void onAnimationStart(Animation animation) {
                    }

                    public void onAnimationEnd(Animation animation) {
                        if (Guide.this.mOnVisibilityChangedListener != null) {
                            Guide.this.mOnVisibilityChangedListener.onShown();
                        }
                    }

                    public void onAnimationRepeat(Animation animation) {
                    }
                });
                this.mMaskView.startAnimation(anim2);
            } else if (this.mOnVisibilityChangedListener != null) {
                this.mOnVisibilityChangedListener.onShown();
            }
        }
    }

    public void clear() {
        if (this.mMaskView == null) {
            return;
        }
        ViewGroup vp = (ViewGroup)this.mMaskView.getParent();
        if (vp == null) {
            return;
        }
        vp.removeView((View)this.mMaskView);
        this.onDestroy();
    }

    public void dismiss() {
        if (this.mMaskView == null) {
            return;
        }
        final ViewGroup vp = (ViewGroup)this.mMaskView.getParent();
        if (vp == null) {
            return;
        }
        if (this.mConfiguration.mExitAnimationId != -1) {
            Context context = this.mMaskView.getContext();
            assert (context != null);
            Animation anim2 = AnimationUtils.loadAnimation((Context)context, (int)this.mConfiguration.mExitAnimationId);
            assert (anim2 != null);
            anim2.setAnimationListener(new Animation.AnimationListener(){

                public void onAnimationStart(Animation animation) {
                }

                public void onAnimationEnd(Animation animation) {
                    vp.removeView((View)Guide.this.mMaskView);
                    if (Guide.this.mOnVisibilityChangedListener != null) {
                        Guide.this.mOnVisibilityChangedListener.onDismiss();
                    }
                    Guide.this.onDestroy();
                }

                public void onAnimationRepeat(Animation animation) {
                }
            });
            this.mMaskView.startAnimation(anim2);
        } else {
            vp.removeView((View)this.mMaskView);
            if (this.mOnVisibilityChangedListener != null) {
                this.mOnVisibilityChangedListener.onDismiss();
            }
            this.onDestroy();
        }
    }

    public void setShouldCheckLocInWindow(boolean set) {
        this.mShouldCheckLocInWindow = set;
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    private MaskView onCreateView(Activity activity, ViewGroup overlay) {
        if (overlay == null) {
            overlay = (ViewGroup)activity.getWindow().getDecorView();
        }
        MaskView maskView = new MaskView((Context)activity);
        maskView.setFullingColor(activity.getResources().getColor(this.mConfiguration.mFullingColorId));
        maskView.setFullingAlpha(this.mConfiguration.mAlpha);
        maskView.setHighTargetCorner(this.mConfiguration.mCorner);
        maskView.setPadding(this.mConfiguration.mPadding);
        maskView.setPaddingLeft(this.mConfiguration.mPaddingLeft);
        maskView.setPaddingTop(this.mConfiguration.mPaddingTop);
        maskView.setPaddingRight(this.mConfiguration.mPaddingRight);
        maskView.setPaddingBottom(this.mConfiguration.mPaddingBottom);
        maskView.setHighTargetGraphStyle(this.mConfiguration.mGraphStyle);
        maskView.setOverlayTarget(this.mConfiguration.mOverlayTarget);
        maskView.setOnKeyListener(this);
        int parentX = 0;
        int parentY = 0;
        if (overlay != null) {
            int[] loc = new int[2];
            overlay.getLocationInWindow(loc);
            parentX = loc[0];
            parentY = loc[1];
        }
        if (this.mConfiguration.mTargetView != null) {
            maskView.setTargetRect(Common.getViewAbsRect(this.mConfiguration.mTargetView, parentX, parentY));
        } else {
            View target = activity.findViewById(this.mConfiguration.mTargetViewId);
            if (target != null) {
                maskView.setTargetRect(Common.getViewAbsRect(target, parentX, parentY));
            }
        }
        if (this.mConfiguration.mOutsideTouchable) {
            maskView.setClickable(false);
        } else {
            maskView.setOnTouchListener(this);
        }
        for (Component c : this.mComponents) {
            maskView.addView(Common.componentToView(activity.getLayoutInflater(), c));
        }
        return maskView;
    }

    private void onDestroy() {
        this.mConfiguration = null;
        this.mComponents = null;
        this.mOnVisibilityChangedListener = null;
        this.mOnSlideListener = null;
        this.mMaskView.removeAllViews();
        this.mMaskView = null;
    }

    public boolean onKey(View v, int keyCode, KeyEvent event) {
        if (keyCode == 4 && event.getAction() == 1) {
            if (this.mConfiguration != null && this.mConfiguration.mAutoDismiss) {
                this.dismiss();
                return true;
            }
            return false;
        }
        return false;
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    public boolean onTouch(View view, MotionEvent motionEvent) {
        if (motionEvent.getAction() == 0) {
            this.startY = motionEvent.getY();
        } else if (motionEvent.getAction() == 1) {
            if (this.startY - motionEvent.getY() > (float)DimenUtil.dp2px(view.getContext(), 30.0f)) {
                if (this.mOnSlideListener != null) {
                    this.mOnSlideListener.onSlideListener(GuideBuilder.SlideState.UP);
                }
            } else if (motionEvent.getY() - this.startY > (float)DimenUtil.dp2px(view.getContext(), 30.0f) && this.mOnSlideListener != null) {
                this.mOnSlideListener.onSlideListener(GuideBuilder.SlideState.DOWN);
            }
            if (this.mConfiguration != null && this.mConfiguration.mAutoDismiss) {
                this.dismiss();
            }
        }
        return true;
    }
}

