/*
 * Decompiled with CFR 0.152.
 */
package com.zzh.lib.views.guide;

import android.view.View;
import androidx.annotation.AnimatorRes;
import androidx.annotation.IdRes;
import androidx.annotation.IntRange;
import com.zzh.lib.views.guide.BuildException;
import com.zzh.lib.views.guide.Component;
import com.zzh.lib.views.guide.Configuration;
import com.zzh.lib.views.guide.Guide;
import java.util.ArrayList;
import java.util.List;

public class GuideBuilder {
    private Configuration mConfiguration;
    private boolean mBuilt;
    private List<Component> mComponents = new ArrayList<Component>();
    private OnVisibilityChangedListener mOnVisibilityChangedListener;
    private OnSlideListener mOnSlideListener;

    public GuideBuilder() {
        this.mConfiguration = new Configuration();
    }

    public GuideBuilder setAlpha(@IntRange(from=0L, to=255L) int alpha) {
        if (this.mBuilt) {
            throw new BuildException("Already created. rebuild a new one.");
        }
        if (alpha < 0 || alpha > 255) {
            alpha = 0;
        }
        this.mConfiguration.mAlpha = alpha;
        return this;
    }

    public GuideBuilder setTargetView(View v) {
        if (this.mBuilt) {
            throw new BuildException("Already created. rebuild a new one.");
        }
        this.mConfiguration.mTargetView = v;
        return this;
    }

    public GuideBuilder setTargetViewId(@IdRes int id2) {
        if (this.mBuilt) {
            throw new BuildException("Already created. rebuild a new one.");
        }
        this.mConfiguration.mTargetViewId = id2;
        return this;
    }

    public GuideBuilder setHighTargetCorner(int corner) {
        if (this.mBuilt) {
            throw new BuildException("Already created. rebuild a new one.");
        }
        if (corner < 0) {
            this.mConfiguration.mCorner = 0;
        }
        this.mConfiguration.mCorner = corner;
        return this;
    }

    public GuideBuilder setHighTargetGraphStyle(int style2) {
        if (this.mBuilt) {
            throw new BuildException("Already created. rebuild a new one.");
        }
        this.mConfiguration.mGraphStyle = style2;
        return this;
    }

    public GuideBuilder setFullingColorId(@IdRes int id2) {
        if (this.mBuilt) {
            throw new BuildException("Already created. rebuild a new one.");
        }
        this.mConfiguration.mFullingColorId = id2;
        return this;
    }

    public GuideBuilder setAutoDismiss(boolean b) {
        if (this.mBuilt) {
            throw new BuildException("Already created, rebuild a new one.");
        }
        this.mConfiguration.mAutoDismiss = b;
        return this;
    }

    public GuideBuilder setOverlayTarget(boolean b) {
        if (this.mBuilt) {
            throw new BuildException("Already created, rebuild a new one.");
        }
        this.mConfiguration.mOverlayTarget = b;
        return this;
    }

    public GuideBuilder setEnterAnimationId(@AnimatorRes int id2) {
        if (this.mBuilt) {
            throw new BuildException("Already created. rebuild a new one.");
        }
        this.mConfiguration.mEnterAnimationId = id2;
        return this;
    }

    public GuideBuilder setExitAnimationId(@AnimatorRes int id2) {
        if (this.mBuilt) {
            throw new BuildException("Already created. rebuild a new one.");
        }
        this.mConfiguration.mExitAnimationId = id2;
        return this;
    }

    public GuideBuilder addComponent(Component component) {
        if (this.mBuilt) {
            throw new BuildException("Already created, rebuild a new one.");
        }
        this.mComponents.add(component);
        return this;
    }

    public GuideBuilder setOnVisibilityChangedListener(OnVisibilityChangedListener onVisibilityChangedListener) {
        if (this.mBuilt) {
            throw new BuildException("Already created, rebuild a new one.");
        }
        this.mOnVisibilityChangedListener = onVisibilityChangedListener;
        return this;
    }

    public GuideBuilder setOnSlideListener(OnSlideListener onSlideListener) {
        if (this.mBuilt) {
            throw new BuildException("Already created, rebuild a new one.");
        }
        this.mOnSlideListener = onSlideListener;
        return this;
    }

    public GuideBuilder setOutsideTouchable(boolean touchable) {
        this.mConfiguration.mOutsideTouchable = touchable;
        return this;
    }

    public GuideBuilder setHighTargetPadding(int padding) {
        if (this.mBuilt) {
            throw new BuildException("Already created. rebuild a new one.");
        }
        if (padding < 0) {
            this.mConfiguration.mPadding = 0;
        }
        this.mConfiguration.mPadding = padding;
        return this;
    }

    public GuideBuilder setHighTargetPaddingLeft(int padding) {
        if (this.mBuilt) {
            throw new BuildException("Already created. rebuild a new one.");
        }
        if (padding < 0) {
            this.mConfiguration.mPaddingLeft = 0;
        }
        this.mConfiguration.mPaddingLeft = padding;
        return this;
    }

    public GuideBuilder setHighTargetPaddingTop(int padding) {
        if (this.mBuilt) {
            throw new BuildException("Already created. rebuild a new one.");
        }
        if (padding < 0) {
            this.mConfiguration.mPaddingTop = 0;
        }
        this.mConfiguration.mPaddingTop = padding;
        return this;
    }

    public GuideBuilder setHighTargetPaddingRight(int padding) {
        if (this.mBuilt) {
            throw new BuildException("Already created. rebuild a new one.");
        }
        if (padding < 0) {
            this.mConfiguration.mPaddingRight = 0;
        }
        this.mConfiguration.mPaddingRight = padding;
        return this;
    }

    public GuideBuilder setHighTargetPaddingBottom(int padding) {
        if (this.mBuilt) {
            throw new BuildException("Already created. rebuild a new one.");
        }
        if (padding < 0) {
            this.mConfiguration.mPaddingBottom = 0;
        }
        this.mConfiguration.mPaddingBottom = padding;
        return this;
    }

    public Guide createGuide() {
        Guide guide = new Guide();
        Component[] components = new Component[this.mComponents.size()];
        guide.setComponents(this.mComponents.toArray(components));
        guide.setConfiguration(this.mConfiguration);
        guide.setCallback(this.mOnVisibilityChangedListener);
        guide.setOnSlideListener(this.mOnSlideListener);
        this.mComponents = null;
        this.mConfiguration = null;
        this.mOnVisibilityChangedListener = null;
        this.mBuilt = true;
        return guide;
    }

    public static interface OnVisibilityChangedListener {
        public void onShown();

        public void onDismiss();
    }

    public static interface OnSlideListener {
        public void onSlideListener(SlideState var1);
    }

    public static enum SlideState {
        UP,
        DOWN;

    }
}

