/*
 * Decompiled with CFR 0.152.
 */
package com.zzh.lib.views.guide;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Xfermode;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;

class MaskView
extends ViewGroup {
    private final RectF mTargetRect = new RectF();
    private final RectF mOverlayRect = new RectF();
    private final RectF mChildTmpRect = new RectF();
    private final Paint mFullingPaint;
    private int mPadding = 0;
    private int mPaddingLeft = 0;
    private int mPaddingTop = 0;
    private int mPaddingRight = 0;
    private int mPaddingBottom = 0;
    private boolean mOverlayTarget = false;
    private int mCorner = 0;
    private int mStyle = 0;
    private Paint mEraser;
    private Bitmap mEraserBitmap;
    private Canvas mEraserCanvas;
    private boolean ignoreRepadding;
    private int mInitHeight;
    private int mChangedHeight = 0;
    private boolean mFirstFlag = true;

    public MaskView(Context context) {
        this(context, null, 0);
    }

    public MaskView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public MaskView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.setWillNotDraw(false);
        WindowManager wm = (WindowManager)this.getContext().getSystemService("window");
        DisplayMetrics displayMetrics = new DisplayMetrics();
        wm.getDefaultDisplay().getRealMetrics(displayMetrics);
        int width = displayMetrics.widthPixels;
        int height = displayMetrics.heightPixels;
        this.mOverlayRect.set(0.0f, 0.0f, (float)width, (float)height);
        this.mEraserBitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        this.mEraserCanvas = new Canvas(this.mEraserBitmap);
        this.mFullingPaint = new Paint();
        this.mEraser = new Paint();
        this.mEraser.setColor(-1);
        this.mEraser.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.CLEAR));
        this.mEraser.setFlags(1);
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        try {
            this.clearFocus();
            this.mEraserCanvas.setBitmap(null);
            this.mEraserBitmap = null;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int w = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int h = View.MeasureSpec.getSize((int)heightMeasureSpec);
        if (this.mFirstFlag) {
            this.mInitHeight = h;
            this.mFirstFlag = false;
        }
        this.mChangedHeight = this.mInitHeight > h ? h - this.mInitHeight : (this.mInitHeight < h ? h - this.mInitHeight : 0);
        this.setMeasuredDimension(w, h);
        this.mOverlayRect.set(0.0f, 0.0f, (float)w, (float)h);
        this.resetOutPath();
        int count = this.getChildCount();
        for (int i = 0; i < count; ++i) {
            View child = this.getChildAt(i);
            if (child == null) continue;
            this.measureChild(child, widthMeasureSpec, heightMeasureSpec);
        }
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        int count = this.getChildCount();
        float density = this.getResources().getDisplayMetrics().density;
        for (int i = 0; i < count; ++i) {
            LayoutParams lp;
            View child = this.getChildAt(i);
            if (child == null || (lp = (LayoutParams)child.getLayoutParams()) == null) continue;
            switch (lp.targetAnchor) {
                case 1: {
                    this.mChildTmpRect.right = this.mTargetRect.left;
                    this.mChildTmpRect.left = this.mChildTmpRect.right - (float)child.getMeasuredWidth();
                    this.verticalChildPositionLayout(child, this.mChildTmpRect, lp.targetParentPosition);
                    break;
                }
                case 2: {
                    this.mChildTmpRect.bottom = this.mTargetRect.top;
                    this.mChildTmpRect.top = this.mChildTmpRect.bottom - (float)child.getMeasuredHeight();
                    this.horizontalChildPositionLayout(child, this.mChildTmpRect, lp.targetParentPosition);
                    break;
                }
                case 3: {
                    this.mChildTmpRect.left = this.mTargetRect.right;
                    this.mChildTmpRect.right = this.mChildTmpRect.left + (float)child.getMeasuredWidth();
                    this.verticalChildPositionLayout(child, this.mChildTmpRect, lp.targetParentPosition);
                    break;
                }
                case 4: {
                    this.mChildTmpRect.top = this.mTargetRect.bottom;
                    this.mChildTmpRect.bottom = this.mChildTmpRect.top + (float)child.getMeasuredHeight();
                    this.horizontalChildPositionLayout(child, this.mChildTmpRect, lp.targetParentPosition);
                    break;
                }
                case 5: {
                    this.mChildTmpRect.left = (int)this.mTargetRect.width() - child.getMeasuredWidth() >> 1;
                    this.mChildTmpRect.top = (int)this.mTargetRect.height() - child.getMeasuredHeight() >> 1;
                    this.mChildTmpRect.right = (int)this.mTargetRect.width() + child.getMeasuredWidth() >> 1;
                    this.mChildTmpRect.bottom = (int)this.mTargetRect.height() + child.getMeasuredHeight() >> 1;
                    this.mChildTmpRect.offset(this.mTargetRect.left, this.mTargetRect.top);
                }
            }
            this.mChildTmpRect.offset((float)((int)(density * (float)lp.offsetX + 0.5f)), (float)((int)(density * (float)lp.offsetY + 0.5f)));
            child.layout((int)this.mChildTmpRect.left, (int)this.mChildTmpRect.top, (int)this.mChildTmpRect.right, (int)this.mChildTmpRect.bottom);
        }
    }

    private void horizontalChildPositionLayout(View child, RectF rect, int targetParentPosition) {
        switch (targetParentPosition) {
            case 16: {
                rect.left = this.mTargetRect.left;
                rect.right = rect.left + (float)child.getMeasuredWidth();
                break;
            }
            case 32: {
                rect.left = (this.mTargetRect.width() - (float)child.getMeasuredWidth()) / 2.0f;
                rect.right = (this.mTargetRect.width() + (float)child.getMeasuredWidth()) / 2.0f;
                rect.offset(this.mTargetRect.left, 0.0f);
                break;
            }
            case 48: {
                rect.right = this.mTargetRect.right;
                rect.left = rect.right - (float)child.getMeasuredWidth();
            }
        }
    }

    private void verticalChildPositionLayout(View child, RectF rect, int targetParentPosition) {
        switch (targetParentPosition) {
            case 16: {
                rect.top = this.mTargetRect.top;
                rect.bottom = rect.top + (float)child.getMeasuredHeight();
                break;
            }
            case 32: {
                rect.top = (this.mTargetRect.width() - (float)child.getMeasuredHeight()) / 2.0f;
                rect.bottom = (this.mTargetRect.width() + (float)child.getMeasuredHeight()) / 2.0f;
                rect.offset(0.0f, this.mTargetRect.top);
                break;
            }
            case 48: {
                rect.bottom = this.mTargetRect.bottom;
                rect.top = this.mTargetRect.bottom - (float)child.getMeasuredHeight();
            }
        }
    }

    private void resetOutPath() {
        this.resetPadding();
    }

    private void resetPadding() {
        if (!this.ignoreRepadding) {
            if (this.mPadding != 0 && this.mPaddingLeft == 0) {
                this.mTargetRect.left -= (float)this.mPadding;
            }
            if (this.mPadding != 0 && this.mPaddingTop == 0) {
                this.mTargetRect.top -= (float)this.mPadding;
            }
            if (this.mPadding != 0 && this.mPaddingRight == 0) {
                this.mTargetRect.right += (float)this.mPadding;
            }
            if (this.mPadding != 0 && this.mPaddingBottom == 0) {
                this.mTargetRect.bottom += (float)this.mPadding;
            }
            if (this.mPaddingLeft != 0) {
                this.mTargetRect.left -= (float)this.mPaddingLeft;
            }
            if (this.mPaddingTop != 0) {
                this.mTargetRect.top -= (float)this.mPaddingTop;
            }
            if (this.mPaddingRight != 0) {
                this.mTargetRect.right += (float)this.mPaddingRight;
            }
            if (this.mPaddingBottom != 0) {
                this.mTargetRect.bottom += (float)this.mPaddingBottom;
            }
            this.ignoreRepadding = true;
        }
    }

    protected LayoutParams generateDefaultLayoutParams() {
        return new LayoutParams(-2, -2);
    }

    protected void dispatchDraw(Canvas canvas) {
        long drawingTime = this.getDrawingTime();
        try {
            for (int i = 0; i < this.getChildCount(); ++i) {
                View child = this.getChildAt(i);
                this.drawChild(canvas, child, drawingTime);
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.mChangedHeight != 0) {
            this.mTargetRect.offset(0.0f, (float)this.mChangedHeight);
            this.mInitHeight += this.mChangedHeight;
            this.mChangedHeight = 0;
        }
        this.mEraserBitmap.eraseColor(0);
        this.mEraserCanvas.drawColor(this.mFullingPaint.getColor());
        if (!this.mOverlayTarget) {
            switch (this.mStyle) {
                case 0: {
                    this.mEraserCanvas.drawRoundRect(this.mTargetRect, (float)this.mCorner, (float)this.mCorner, this.mEraser);
                    break;
                }
                case 1: {
                    this.mEraserCanvas.drawCircle(this.mTargetRect.centerX(), this.mTargetRect.centerY(), this.mTargetRect.width() / 2.0f, this.mEraser);
                    break;
                }
                default: {
                    this.mEraserCanvas.drawRoundRect(this.mTargetRect, (float)this.mCorner, (float)this.mCorner, this.mEraser);
                }
            }
        }
        canvas.drawBitmap(this.mEraserBitmap, this.mOverlayRect.left, this.mOverlayRect.top, null);
    }

    public void setTargetRect(Rect rect) {
        this.mTargetRect.set(rect);
    }

    public void setFullingAlpha(int alpha) {
        this.mFullingPaint.setAlpha(alpha);
    }

    public void setFullingColor(int color2) {
        this.mFullingPaint.setColor(color2);
    }

    public void setHighTargetCorner(int corner) {
        this.mCorner = corner;
    }

    public void setHighTargetGraphStyle(int style2) {
        this.mStyle = style2;
    }

    public void setOverlayTarget(boolean b) {
        this.mOverlayTarget = b;
    }

    public void setPadding(int padding) {
        this.mPadding = padding;
    }

    public void setPaddingLeft(int paddingLeft) {
        this.mPaddingLeft = paddingLeft;
    }

    public void setPaddingTop(int paddingTop) {
        this.mPaddingTop = paddingTop;
    }

    public void setPaddingRight(int paddingRight) {
        this.mPaddingRight = paddingRight;
    }

    public void setPaddingBottom(int paddingBottom) {
        this.mPaddingBottom = paddingBottom;
    }

    static class LayoutParams
    extends ViewGroup.LayoutParams {
        public static final int ANCHOR_LEFT = 1;
        public static final int ANCHOR_TOP = 2;
        public static final int ANCHOR_RIGHT = 3;
        public static final int ANCHOR_BOTTOM = 4;
        public static final int ANCHOR_OVER = 5;
        public static final int PARENT_START = 16;
        public static final int PARENT_CENTER = 32;
        public static final int PARENT_END = 48;
        public int targetAnchor = 4;
        public int targetParentPosition = 32;
        public int offsetX = 0;
        public int offsetY = 0;

        public LayoutParams(Context c, AttributeSet attrs) {
            super(c, attrs);
        }

        public LayoutParams(int width, int height) {
            super(width, height);
        }

        public LayoutParams(ViewGroup.LayoutParams source) {
            super(source);
        }
    }
}

