/*
 * Decompiled with CFR 0.152.
 */
package com.zzh.lib.views.indicators;

import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.view.animation.LinearInterpolator;
import com.zzh.lib.views.def.Indicator;
import java.util.ArrayList;

public class BallScaleIndicator
extends Indicator {
    float scale = 1.0f;
    int alpha = 255;

    @Override
    public void draw(Canvas canvas, Paint paint) {
        float circleSpacing = 4.0f;
        paint.setAlpha(this.alpha);
        canvas.scale(this.scale, this.scale, (float)(this.getWidth() / 2), (float)(this.getHeight() / 2));
        paint.setAlpha(this.alpha);
        canvas.drawCircle((float)(this.getWidth() / 2), (float)(this.getHeight() / 2), (float)(this.getWidth() / 2) - circleSpacing, paint);
    }

    @Override
    public ArrayList<ValueAnimator> onCreateAnimators() {
        ArrayList<ValueAnimator> animators = new ArrayList<ValueAnimator>();
        ValueAnimator scaleAnim = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
        scaleAnim.setInterpolator((TimeInterpolator)new LinearInterpolator());
        scaleAnim.setDuration(1000L);
        scaleAnim.setRepeatCount(-1);
        this.addUpdateListener(scaleAnim, new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                BallScaleIndicator.this.scale = ((Float)animation.getAnimatedValue()).floatValue();
                BallScaleIndicator.this.postInvalidate();
            }
        });
        ValueAnimator alphaAnim = ValueAnimator.ofInt((int[])new int[]{255, 0});
        alphaAnim.setInterpolator((TimeInterpolator)new LinearInterpolator());
        alphaAnim.setDuration(1000L);
        alphaAnim.setRepeatCount(-1);
        this.addUpdateListener(alphaAnim, new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                BallScaleIndicator.this.alpha = (Integer)animation.getAnimatedValue();
                BallScaleIndicator.this.postInvalidate();
            }
        });
        animators.add(scaleAnim);
        animators.add(alphaAnim);
        return animators;
    }
}

