/*
 * Decompiled with CFR 0.152.
 */
package com.zzh.lib.views.indicators;

import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.view.animation.LinearInterpolator;
import com.zzh.lib.views.def.Indicator;
import java.util.ArrayList;

public class CubeTransitionIndicator
extends Indicator {
    float[] translateX = new float[2];
    float[] translateY = new float[2];
    float degrees;
    float scaleFloat = 1.0f;

    @Override
    public void draw(Canvas canvas, Paint paint) {
        float rWidth = this.getWidth() / 5;
        float rHeight = this.getHeight() / 5;
        for (int i = 0; i < 2; ++i) {
            canvas.save();
            canvas.translate(this.translateX[i], this.translateY[i]);
            canvas.rotate(this.degrees);
            canvas.scale(this.scaleFloat, this.scaleFloat);
            RectF rectF = new RectF(-rWidth / 2.0f, -rHeight / 2.0f, rWidth / 2.0f, rHeight / 2.0f);
            canvas.drawRect(rectF, paint);
            canvas.restore();
        }
    }

    @Override
    public ArrayList<ValueAnimator> onCreateAnimators() {
        ArrayList<ValueAnimator> animators = new ArrayList<ValueAnimator>();
        float startX = this.getWidth() / 5;
        float startY = this.getHeight() / 5;
        for (int i = 0; i < 2; ++i) {
            final int index = i;
            this.translateX[index] = startX;
            ValueAnimator translationXAnim = ValueAnimator.ofFloat((float[])new float[]{startX, (float)this.getWidth() - startX, (float)this.getWidth() - startX, startX, startX});
            if (i == 1) {
                translationXAnim = ValueAnimator.ofFloat((float[])new float[]{(float)this.getWidth() - startX, startX, startX, (float)this.getWidth() - startX, (float)this.getWidth() - startX});
            }
            translationXAnim.setInterpolator((TimeInterpolator)new LinearInterpolator());
            translationXAnim.setDuration(1600L);
            translationXAnim.setRepeatCount(-1);
            translationXAnim.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator animation) {
                    CubeTransitionIndicator.this.translateX[index] = ((Float)animation.getAnimatedValue()).floatValue();
                    CubeTransitionIndicator.this.postInvalidate();
                }
            });
            this.translateY[index] = startY;
            ValueAnimator translationYAnim = ValueAnimator.ofFloat((float[])new float[]{startY, startY, (float)this.getHeight() - startY, (float)this.getHeight() - startY, startY});
            if (i == 1) {
                translationYAnim = ValueAnimator.ofFloat((float[])new float[]{(float)this.getHeight() - startY, (float)this.getHeight() - startY, startY, startY, (float)this.getHeight() - startY});
            }
            translationYAnim.setDuration(1600L);
            translationYAnim.setInterpolator((TimeInterpolator)new LinearInterpolator());
            translationYAnim.setRepeatCount(-1);
            this.addUpdateListener(translationYAnim, new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator animation) {
                    CubeTransitionIndicator.this.translateY[index] = ((Float)animation.getAnimatedValue()).floatValue();
                    CubeTransitionIndicator.this.postInvalidate();
                }
            });
            animators.add(translationXAnim);
            animators.add(translationYAnim);
        }
        ValueAnimator scaleAnim = ValueAnimator.ofFloat((float[])new float[]{1.0f, 0.5f, 1.0f, 0.5f, 1.0f});
        scaleAnim.setDuration(1600L);
        scaleAnim.setInterpolator((TimeInterpolator)new LinearInterpolator());
        scaleAnim.setRepeatCount(-1);
        this.addUpdateListener(scaleAnim, new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                CubeTransitionIndicator.this.scaleFloat = ((Float)animation.getAnimatedValue()).floatValue();
                CubeTransitionIndicator.this.postInvalidate();
            }
        });
        ValueAnimator rotateAnim = ValueAnimator.ofFloat((float[])new float[]{0.0f, 180.0f, 360.0f, 540.0f, 720.0f});
        rotateAnim.setDuration(1600L);
        rotateAnim.setInterpolator((TimeInterpolator)new LinearInterpolator());
        rotateAnim.setRepeatCount(-1);
        this.addUpdateListener(rotateAnim, new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                CubeTransitionIndicator.this.degrees = ((Float)animation.getAnimatedValue()).floatValue();
                CubeTransitionIndicator.this.postInvalidate();
            }
        });
        animators.add(scaleAnim);
        animators.add(rotateAnim);
        return animators;
    }
}

