/*
 * Decompiled with CFR 0.152.
 */
package com.zzh.lib.views.indicators;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.util.AttributeSet;
import androidx.annotation.DrawableRes;
import androidx.annotation.Nullable;
import androidx.core.content.ContextCompat;
import androidx.core.graphics.drawable.DrawableCompat;
import com.zzh.lib.views.banner.BaseIndicatorView;

public class DrawableIndicator
extends BaseIndicatorView {
    private Bitmap mCheckedBitmap = null;
    private Bitmap mNormalBitmap;
    private int mIndicatorPadding = 0;
    private int mCheckedBitmapWidth = 0;
    private int mCheckedBitmapHeight = 0;
    private int mNormalBitmapWidth = 0;
    private int mNormalBitmapHeight = 0;
    private IndicatorSize mIndicatorSize = null;
    private boolean normalCanResize = true;
    private boolean checkCanResize = true;

    public DrawableIndicator(Context context) {
        super(context);
    }

    public DrawableIndicator(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    public DrawableIndicator(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public DrawableIndicator(Context context, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int maxHeight = this.mCheckedBitmapHeight;
        if (this.mCheckedBitmapHeight < this.mNormalBitmapHeight) {
            this.mCheckedBitmapHeight = this.mNormalBitmapHeight;
        }
        int realWidth = this.mCheckedBitmapWidth + (this.mNormalBitmapWidth + this.mIndicatorPadding) * (this.getPageSize() - 1);
        this.setMeasuredDimension(realWidth, maxHeight);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.getPageSize() > 1 && this.mCheckedBitmap != null && this.mNormalBitmap != null) {
            for (int i = 1; i < this.getPageSize() + 1; ++i) {
                int top;
                int left;
                Bitmap bitmap = this.mNormalBitmap;
                int index = i - 1;
                if (index < this.getCurrentPosition()) {
                    left = (i - 1) * (this.mNormalBitmapWidth + this.mIndicatorPadding);
                    top = this.getMeasuredHeight() / 2 - this.mNormalBitmapHeight / 2;
                } else if (index == this.getCurrentPosition()) {
                    left = (i - 1) * (this.mNormalBitmapWidth + this.mIndicatorPadding);
                    top = this.getMeasuredHeight() / 2 - this.mCheckedBitmapHeight / 2;
                    bitmap = this.mCheckedBitmap;
                } else {
                    left = (i - 1) * this.mIndicatorPadding + (i - 2) * this.mNormalBitmapWidth + this.mCheckedBitmapWidth;
                    top = this.getMeasuredHeight() / 2 - this.mNormalBitmapHeight / 2;
                }
                this.drawIcon(canvas, left, top, bitmap);
            }
        }
    }

    private void drawIcon(Canvas canvas, int left, int top, Bitmap icon) {
        if (icon == null) {
            return;
        }
        canvas.drawBitmap(icon, (float)left, (float)top, null);
    }

    private void initIconSize() {
        Matrix matrix;
        float scaleHeight;
        float scaleWidth;
        int height;
        int width;
        if (this.mCheckedBitmap != null) {
            if (this.mIndicatorSize != null) {
                if (this.mCheckedBitmap.isMutable() && this.checkCanResize) {
                    this.mCheckedBitmap.setWidth(this.mIndicatorSize.checkedWidth);
                    this.mCheckedBitmap.setHeight(this.mIndicatorSize.checkedHeight);
                } else {
                    width = this.mCheckedBitmap.getWidth();
                    height = this.mCheckedBitmap.getHeight();
                    scaleWidth = this.mIndicatorSize.checkedWidth / width;
                    scaleHeight = this.mIndicatorSize.checkedHeight / height;
                    matrix = new Matrix();
                    matrix.postScale(scaleWidth, scaleHeight);
                    this.mCheckedBitmap = Bitmap.createBitmap((Bitmap)this.mCheckedBitmap, (int)0, (int)0, (int)width, (int)height, (Matrix)matrix, (boolean)true);
                }
            }
            this.mCheckedBitmapWidth = this.mCheckedBitmap.getWidth();
            this.mCheckedBitmapHeight = this.mCheckedBitmap.getHeight();
        }
        if (this.mNormalBitmap != null) {
            if (this.mIndicatorSize != null) {
                if (this.mNormalBitmap.isMutable() && this.normalCanResize) {
                    this.mNormalBitmap.setWidth(this.mIndicatorSize.normalWidth);
                    this.mNormalBitmap.setHeight(this.mIndicatorSize.normalHeight);
                } else {
                    width = this.mNormalBitmap.getWidth();
                    height = this.mNormalBitmap.getHeight();
                    scaleWidth = this.mIndicatorSize.normalWidth / this.mNormalBitmap.getWidth();
                    scaleHeight = this.mIndicatorSize.normalHeight / this.mNormalBitmap.getHeight();
                    matrix = new Matrix();
                    matrix.postScale(scaleWidth, scaleHeight);
                    this.mNormalBitmap = Bitmap.createBitmap((Bitmap)this.mNormalBitmap, (int)0, (int)0, (int)width, (int)height, (Matrix)matrix, (boolean)true);
                }
            }
            this.mNormalBitmapWidth = this.mNormalBitmap.getWidth();
            this.mNormalBitmapHeight = this.mNormalBitmap.getHeight();
        }
    }

    public DrawableIndicator setIndicatorDrawable(@DrawableRes int normalDrawable, @DrawableRes int checkedDrawable) {
        this.mNormalBitmap = BitmapFactory.decodeResource((Resources)this.getResources(), (int)normalDrawable);
        this.mCheckedBitmap = BitmapFactory.decodeResource((Resources)this.getResources(), (int)checkedDrawable);
        if (this.mNormalBitmap == null) {
            this.mNormalBitmap = this.getBitmapFromVectorDrawable(this.context, normalDrawable);
            this.normalCanResize = false;
        }
        if (this.mCheckedBitmap == null) {
            this.mCheckedBitmap = this.getBitmapFromVectorDrawable(this.context, checkedDrawable);
            this.checkCanResize = false;
        }
        this.initIconSize();
        this.postInvalidate();
        return this;
    }

    public DrawableIndicator setIndicatorSize(int normalWidth, int normalHeight, int checkedWidth, int checkedHeight) {
        this.mIndicatorSize = new IndicatorSize(normalWidth, normalHeight, checkedWidth, checkedHeight);
        this.initIconSize();
        this.postInvalidate();
        return this;
    }

    public DrawableIndicator setIndicatorGap(int padding) {
        if (padding >= 0) {
            this.mIndicatorPadding = padding;
            this.postInvalidate();
        }
        return this;
    }

    private Bitmap getBitmapFromVectorDrawable(Context context, int drawableId) {
        Drawable drawable = ContextCompat.getDrawable((Context)context, (int)drawableId);
        if (drawable != null) {
            if (Build.VERSION.SDK_INT < 21) {
                drawable = DrawableCompat.wrap((Drawable)drawable).mutate();
            }
            Bitmap bitmap = Bitmap.createBitmap((int)drawable.getIntrinsicWidth(), (int)drawable.getIntrinsicHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
            Canvas canvas = new Canvas(bitmap);
            drawable.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
            drawable.draw(canvas);
            return bitmap;
        }
        return null;
    }

    static class IndicatorSize {
        public int normalWidth;
        public int normalHeight;
        public int checkedWidth;
        public int checkedHeight;

        public IndicatorSize(int normalWidth, int normalHeight, int checkedWidth, int checkedHeight) {
            this.normalWidth = normalWidth;
            this.normalHeight = normalHeight;
            this.checkedWidth = checkedWidth;
            this.checkedHeight = checkedHeight;
        }
    }
}

