/*
 * Decompiled with CFR 0.152.
 */
package com.zzh.lib.views.interpolator;

import androidx.annotation.NonNull;
import com.zzh.lib.views.utils.Ease;

public class EasingProvider {
    static float get(@NonNull Ease ease, float elapsedTimeRate) {
        switch (ease) {
            case LINEAR: {
                return elapsedTimeRate;
            }
            case QUAD_IN: {
                return EasingProvider.getPowIn(elapsedTimeRate, 2.0);
            }
            case QUAD_OUT: {
                return EasingProvider.getPowOut(elapsedTimeRate, 2.0);
            }
            case QUAD_IN_OUT: {
                return EasingProvider.getPowInOut(elapsedTimeRate, 2.0);
            }
            case CUBIC_IN: {
                return EasingProvider.getPowIn(elapsedTimeRate, 3.0);
            }
            case CUBIC_OUT: {
                return EasingProvider.getPowOut(elapsedTimeRate, 3.0);
            }
            case CUBIC_IN_OUT: {
                return EasingProvider.getPowInOut(elapsedTimeRate, 3.0);
            }
            case QUART_IN: {
                return EasingProvider.getPowIn(elapsedTimeRate, 4.0);
            }
            case QUART_OUT: {
                return EasingProvider.getPowOut(elapsedTimeRate, 4.0);
            }
            case QUART_IN_OUT: {
                return EasingProvider.getPowInOut(elapsedTimeRate, 4.0);
            }
            case QUINT_IN: {
                return EasingProvider.getPowIn(elapsedTimeRate, 5.0);
            }
            case QUINT_OUT: {
                return EasingProvider.getPowOut(elapsedTimeRate, 5.0);
            }
            case QUINT_IN_OUT: {
                return EasingProvider.getPowInOut(elapsedTimeRate, 5.0);
            }
            case SINE_IN: {
                return (float)(1.0 - Math.cos((double)elapsedTimeRate * Math.PI / 2.0));
            }
            case SINE_OUT: {
                return (float)Math.sin((double)elapsedTimeRate * Math.PI / 2.0);
            }
            case SINE_IN_OUT: {
                return (float)(-0.5 * (Math.cos(Math.PI * (double)elapsedTimeRate) - 1.0));
            }
            case BACK_IN: {
                return (float)((double)(elapsedTimeRate * elapsedTimeRate) * (2.7 * (double)elapsedTimeRate - 1.7));
            }
            case BACK_OUT: {
                return (float)((double)((elapsedTimeRate -= 1.0f) * elapsedTimeRate) * (2.7 * (double)elapsedTimeRate + 1.7) + 1.0);
            }
            case BACK_IN_OUT: {
                return EasingProvider.getBackInOut(elapsedTimeRate, 1.7f);
            }
            case CIRC_IN: {
                return (float)(-(Math.sqrt(1.0f - elapsedTimeRate * elapsedTimeRate) - 1.0));
            }
            case CIRC_OUT: {
                return (float)Math.sqrt(1.0f - (elapsedTimeRate -= 1.0f) * elapsedTimeRate);
            }
            case CIRC_IN_OUT: {
                float f;
                elapsedTimeRate *= 2.0f;
                if (f < 1.0f) {
                    return (float)(-0.5 * (Math.sqrt(1.0f - elapsedTimeRate * elapsedTimeRate) - 1.0));
                }
                return (float)(0.5 * (Math.sqrt(1.0f - (elapsedTimeRate -= 2.0f) * elapsedTimeRate) + 1.0));
            }
            case BOUNCE_IN: {
                return EasingProvider.getBounceIn(elapsedTimeRate);
            }
            case BOUNCE_OUT: {
                return EasingProvider.getBounceOut(elapsedTimeRate);
            }
            case BOUNCE_IN_OUT: {
                if (elapsedTimeRate < 0.5f) {
                    return EasingProvider.getBounceIn(elapsedTimeRate * 2.0f) * 0.5f;
                }
                return EasingProvider.getBounceOut(elapsedTimeRate * 2.0f - 1.0f) * 0.5f + 0.5f;
            }
            case ELASTIC_IN: {
                return EasingProvider.getElasticIn(elapsedTimeRate, 1.0, 0.3);
            }
            case ELASTIC_OUT: {
                return EasingProvider.getElasticOut(elapsedTimeRate, 1.0, 0.3);
            }
            case ELASTIC_IN_OUT: {
                return EasingProvider.getElasticInOut(elapsedTimeRate, 1.0, 0.45);
            }
            case EASE_IN_EXPO: {
                return (float)Math.pow(2.0, 10.0f * (elapsedTimeRate - 1.0f));
            }
            case EASE_OUT_EXPO: {
                return (float)(-Math.pow(2.0, -10.0f * elapsedTimeRate)) + 1.0f;
            }
            case EASE_IN_OUT_EXPO: {
                float f;
                elapsedTimeRate *= 2.0f;
                if (f < 1.0f) {
                    return (float)Math.pow(2.0, 10.0f * (elapsedTimeRate - 1.0f)) * 0.5f;
                }
                return (float)(-Math.pow(2.0, -10.0f * (elapsedTimeRate -= 1.0f)) + 2.0) * 0.5f;
            }
        }
        return elapsedTimeRate;
    }

    private static float getPowIn(float elapsedTimeRate, double pow) {
        return (float)Math.pow(elapsedTimeRate, pow);
    }

    private static float getPowOut(float elapsedTimeRate, double pow) {
        return (float)(1.0 - Math.pow(1.0f - elapsedTimeRate, pow));
    }

    private static float getPowInOut(float elapsedTimeRate, double pow) {
        float f;
        elapsedTimeRate *= 2.0f;
        if (f < 1.0f) {
            return (float)(0.5 * Math.pow(elapsedTimeRate, pow));
        }
        return (float)(1.0 - 0.5 * Math.abs(Math.pow(2.0f - elapsedTimeRate, pow)));
    }

    private static float getBackInOut(float elapsedTimeRate, float amount) {
        float f;
        amount = (float)((double)amount * 1.525);
        elapsedTimeRate *= 2.0f;
        if (f < 1.0f) {
            return (float)(0.5 * (double)(elapsedTimeRate * elapsedTimeRate * ((amount + 1.0f) * elapsedTimeRate - amount)));
        }
        return (float)(0.5 * (double)((elapsedTimeRate -= 2.0f) * elapsedTimeRate * ((amount + 1.0f) * elapsedTimeRate + amount) + 2.0f));
    }

    private static float getBounceIn(float elapsedTimeRate) {
        return 1.0f - EasingProvider.getBounceOut(1.0f - elapsedTimeRate);
    }

    private static float getBounceOut(float elapsedTimeRate) {
        if ((double)elapsedTimeRate < 0.36363636363636365) {
            return (float)(7.5625 * (double)elapsedTimeRate * (double)elapsedTimeRate);
        }
        if ((double)elapsedTimeRate < 0.7272727272727273) {
            elapsedTimeRate = (float)((double)elapsedTimeRate - 0.5454545454545454);
            return (float)(7.5625 * (double)elapsedTimeRate * (double)elapsedTimeRate + 0.75);
        }
        if ((double)elapsedTimeRate < 0.9090909090909091) {
            elapsedTimeRate = (float)((double)elapsedTimeRate - 0.8181818181818182);
            return (float)(7.5625 * (double)elapsedTimeRate * (double)elapsedTimeRate + 0.9375);
        }
        elapsedTimeRate = (float)((double)elapsedTimeRate - 0.9545454545454546);
        return (float)(7.5625 * (double)elapsedTimeRate * (double)elapsedTimeRate + 0.984375);
    }

    private static float getElasticIn(float elapsedTimeRate, double amplitude, double period) {
        if (elapsedTimeRate == 0.0f || elapsedTimeRate == 1.0f) {
            return elapsedTimeRate;
        }
        double pi2 = Math.PI * 2;
        double s = period / pi2 * Math.asin(1.0 / amplitude);
        return (float)(-(amplitude * Math.pow(2.0, 10.0f * (elapsedTimeRate -= 1.0f)) * Math.sin(((double)elapsedTimeRate - s) * pi2 / period)));
    }

    private static float getElasticOut(float elapsedTimeRate, double amplitude, double period) {
        if (elapsedTimeRate == 0.0f || elapsedTimeRate == 1.0f) {
            return elapsedTimeRate;
        }
        double pi2 = Math.PI * 2;
        double s = period / pi2 * Math.asin(1.0 / amplitude);
        return (float)(amplitude * Math.pow(2.0, -10.0f * elapsedTimeRate) * Math.sin(((double)elapsedTimeRate - s) * pi2 / period) + 1.0);
    }

    private static float getElasticInOut(float elapsedTimeRate, double amplitude, double period) {
        float f;
        double pi2 = Math.PI * 2;
        double s = period / pi2 * Math.asin(1.0 / amplitude);
        elapsedTimeRate *= 2.0f;
        if (f < 1.0f) {
            return (float)(-0.5 * (amplitude * Math.pow(2.0, 10.0f * (elapsedTimeRate -= 1.0f)) * Math.sin(((double)elapsedTimeRate - s) * pi2 / period)));
        }
        return (float)(amplitude * Math.pow(2.0, -10.0f * (elapsedTimeRate -= 1.0f)) * Math.sin(((double)elapsedTimeRate - s) * pi2 / period) * 0.5 + 1.0);
    }
}

