/*
 * Decompiled with CFR 0.152.
 */
package com.zzh.lib.views.progressbar;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.RectF;
import android.util.AttributeSet;
import com.zzh.lib.views.R;
import com.zzh.lib.views.progressbar.HFloatTextProgressBar;

public class HCircleProgressBar
extends HFloatTextProgressBar {
    private float textSize;
    private float progressWidth;
    private int smallCircleColor;

    public HCircleProgressBar(Context context) {
        super(context);
    }

    public HCircleProgressBar(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(attrs);
    }

    public HCircleProgressBar(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(attrs);
    }

    private void init(AttributeSet attrs) {
        TypedArray a = this.context.obtainStyledAttributes(attrs, R.styleable.HCircleProgressBar);
        this.textSize = a.getDimension(R.styleable.HCircleProgressBar_zh_text_size, this.dip2px(15.0f));
        this.progressWidth = a.getDimension(R.styleable.HCircleProgressBar_zh_progress_width, this.dip2px(3.0f));
        this.smallCircleColor = a.getColor(R.styleable.HCircleProgressBar_zh_small_circle_color, -1);
        a.recycle();
    }

    @Override
    public void drawProgress(Canvas canvas) {
        this.paint.setColor(this.backgroundColor);
        canvas.drawCircle(this.width / 2.0f, this.height / 2.0f, this.width / 2.0f, this.paint);
        this.paint.setColor(this.fillColor);
        float angle = (float)this.progress / 1.0f / (float)this.maxProgress * 360.0f;
        RectF rectF = new RectF(0.0f, 0.0f, this.width, this.height);
        canvas.drawArc(rectF, -90.0f, angle, true, this.paint);
        this.paint.setColor(this.smallCircleColor);
        canvas.drawCircle(this.width / 2.0f, this.height / 2.0f, this.width / 2.0f - this.progressWidth, this.paint);
    }

    @Override
    public void drawText(Canvas canvas) {
        this.initPaint();
        float progressRate = (float)this.progress * 100.0f / (float)this.maxProgress;
        String progressText = progressRate + "%";
        this.paint.setTextSize(this.textSize);
        this.paint.setColor(this.textColor);
        float textWidth = this.paint.measureText(progressText);
        canvas.drawText(progressText, this.width / 2.0f - textWidth / 2.0f, this.height / 2.0f + this.textSize / 3.0f, this.paint);
    }

    public void setProgressWidth(float progressWidth) {
        this.progressWidth = progressWidth;
    }

    public void setTextSize(float textSize) {
        this.textSize = textSize;
    }

    public void setSmallCircleColor(int smallCircleColor) {
        this.smallCircleColor = smallCircleColor;
    }
}

