/*
 * Decompiled with CFR 0.152.
 */
package com.zzh.lib.views.progressbar;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.LinearGradient;
import android.graphics.RectF;
import android.graphics.Shader;
import android.util.AttributeSet;
import com.zzh.lib.views.R;
import com.zzh.lib.views.progressbar.AbsProgressBar;

public class HProgressBar
extends AbsProgressBar {
    protected int startFillColor;
    protected int middleFillColor;
    protected int endFillColor;
    protected float progressWidth;
    private int arrowPointColor;

    public HProgressBar(Context context) {
        super(context);
    }

    public HProgressBar(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(attrs);
    }

    public HProgressBar(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(attrs);
    }

    private void init(AttributeSet attrs) {
        TypedArray a = this.context.obtainStyledAttributes(attrs, R.styleable.HProgressBar);
        this.startFillColor = a.getColor(R.styleable.HProgressBar_zh_start_fill_color, -65536);
        this.middleFillColor = a.getColor(R.styleable.HProgressBar_zh_middle_fill_color, -65536);
        this.endFillColor = a.getColor(R.styleable.HProgressBar_zh_end_fill_color, -65536);
        this.arrowPointColor = a.getColor(R.styleable.HProgressBar_zh_arrow_point_color, -1);
        a.recycle();
    }

    @Override
    protected void getDimension() {
        super.getDimension();
        this.progressWidth = (float)this.progress / 1.0f / (float)this.maxProgress * this.width;
    }

    @Override
    public void drawProgress(Canvas canvas) {
        if (this.progressWidth < this.height / 2.0f - this.dip2px(2.0f)) {
            this.paint.setColor(this.backgroundColor);
            RectF rectF = new RectF(0.0f, 0.0f, this.width, this.height);
            canvas.drawRoundRect(rectF, this.height / 2.0f, this.height / 2.0f, this.paint);
            this.paint.setColor(this.arrowPointColor);
            canvas.drawCircle(this.height / 2.0f, this.height / 2.0f, this.height / 2.0f - this.dip2px(2.0f), this.paint);
        } else if (this.progressWidth > this.height / 2.0f - this.dip2px(2.0f)) {
            this.paint.setColor(this.backgroundColor);
            RectF backgroundRectF = new RectF(0.0f, 0.0f, this.width, this.height);
            canvas.drawRoundRect(backgroundRectF, this.height / 2.0f, this.height / 2.0f, this.paint);
            this.paint.setShader(this.getShader(this.progressWidth));
            RectF fillRectF = new RectF(0.0f, 0.0f, this.progressWidth, this.height);
            canvas.drawRoundRect(fillRectF, this.height / 2.0f, this.height / 2.0f, this.paint);
            this.initPaint();
            this.paint.setColor(this.arrowPointColor);
            canvas.drawCircle(this.progressWidth - this.height / 2.0f, this.height / 2.0f, this.height / 2.0f - this.dip2px(2.0f), this.paint);
        } else {
            this.paint.setShader(this.getShader(this.progressWidth));
            RectF fillRectF = new RectF(0.0f, 0.0f, this.progressWidth, this.height);
            canvas.drawRoundRect(fillRectF, this.height / 2.0f, this.height / 2.0f, this.paint);
            this.initPaint();
            this.paint.setColor(this.arrowPointColor);
            canvas.drawCircle(this.progressWidth - this.height / 2.0f, this.height / 2.0f, this.height / 2.0f - this.dip2px(2.0f), this.paint);
        }
    }

    protected Shader getShader(float width) {
        int[] colors = new int[3];
        float[] positions = new float[3];
        colors[0] = this.startFillColor;
        positions[0] = 0.0f;
        colors[1] = this.middleFillColor;
        positions[1] = 0.5f;
        colors[2] = this.endFillColor;
        positions[2] = 1.0f;
        return new LinearGradient(0.0f, 0.0f, width, 0.0f, colors, positions, Shader.TileMode.MIRROR);
    }

    public void setStartFillColor(int startFillColor) {
        this.startFillColor = startFillColor;
    }

    public void setMiddleFillColor(int middleFillColor) {
        this.middleFillColor = middleFillColor;
    }

    public void setEndFillColor(int endFillColor) {
        this.endFillColor = endFillColor;
    }

    public void setArrowPointColor(int arrowPointColor) {
        this.arrowPointColor = arrowPointColor;
    }
}

