/*
 * Decompiled with CFR 0.152.
 */
package com.zzh.lib.views.refresh;

import android.content.Context;
import android.content.res.TypedArray;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import androidx.core.view.ViewCompat;
import com.zzh.lib.views.R;
import com.zzh.lib.views.def.LoadingView;
import com.zzh.lib.views.def.PullToRefreshView;
import com.zzh.lib.views.gesture.HTouchHelper;
import com.zzh.lib.views.refresh.loading.SimpleTextLoadingView;
import java.lang.reflect.Constructor;

public abstract class BasePullToRefreshView
extends ViewGroup
implements PullToRefreshView {
    private LoadingView mHeaderView;
    private LoadingView mFooterView;
    private View mRefreshView;
    private PullToRefreshView.Mode mMode = PullToRefreshView.Mode.PULL_BOTH;
    private PullToRefreshView.State mState = PullToRefreshView.State.RESET;
    private PullToRefreshView.Direction mDirection = PullToRefreshView.Direction.NONE;
    private boolean mIsOverLayMode = false;
    private float mComsumeScrollPercent = 0.5f;
    private int mDurationShowRefreshResult = 600;
    private PullToRefreshView.OnRefreshCallback mOnRefreshCallback;
    private PullToRefreshView.OnStateChangeCallback mOnStateChangeCallback;
    private PullToRefreshView.OnViewPositionChangeCallback mOnViewPositionChangeCallback;
    private PullToRefreshView.PullCondition mPullCondition;
    private String footerViewClass;
    private String headerViewClass;
    protected boolean mIsDebug;
    private boolean mIsDebugLayout;
    private final Runnable mStopRefreshingRunnable = new Runnable(){

        @Override
        public void run() {
            BasePullToRefreshView.this.stopRefreshing();
        }
    };

    public BasePullToRefreshView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initAttrs(context, attrs);
        this.addLoadingViews();
    }

    private void initAttrs(Context context, AttributeSet attrs) {
        TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.BasePullToRefreshView);
        this.footerViewClass = ta.getString(R.styleable.BasePullToRefreshView_zh_ptr_footer_class);
        this.headerViewClass = ta.getString(R.styleable.BasePullToRefreshView_zh_ptr_header_class);
        this.mDurationShowRefreshResult = ta.getInt(R.styleable.BasePullToRefreshView_zh_ptr_duration_refresh_result, 600);
        ta.recycle();
    }

    public void setDebug(boolean debug) {
        this.mIsDebug = debug;
    }

    public final void setDebugLayout(boolean debugLayout) {
        this.mIsDebugLayout = debugLayout;
    }

    protected final String getDebugTag() {
        return this.getClass().getSimpleName();
    }

    protected final ViewGroup.LayoutParams generateDefaultLayoutParams() {
        return new ViewGroup.LayoutParams(-1, -2);
    }

    @Override
    public void setMode(PullToRefreshView.Mode mode) {
        if (mode == null) {
            throw new NullPointerException("mode is null");
        }
        this.mMode = mode;
    }

    @Override
    public void setOnRefreshCallback(PullToRefreshView.OnRefreshCallback onRefreshCallback) {
        this.mOnRefreshCallback = onRefreshCallback;
    }

    @Override
    public void setOnStateChangeCallback(PullToRefreshView.OnStateChangeCallback onStateChangeCallback) {
        this.mOnStateChangeCallback = onStateChangeCallback;
    }

    @Override
    public void setOnViewPositionChangeCallback(PullToRefreshView.OnViewPositionChangeCallback onViewPositionChangeCallback) {
        this.mOnViewPositionChangeCallback = onViewPositionChangeCallback;
    }

    @Override
    public void setPullCondition(PullToRefreshView.PullCondition pullCondition) {
        this.mPullCondition = pullCondition;
    }

    @Override
    public void setOverLayMode(boolean overLayMode) {
        if (this.mState == PullToRefreshView.State.RESET) {
            this.mIsOverLayMode = overLayMode;
        }
    }

    @Override
    public boolean isOverLayMode() {
        return this.mIsOverLayMode;
    }

    @Override
    public void setComsumeScrollPercent(float percent) {
        if (percent < 0.0f || percent > 1.0f) {
            throw new IllegalArgumentException("percent >= 0 && percent <= 1 required");
        }
        this.mComsumeScrollPercent = percent;
    }

    @Override
    public void setDurationShowRefreshResult(int duration) {
        if (duration <= 0) {
            throw new IllegalArgumentException("duration > 0 required");
        }
        this.mDurationShowRefreshResult = duration;
    }

    @Override
    public void startRefreshingFromHeader() {
        if (this.mState == PullToRefreshView.State.RESET) {
            this.setDirection(PullToRefreshView.Direction.FROM_HEADER);
            this.setState(PullToRefreshView.State.REFRESHING);
            this.updateViewByState();
        }
    }

    @Override
    public void startRefreshingFromFooter() {
        if (this.mState == PullToRefreshView.State.RESET) {
            this.setDirection(PullToRefreshView.Direction.FROM_FOOTER);
            this.setState(PullToRefreshView.State.REFRESHING);
            this.updateViewByState();
        }
    }

    @Override
    public void stopRefreshing() {
        if (this.mState == PullToRefreshView.State.REFRESHING || this.mState == PullToRefreshView.State.REFRESHING_SUCCESS || this.mState == PullToRefreshView.State.REFRESHING_FAILURE) {
            this.setState(PullToRefreshView.State.FINISH);
            this.updateViewByState();
        }
    }

    @Override
    public void stopRefreshingWithResult(boolean success) {
        if (this.mState == PullToRefreshView.State.REFRESHING) {
            if (success) {
                this.setState(PullToRefreshView.State.REFRESHING_SUCCESS);
            } else {
                this.setState(PullToRefreshView.State.REFRESHING_FAILURE);
            }
        }
    }

    @Override
    public boolean isRefreshing() {
        return this.mState == PullToRefreshView.State.REFRESHING;
    }

    @Override
    public PullToRefreshView.State getState() {
        return this.mState;
    }

    @Override
    public PullToRefreshView.Mode getMode() {
        return this.mMode;
    }

    @Override
    public LoadingView getHeaderView() {
        return this.mHeaderView;
    }

    @Override
    public void setHeaderView(LoadingView headerView) {
        if (headerView == null || headerView == this.mHeaderView) {
            return;
        }
        if (!(headerView instanceof View)) {
            throw new IllegalArgumentException("headerView must be instance of " + View.class);
        }
        this.removeView((View)this.mHeaderView);
        this.addView((View)headerView);
        this.mHeaderView = headerView;
    }

    @Override
    public LoadingView getFooterView() {
        return this.mFooterView;
    }

    @Override
    public void setFooterView(LoadingView footerView) {
        if (footerView == null || footerView == this.mFooterView) {
            return;
        }
        if (!(footerView instanceof View)) {
            throw new IllegalArgumentException("footerView must be instance of " + View.class);
        }
        this.removeView((View)this.mFooterView);
        this.addView((View)footerView);
        this.mFooterView = footerView;
    }

    @Override
    public View getRefreshView() {
        return this.mRefreshView;
    }

    @Override
    public PullToRefreshView.Direction getDirection() {
        return this.mDirection;
    }

    @Override
    public int getScrollDistance() {
        LoadingView loadingView = this.getLoadingViewByDirection();
        if (loadingView == null) {
            return 0;
        }
        int topReset = this.getTopLoadingViewReset(loadingView);
        int distance = ((View)loadingView).getTop() - topReset;
        return Math.abs(distance);
    }

    protected abstract boolean isViewIdle();

    protected abstract boolean smoothScroll(int var1, int var2);

    protected final void updateViewByState() {
        LoadingView loadingView = this.getLoadingViewByDirection();
        int startY = ((View)loadingView).getTop();
        int endY = 0;
        switch (this.getState()) {
            case RESET: 
            case PULL_TO_REFRESH: 
            case FINISH: {
                endY = this.getTopLoadingViewReset(loadingView);
                break;
            }
            case RELEASE_TO_REFRESH: 
            case REFRESHING: {
                endY = this.getTopLoadingViewRefreshing(loadingView);
            }
        }
        if (this.mIsDebug) {
            String headerOrFooter = loadingView == this.mHeaderView ? "Header" : "Footer";
            Log.i((String)this.getDebugTag(), (String)("updateViewByState " + headerOrFooter + " " + startY + " -> " + endY + " " + (Object)((Object)this.getState())));
        }
        if (!this.smoothScroll(startY, endY)) {
            this.dealViewIdle();
        }
    }

    protected final void dealViewIdle() {
        if (this.isViewIdle()) {
            if (this.mIsDebug) {
                Log.i((String)this.getDebugTag(), (String)("dealViewIdle:" + (Object)((Object)this.mState)));
            }
            switch (this.getState()) {
                case REFRESHING: {
                    this.requestLayoutIfNeed();
                    this.notifyRefreshCallback();
                    break;
                }
                case PULL_TO_REFRESH: 
                case FINISH: {
                    this.setState(PullToRefreshView.State.RESET);
                    break;
                }
                case RESET: {
                    this.resetIfNeed();
                }
            }
        } else if (this.mIsDebug) {
            Log.e((String)this.getDebugTag(), (String)"try dealViewIdle when view is busy");
        }
    }

    private void notifyRefreshCallback() {
        if (this.mState != PullToRefreshView.State.REFRESHING) {
            throw new RuntimeException("Illegal state:" + (Object)((Object)this.mState));
        }
        if (this.mIsDebug) {
            Log.i((String)this.getDebugTag(), (String)("notifyRefreshCallback:" + (Object)((Object)this.mDirection)));
        }
        if (this.mOnRefreshCallback != null) {
            if (this.mDirection == PullToRefreshView.Direction.FROM_HEADER) {
                this.mOnRefreshCallback.onRefreshingFromHeader(this);
            } else if (this.mDirection == PullToRefreshView.Direction.FROM_FOOTER) {
                this.mOnRefreshCallback.onRefreshingFromFooter(this);
            }
        }
    }

    protected final boolean canPullFromHeader() {
        return (this.getMode() == PullToRefreshView.Mode.PULL_BOTH || this.getMode() == PullToRefreshView.Mode.PULL_FROM_HEADER) && HTouchHelper.isScrollToTop(this.getRefreshView()) && this.checkPullConditionHeader();
    }

    protected final boolean canPullFromFooter() {
        return (this.getMode() == PullToRefreshView.Mode.PULL_BOTH || this.getMode() == PullToRefreshView.Mode.PULL_FROM_FOOTER) && HTouchHelper.isScrollToBottom(this.getRefreshView()) && this.checkPullConditionFooter();
    }

    private boolean checkPullConditionHeader() {
        return this.mPullCondition == null || this.mPullCondition.canPullFromHeader(this);
    }

    private boolean checkPullConditionFooter() {
        return this.mPullCondition == null || this.mPullCondition.canPullFromFooter(this);
    }

    private void checkDirection() {
        if (this.mDirection == PullToRefreshView.Direction.NONE) {
            throw new RuntimeException("The direction has not been specified before this");
        }
    }

    protected final LoadingView getLoadingViewByDirection() {
        if (this.mDirection == PullToRefreshView.Direction.FROM_HEADER) {
            return this.mHeaderView;
        }
        if (this.mDirection == PullToRefreshView.Direction.FROM_FOOTER) {
            return this.mFooterView;
        }
        return null;
    }

    protected final boolean moveViews(int delta, boolean isDrag) {
        if (delta == 0) {
            return false;
        }
        if (isDrag && (delta = this.getComsumedDistance(delta)) == 0) {
            return false;
        }
        this.checkDirection();
        LoadingView loadingView = this.getLoadingViewByDirection();
        int top = ((View)loadingView).getTop();
        int topReset = this.getTopLoadingViewReset(loadingView);
        if (loadingView == this.mHeaderView) {
            delta = HTouchHelper.getLegalDelta(top, topReset, Integer.MAX_VALUE, delta);
        } else if (loadingView == this.mFooterView) {
            delta = HTouchHelper.getLegalDelta(top, Integer.MIN_VALUE, topReset, delta);
        }
        if (delta == 0) {
            return false;
        }
        ViewCompat.offsetTopAndBottom((View)((View)loadingView), (int)delta);
        loadingView.onViewPositionChanged(this);
        if (this.mIsOverLayMode) {
            if (ViewCompat.getZ((View)((View)loadingView)) <= ViewCompat.getZ((View)this.mRefreshView)) {
                ViewCompat.setZ((View)((View)loadingView), (float)(ViewCompat.getZ((View)this.mRefreshView) + 1.0f));
            }
        } else {
            ViewCompat.offsetTopAndBottom((View)this.mRefreshView, (int)delta);
        }
        if (this.mOnViewPositionChangeCallback != null) {
            this.mOnViewPositionChangeCallback.onViewPositionChanged(this);
        }
        if (isDrag) {
            if (loadingView.canRefresh(this.getScrollDistance())) {
                this.setState(PullToRefreshView.State.RELEASE_TO_REFRESH);
            } else {
                this.setState(PullToRefreshView.State.PULL_TO_REFRESH);
            }
        }
        return true;
    }

    protected final void setState(PullToRefreshView.State state) {
        if (this.mState == state) {
            return;
        }
        this.checkDirection();
        PullToRefreshView.State oldState = this.mState;
        this.mState = state;
        if (this.mIsDebug) {
            Log.i((String)this.getDebugTag(), (String)("setState:" + (Object)((Object)this.mState)));
        }
        this.removeCallbacks(this.mStopRefreshingRunnable);
        if (this.mState == PullToRefreshView.State.REFRESHING_SUCCESS || this.mState == PullToRefreshView.State.REFRESHING_FAILURE) {
            this.postDelayed(this.mStopRefreshingRunnable, this.mDurationShowRefreshResult);
        }
        LoadingView loadingView = this.getLoadingViewByDirection();
        loadingView.onStateChanged(oldState, this.mState, this);
        if (this.mOnStateChangeCallback != null) {
            this.mOnStateChangeCallback.onStateChanged(oldState, this.mState, this);
        }
        this.resetIfNeed();
    }

    private void resetIfNeed() {
        if (this.mState == PullToRefreshView.State.RESET) {
            this.requestLayoutIfNeed();
            this.setDirection(PullToRefreshView.Direction.NONE);
        }
    }

    private void requestLayoutIfNeed() {
        LoadingView loadingView = this.getLoadingViewByDirection();
        if (loadingView == null) {
            return;
        }
        if (this.isViewIdle()) {
            boolean layout2 = false;
            switch (this.mState) {
                case REFRESHING: {
                    if (((View)loadingView).getTop() == this.getTopLoadingViewRefreshing(loadingView)) break;
                    layout2 = true;
                    break;
                }
                case RESET: {
                    if (((View)loadingView).getTop() == this.getTopLoadingViewReset(loadingView)) break;
                    layout2 = true;
                }
            }
            if (layout2) {
                if (this.mIsDebug) {
                    Log.e((String)this.getDebugTag(), (String)("requestLayout with state:" + (Object)((Object)this.mState)));
                }
                this.requestLayout();
            }
        } else if (this.mIsDebug) {
            Log.e((String)this.getDebugTag(), (String)"try requestLayoutIfNeed when view is busy");
        }
    }

    protected final void setDirection(PullToRefreshView.Direction direction) {
        if (direction == null) {
            throw new NullPointerException("direction is null");
        }
        if (this.mDirection == direction) {
            return;
        }
        if (direction != PullToRefreshView.Direction.NONE) {
            if (this.mDirection == PullToRefreshView.Direction.NONE) {
                this.mDirection = direction;
                if (this.mIsDebug) {
                    Log.i((String)this.getDebugTag(), (String)("setDirection:" + (Object)((Object)this.mDirection)));
                }
            }
        } else {
            this.mDirection = PullToRefreshView.Direction.NONE;
            if (this.mIsDebug) {
                Log.i((String)this.getDebugTag(), (String)("setDirection:" + (Object)((Object)this.mDirection)));
            }
        }
    }

    private int getComsumedDistance(float distance) {
        distance -= distance * this.mComsumeScrollPercent;
        return (int)distance;
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        int count = this.getChildCount();
        if (count < 3) {
            throw new IllegalArgumentException("you must add one child to PullToRefreshView in your xml file");
        }
        if (count > 3) {
            throw new IllegalArgumentException("you can only add one child to PullToRefreshView in your xml file");
        }
        this.mRefreshView = this.getChildAt(2);
    }

    private void addLoadingViews() {
        String footerClassName;
        String headerClassName;
        LoadingView headerView = this.onCreateHeaderView();
        if (headerView == null && !TextUtils.isEmpty((CharSequence)(headerClassName = this.getResources().getString(R.string.zh_ptr_header_class)))) {
            headerView = this.createLoadingViewByClassName(headerClassName);
        }
        if (headerView == null) {
            headerView = new SimpleTextLoadingView(this.getContext());
        }
        this.setHeaderView(headerView);
        LoadingView footerView = this.onCreateFooterView();
        if (footerView == null && !TextUtils.isEmpty((CharSequence)(footerClassName = this.getResources().getString(R.string.zh_ptr_footer_class)))) {
            footerView = this.createLoadingViewByClassName(footerClassName);
        }
        if (footerView == null) {
            footerView = new SimpleTextLoadingView(this.getContext());
        }
        this.setFooterView(footerView);
    }

    private LoadingView createLoadingViewByClassName(String className) {
        try {
            Class<?> clazz = Class.forName(className);
            Constructor<?> constructor = clazz.getConstructor(Context.class);
            return (LoadingView)constructor.newInstance(this.getContext());
        }
        catch (Exception e) {
            if (this.mIsDebug) {
                e.printStackTrace();
            }
            return null;
        }
    }

    protected LoadingView onCreateHeaderView() {
        if (TextUtils.isEmpty((CharSequence)this.headerViewClass)) {
            return null;
        }
        return this.createLoadingViewByClassName(this.headerViewClass);
    }

    protected LoadingView onCreateFooterView() {
        if (TextUtils.isEmpty((CharSequence)this.footerViewClass)) {
            return null;
        }
        return this.createLoadingViewByClassName(this.headerViewClass);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int width = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int height = View.MeasureSpec.getSize((int)heightMeasureSpec);
        this.measureChild((View)this.mHeaderView, widthMeasureSpec, heightMeasureSpec);
        this.measureChild((View)this.mFooterView, widthMeasureSpec, heightMeasureSpec);
        this.measureChild(this.mRefreshView, widthMeasureSpec, heightMeasureSpec);
        if (widthMode != 0x40000000) {
            int maxWidth = Math.max(((View)this.mHeaderView).getMeasuredWidth(), ((View)this.mFooterView).getMeasuredWidth());
            maxWidth = Math.max(maxWidth, this.mRefreshView.getMeasuredWidth());
            maxWidth += this.getPaddingLeft() + this.getPaddingRight();
            maxWidth = Math.max(maxWidth, this.getSuggestedMinimumWidth());
            if (widthMode == 0) {
                width = maxWidth;
            } else if (widthMode == Integer.MIN_VALUE) {
                width = Math.min(maxWidth, width);
            }
        }
        if (heightMode != 0x40000000) {
            int maxHeight = this.mRefreshView.getMeasuredHeight();
            if (maxHeight == 0) {
                maxHeight = Math.max(((View)this.mHeaderView).getMeasuredHeight(), ((View)this.mFooterView).getMeasuredHeight());
            }
            maxHeight += this.getPaddingTop() + this.getPaddingBottom();
            maxHeight = Math.max(maxHeight, this.getSuggestedMinimumHeight());
            if (heightMode == 0) {
                height = maxHeight;
            } else if (heightMode == Integer.MIN_VALUE) {
                height = Math.min(maxHeight, height);
            }
        }
        this.setMeasuredDimension(width, height);
    }

    private int getTopAlignTop() {
        return this.getPaddingTop();
    }

    private int getTopAlignBottom() {
        return this.getHeight() - this.getPaddingBottom();
    }

    private int getTopLoadingViewReset(LoadingView loadingView) {
        if (loadingView == this.mHeaderView) {
            return this.getTopAlignTop() - ((View)this.mHeaderView).getMeasuredHeight();
        }
        if (loadingView == this.mFooterView) {
            return this.getTopAlignBottom();
        }
        throw new IllegalArgumentException("Illegal loadingView:" + loadingView);
    }

    private int getTopLoadingViewRefreshing(LoadingView loadingView) {
        int reset = this.getTopLoadingViewReset(loadingView);
        if (loadingView == this.mHeaderView) {
            return reset + this.mHeaderView.getRefreshingHeight();
        }
        if (loadingView == this.mFooterView) {
            return reset - this.mFooterView.getRefreshingHeight();
        }
        throw new IllegalArgumentException("Illegal loadingView:" + loadingView);
    }

    private int getTopLayoutHeaderView() {
        int top = this.getTopLoadingViewReset(this.mHeaderView);
        if (this.mDirection == PullToRefreshView.Direction.FROM_HEADER) {
            if (this.isViewIdle()) {
                switch (this.mState) {
                    case REFRESHING: 
                    case REFRESHING_SUCCESS: 
                    case REFRESHING_FAILURE: {
                        top += this.mHeaderView.getRefreshingHeight();
                    }
                }
            } else {
                top = ((View)this.mHeaderView).getTop();
            }
        }
        return top;
    }

    private int getTopLayoutFooterView() {
        int top = this.getTopLoadingViewReset(this.mFooterView);
        if (this.mDirection == PullToRefreshView.Direction.FROM_FOOTER) {
            if (this.isViewIdle()) {
                switch (this.mState) {
                    case REFRESHING: 
                    case REFRESHING_SUCCESS: 
                    case REFRESHING_FAILURE: {
                        top -= this.mFooterView.getRefreshingHeight();
                    }
                }
            } else {
                top = ((View)this.mFooterView).getTop();
            }
        }
        return top;
    }

    private int getTopLayoutRefreshView() {
        int top = this.getTopAlignTop();
        if (!this.mIsOverLayMode) {
            if (this.isViewIdle()) {
                switch (this.mState) {
                    case REFRESHING: 
                    case REFRESHING_SUCCESS: 
                    case REFRESHING_FAILURE: {
                        if (this.mDirection == PullToRefreshView.Direction.FROM_HEADER) {
                            top += this.mHeaderView.getRefreshingHeight();
                            break;
                        }
                        if (this.mDirection != PullToRefreshView.Direction.FROM_FOOTER) break;
                        top -= this.mFooterView.getRefreshingHeight();
                    }
                }
            } else {
                top = this.mRefreshView.getTop();
            }
        }
        return top;
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        if (this.mIsDebugLayout) {
            Log.i((String)this.getDebugTag(), (String)"onLayout");
        }
        this.layoutInternal();
    }

    private void layoutInternal() {
        String logString = "";
        if (this.mIsDebugLayout) {
            logString = logString + "----------layoutInternal height:" + this.getHeight() + " " + (Object)((Object)this.mState) + "\r\n";
        }
        int left = this.getPaddingLeft();
        int top = 0;
        int right = 0;
        int bottom = 0;
        top = this.getTopLayoutHeaderView();
        right = left + ((View)this.mHeaderView).getMeasuredWidth();
        bottom = top + ((View)this.mHeaderView).getMeasuredHeight();
        ((View)this.mHeaderView).layout(left, top, right, bottom);
        if (this.mIsDebugLayout) {
            logString = logString + "HeaderView:" + top + "," + bottom + " -> " + (bottom - top) + "\r\n";
        }
        top = this.getTopLayoutRefreshView();
        if (!this.mIsOverLayMode && this.mDirection == PullToRefreshView.Direction.FROM_HEADER && bottom > top) {
            top = bottom;
        }
        right = left + this.mRefreshView.getMeasuredWidth();
        bottom = top + this.mRefreshView.getMeasuredHeight();
        this.mRefreshView.layout(left, top, right, bottom);
        if (this.mIsDebugLayout) {
            logString = logString + "RefreshView:" + top + "," + bottom + " -> " + (bottom - top) + "\r\n";
        }
        top = this.getTopLayoutFooterView();
        if (!this.mIsOverLayMode && bottom <= this.getTopAlignBottom() && bottom > top) {
            top = bottom;
        }
        right = left + ((View)this.mFooterView).getMeasuredWidth();
        bottom = top + ((View)this.mFooterView).getMeasuredHeight();
        ((View)this.mFooterView).layout(left, top, right, bottom);
        if (this.mIsDebugLayout) {
            logString = logString + "FooterView:" + top + "," + bottom + " -> " + (bottom - top);
            Log.i((String)this.getDebugTag(), (String)logString);
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.removeCallbacks(this.mStopRefreshingRunnable);
    }
}

