/*
 * Decompiled with CFR 0.152.
 */
package com.zzh.lib.views.shine;

import android.animation.Animator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.os.Build;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.LinearInterpolator;
import com.zzh.lib.click.OnButtonClickListener;
import com.zzh.lib.views.R;
import com.zzh.lib.views.shine.PorterShapeImageView;
import com.zzh.lib.views.shine.ShineView;
import com.zzh.lib.views.shine.listener.SimpleAnimatorListener;

public class ShineImageView
extends PorterShapeImageView {
    private static final String TAG = "ShineImageView";
    private boolean isChecked = false;
    private int btnColor;
    private int btnFillColor;
    int DEFAULT_WIDTH = 50;
    int DEFAULT_HEIGHT = 50;
    DisplayMetrics metrics = new DisplayMetrics();
    Activity activity;
    ShineView shineView;
    ValueAnimator shakeAnimator;
    ShineView.ShineParams shineParams = new ShineView.ShineParams();
    OnCheckedChangeListener listener;
    private int bottomHeight;
    private int realBottomHeight;
    Dialog mFixDialog;
    OnButtonClickListener onButtonClickListener;

    public ShineImageView(Context context) {
        super(context);
        if (context instanceof Activity) {
            this.init((Activity)context);
        }
    }

    public ShineImageView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initButton(context, attrs);
    }

    public ShineImageView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initButton(context, attrs);
    }

    private void initButton(Context context, AttributeSet attrs) {
        if (context instanceof Activity) {
            this.init((Activity)context);
        }
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.ShineButton);
        this.btnColor = a.getColor(R.styleable.ShineButton_btn_color, -7829368);
        this.btnFillColor = a.getColor(R.styleable.ShineButton_btn_fill_color, -16777216);
        this.shineParams.allowRandomColor = a.getBoolean(R.styleable.ShineButton_allow_random_color, false);
        this.shineParams.animDuration = a.getInteger(R.styleable.ShineButton_shine_animation_duration, (int)this.shineParams.animDuration);
        this.shineParams.bigShineColor = a.getColor(R.styleable.ShineButton_big_shine_color, this.shineParams.bigShineColor);
        this.shineParams.clickAnimDuration = a.getInteger(R.styleable.ShineButton_click_animation_duration, (int)this.shineParams.clickAnimDuration);
        this.shineParams.enableFlashing = a.getBoolean(R.styleable.ShineButton_enable_flashing, false);
        this.shineParams.shineCount = a.getInteger(R.styleable.ShineButton_shine_count, this.shineParams.shineCount);
        this.shineParams.shineDistanceMultiple = a.getFloat(R.styleable.ShineButton_shine_distance_multiple, this.shineParams.shineDistanceMultiple);
        this.shineParams.shineTurnAngle = a.getFloat(R.styleable.ShineButton_shine_turn_angle, this.shineParams.shineTurnAngle);
        this.shineParams.smallShineColor = a.getColor(R.styleable.ShineButton_small_shine_color, this.shineParams.smallShineColor);
        this.shineParams.smallShineOffsetAngle = a.getFloat(R.styleable.ShineButton_small_shine_offset_angle, this.shineParams.smallShineOffsetAngle);
        this.shineParams.shineSize = a.getDimensionPixelSize(R.styleable.ShineButton_shine_size, this.shineParams.shineSize);
        a.recycle();
        this.setSrcColor(this.btnColor);
    }

    public void setFixDialog(Dialog fixDialog) {
        this.mFixDialog = fixDialog;
    }

    public int getBottomHeight(boolean real) {
        if (real) {
            return this.realBottomHeight;
        }
        return this.bottomHeight;
    }

    public int getColor() {
        return this.btnFillColor;
    }

    public boolean isChecked() {
        return this.isChecked;
    }

    public void setBtnColor(int btnColor) {
        this.btnColor = btnColor;
        this.setSrcColor(this.btnColor);
    }

    public void setBtnFillColor(int btnFillColor) {
        this.btnFillColor = btnFillColor;
    }

    public void setChecked(boolean checked, boolean anim2) {
        this.setChecked(checked, anim2, true);
    }

    private void setChecked(boolean checked, boolean anim2, boolean callBack) {
        this.isChecked = checked;
        if (checked) {
            this.setSrcColor(this.btnFillColor);
            this.isChecked = true;
            if (anim2) {
                this.showAnim();
            }
        } else {
            this.setSrcColor(this.btnColor);
            this.isChecked = false;
            if (anim2) {
                this.setCancel();
            }
        }
        if (callBack) {
            this.onListenerUpdate(checked);
        }
    }

    public void setChecked(boolean checked) {
        this.setChecked(checked, false, false);
    }

    public void onListenerUpdate(boolean checked) {
        if (this.listener != null) {
            this.listener.onCheckedChanged((View)this, checked);
        }
    }

    public void setCancel() {
        this.setSrcColor(this.btnColor);
        if (this.shakeAnimator != null) {
            this.shakeAnimator.end();
            this.shakeAnimator.cancel();
        }
    }

    public void setAllowRandomColor(boolean allowRandomColor) {
        this.shineParams.allowRandomColor = allowRandomColor;
    }

    public void setAnimDuration(int durationMs) {
        this.shineParams.animDuration = durationMs;
    }

    public void setBigShineColor(int color2) {
        this.shineParams.bigShineColor = color2;
    }

    public void setClickAnimDuration(int durationMs) {
        this.shineParams.clickAnimDuration = durationMs;
    }

    public void enableFlashing(boolean enable) {
        this.shineParams.enableFlashing = enable;
    }

    public void setShineCount(int count) {
        this.shineParams.shineCount = count;
    }

    public void setShineDistanceMultiple(float multiple) {
        this.shineParams.shineDistanceMultiple = multiple;
    }

    public void setShineTurnAngle(float angle) {
        this.shineParams.shineTurnAngle = angle;
    }

    public void setSmallShineColor(int color2) {
        this.shineParams.smallShineColor = color2;
    }

    public void setSmallShineOffAngle(float angle) {
        this.shineParams.smallShineOffsetAngle = angle;
    }

    public void setShineSize(int size) {
        this.shineParams.shineSize = size;
    }

    public void setOnClickListener(View.OnClickListener l) {
        if (l instanceof OnButtonClickListener) {
            super.setOnClickListener(l);
        } else if (this.onButtonClickListener != null) {
            this.onButtonClickListener.setListener(l);
        }
    }

    public void setOnCheckStateChangeListener(OnCheckedChangeListener listener) {
        this.listener = listener;
    }

    public void init(Activity activity) {
        this.activity = activity;
        this.onButtonClickListener = new OnButtonClickListener(this);
        this.setOnClickListener(this.onButtonClickListener);
    }

    @Override
    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        this.calPixels();
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
    }

    public void showAnim() {
        if (this.activity != null) {
            this.shineView = new ShineView((Context)this.activity, this, this.shineParams);
            if (this.mFixDialog != null && this.mFixDialog.getWindow() != null) {
                ViewGroup rootView = (ViewGroup)this.mFixDialog.getWindow().getDecorView();
                View innerView = rootView.findViewById(0x1020002);
                rootView.addView((View)this.shineView, new ViewGroup.LayoutParams(innerView.getWidth(), innerView.getHeight()));
            } else {
                ViewGroup rootView = (ViewGroup)this.activity.getWindow().getDecorView();
                rootView.addView((View)this.shineView, new ViewGroup.LayoutParams(rootView.getWidth(), rootView.getHeight()));
            }
            this.doShareAnim();
        } else {
            Log.e((String)TAG, (String)"Please init.");
        }
    }

    public void removeView(View view) {
        if (this.activity != null) {
            ViewGroup rootView = (ViewGroup)this.activity.findViewById(0x1020002);
            rootView.removeView(view);
        } else {
            Log.e((String)TAG, (String)"Please init.");
        }
    }

    public void setShapeResource(int raw) {
        if (Build.VERSION.SDK_INT >= 21) {
            this.setShape(this.getResources().getDrawable(raw, null));
        } else {
            this.setShape(this.getResources().getDrawable(raw));
        }
    }

    private void doShareAnim() {
        this.shakeAnimator = ValueAnimator.ofFloat((float[])new float[]{0.4f, 1.0f, 0.9f, 1.0f});
        this.shakeAnimator.setInterpolator((TimeInterpolator)new LinearInterpolator());
        this.shakeAnimator.setDuration(500L);
        this.shakeAnimator.setStartDelay(180L);
        this.invalidate();
        this.shakeAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                ShineImageView.this.setScaleX(((Float)valueAnimator.getAnimatedValue()).floatValue());
                ShineImageView.this.setScaleY(((Float)valueAnimator.getAnimatedValue()).floatValue());
            }
        });
        this.shakeAnimator.addListener((Animator.AnimatorListener)new SimpleAnimatorListener(){

            @Override
            public void onAnimationStart(Animator animator) {
                ShineImageView.this.setSrcColor(ShineImageView.this.btnFillColor);
            }

            @Override
            public void onAnimationEnd(Animator animator) {
                ShineImageView.this.setSrcColor(ShineImageView.this.isChecked ? ShineImageView.this.btnFillColor : ShineImageView.this.btnColor);
            }

            @Override
            public void onAnimationCancel(Animator animator) {
                ShineImageView.this.setSrcColor(ShineImageView.this.btnColor);
            }
        });
        this.shakeAnimator.start();
    }

    @Override
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
    }

    private void calPixels() {
        if (this.activity != null && this.metrics != null) {
            this.activity.getWindowManager().getDefaultDisplay().getMetrics(this.metrics);
            int[] location = new int[2];
            this.getLocationInWindow(location);
            Rect visibleFrame = new Rect();
            this.activity.getWindow().getDecorView().getWindowVisibleDisplayFrame(visibleFrame);
            this.realBottomHeight = visibleFrame.height() - location[1];
            this.bottomHeight = this.metrics.heightPixels - location[1];
        }
    }

    public static interface OnCheckedChangeListener {
        public void onCheckedChanged(View var1, boolean var2);
    }
}

