/*
 * Decompiled with CFR 0.152.
 */
package com.zzh.lib.views.state;

import android.view.View;
import android.view.ViewTreeObserver;
import java.lang.ref.WeakReference;

abstract class HViewListener<V extends View> {
    private WeakReference<V> mView;
    private final View.OnAttachStateChangeListener mOnAttachStateChangeListener = new View.OnAttachStateChangeListener(){

        public void onViewAttachedToWindow(View v) {
            HViewListener.this.registerViewTreeObserver(v, true);
        }

        public void onViewDetachedFromWindow(View v) {
            HViewListener.this.registerViewTreeObserver(v, false);
        }
    };
    private final ViewTreeObserver.OnPreDrawListener mOnPreDrawListener = new ViewTreeObserver.OnPreDrawListener(){

        public boolean onPreDraw() {
            HViewListener.this.onUpdate(HViewListener.this.getView());
            return true;
        }
    };

    HViewListener() {
    }

    public final V getView() {
        return (V)(this.mView == null ? null : (View)this.mView.get());
    }

    public final void setView(V view) {
        V old = this.getView();
        if (old != view) {
            this.stop();
            this.mView = view == null ? null : new WeakReference<V>(view);
            this.onViewChanged(old, view);
            this.start();
        }
    }

    public final void start() {
        V view = this.getView();
        if (view == null) {
            return;
        }
        this.registerAttachStateChangeListener((View)view, true);
        this.registerViewTreeObserver((View)view, true);
    }

    public final void stop() {
        V view = this.getView();
        if (view == null) {
            return;
        }
        this.registerAttachStateChangeListener((View)view, false);
        this.registerViewTreeObserver((View)view, false);
    }

    private void registerAttachStateChangeListener(View view, boolean register) {
        view.removeOnAttachStateChangeListener(this.mOnAttachStateChangeListener);
        if (register) {
            view.addOnAttachStateChangeListener(this.mOnAttachStateChangeListener);
        }
    }

    private void registerViewTreeObserver(View view, boolean register) {
        ViewTreeObserver observer = view.getViewTreeObserver();
        if (observer.isAlive()) {
            observer.removeOnPreDrawListener(this.mOnPreDrawListener);
            if (register) {
                observer.addOnPreDrawListener(this.mOnPreDrawListener);
            }
        }
    }

    protected void onViewChanged(V oldView, V newView) {
    }

    public void update() {
    }

    protected abstract void onUpdate(V var1);
}

