/*
 * Decompiled with CFR 0.152.
 */
package com.zzh.lib.views.transform;

import android.view.View;
import androidx.annotation.NonNull;
import androidx.viewpager.widget.ViewPager;

public class OverlayTransformer
implements ViewPager.PageTransformer {
    private int overlayCount;
    private float scaleOffset = 40.0f;
    private float transOffset = 40.0f;

    public OverlayTransformer(int overlayCount, float scaleOffset, float transOffset) {
        this.overlayCount = overlayCount;
        this.scaleOffset = scaleOffset;
        this.transOffset = transOffset;
    }

    public void transformPage(@NonNull View page, float position) {
        if (position <= 0.0f) {
            page.setTranslationX(0.0f);
            page.setAlpha(1.0f - 0.5f * Math.abs(position));
            page.setClickable(true);
        } else {
            this.otherTrans(page, Float.valueOf(position));
            page.setClickable(false);
        }
    }

    private void otherTrans(View page, Float position) {
        float scale = ((float)page.getWidth() - this.scaleOffset * position.floatValue()) / (float)page.getWidth();
        page.setScaleX(scale);
        page.setScaleY(scale);
        page.setAlpha(1.0f);
        if (position.floatValue() > (float)(this.overlayCount - 1) && position.floatValue() < (float)this.overlayCount) {
            double curPositionOffset = (double)this.transOffset * Math.floor(position.floatValue());
            double lastPositionOffset = (double)this.transOffset * Math.floor(position.floatValue() - 1.0f);
            float singleOffset = 1.0f - Math.abs(position.floatValue() % position.floatValue());
            double transX = (double)((float)(-page.getWidth()) * position.floatValue()) + (lastPositionOffset + (double)singleOffset * (curPositionOffset - lastPositionOffset));
            page.setTranslationX((float)transX);
        } else if (position.floatValue() <= (float)(this.overlayCount - 1)) {
            float transX = (float)(-page.getWidth()) * position.floatValue() + this.transOffset * position.floatValue();
            page.setTranslationX(transX);
        } else {
            page.setAlpha(0.0f);
        }
    }

    public int getOverlayCount() {
        return this.overlayCount;
    }
}

