/*
 * Decompiled with CFR 0.152.
 */
package com.zzh.lib.views.transform;

import android.view.View;
import androidx.viewpager2.widget.ViewPager2;

public class ScaleInTransformer
implements ViewPager2.PageTransformer {
    private static final float DEFAULT_CENTER = 0.5f;
    public static final float DEFAULT_MIN_SCALE = 0.85f;
    private final float mMinScale;

    public ScaleInTransformer(float minScale) {
        this.mMinScale = minScale;
    }

    public void transformPage(View view, float position) {
        int pageWidth = view.getWidth();
        int pageHeight = view.getHeight();
        view.setPivotY((float)pageHeight / 2.0f);
        view.setPivotX((float)pageWidth / 2.0f);
        if (position < -1.0f) {
            view.setScaleX(this.mMinScale);
            view.setScaleY(this.mMinScale);
            view.setPivotX((float)pageWidth);
        } else if (position <= 1.0f) {
            if (position < 0.0f) {
                float scaleFactor = (1.0f + position) * (1.0f - this.mMinScale) + this.mMinScale;
                view.setScaleX(scaleFactor);
                view.setScaleY(scaleFactor);
                view.setPivotX((float)pageWidth * (0.5f + 0.5f * -position));
            } else {
                float scaleFactor = (1.0f - position) * (1.0f - this.mMinScale) + this.mMinScale;
                view.setScaleX(scaleFactor);
                view.setScaleY(scaleFactor);
                view.setPivotX((float)pageWidth * ((1.0f - position) * 0.5f));
            }
        } else {
            view.setPivotX(0.0f);
            view.setScaleX(this.mMinScale);
            view.setScaleY(this.mMinScale);
        }
    }
}

