/*
 * Decompiled with CFR 0.152.
 */
package com.zzh.lib.views.utils;

import android.content.res.Resources;
import android.util.Log;
import com.zzh.lib.views.banner.IndicatorOptions;

public class BannerUtils {
    private static boolean debugMode = false;
    private static final String TAG = "BVP";

    public static void setDebugMode(boolean isDebug) {
        debugMode = isDebug;
    }

    public static boolean isDebugMode() {
        return debugMode;
    }

    public static int dp2px(float dpValue) {
        return (int)(0.5f + dpValue * Resources.getSystem().getDisplayMetrics().density);
    }

    public static float dp2pxFloat(float dpValue) {
        return 0.5f + dpValue * Resources.getSystem().getDisplayMetrics().density;
    }

    public static void log(String tag, String msg) {
        if (BannerUtils.isDebugMode()) {
            Log.e((String)tag, (String)msg);
        }
    }

    public static void log(String msg) {
        if (BannerUtils.isDebugMode()) {
            BannerUtils.log(TAG, msg);
        }
    }

    public static int getRealPosition(int position, int pageSize) {
        if (pageSize == 0) {
            return 0;
        }
        return (position + pageSize) % pageSize;
    }

    public static int getOriginalPosition(int pageSize) {
        return 500 - 500 % pageSize;
    }

    public static float getCoordinateX(IndicatorOptions indicatorOptions, float maxDiameter, int index) {
        float normalIndicatorWidth = indicatorOptions.getNormalSliderWidth();
        return maxDiameter / 2.0f + (normalIndicatorWidth + indicatorOptions.getSliderGap()) * (float)index;
    }

    public static float getCoordinateY(float maxDiameter) {
        return maxDiameter / 2.0f;
    }
}

