/*
 * Decompiled with CFR 0.152.
 */
package com.zzh.lib.views.vp;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Handler;
import android.os.Looper;
import android.util.AttributeSet;
import android.view.MotionEvent;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.OnLifecycleEvent;
import androidx.viewpager.widget.PagerAdapter;
import androidx.viewpager.widget.ViewPager;
import com.zzh.lib.views.R;
import com.zzh.lib.views.adapter.HBaseViewPagerAdapter;

public class HOverlapCardViewPager<T>
extends ViewPager
implements LifecycleObserver {
    private boolean isLooping;
    private final Handler mHandler = new Handler(Looper.getMainLooper());
    private final Runnable mRunnable = this::handlePosition;
    private boolean isAutoPlay = false;
    private boolean stopLoopWhenDetachedFromWindow = true;
    private HBaseViewPagerAdapter<T> mBannerPagerAdapter;
    private long mInterval = 5000L;

    public boolean isAutoPlay() {
        return this.isAutoPlay;
    }

    public void setAutoPlay(boolean autoPlay) {
        this.isAutoPlay = autoPlay;
    }

    private void handlePosition() {
        if (this.mBannerPagerAdapter != null && this.mBannerPagerAdapter.getListSize() > 1 && this.isAutoPlay()) {
            this.setCurrentItem(this.getCurrentItem() + 1, true);
            this.mHandler.postDelayed(this.mRunnable, this.getInterval());
        }
    }

    public HOverlapCardViewPager(@NonNull Context context) {
        super(context);
    }

    public HOverlapCardViewPager(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.HBannerViewPager);
        if (typedArray.hasValue(R.styleable.HOverlapCardViewPager_bvp_interval)) {
            this.mInterval = typedArray.getInteger(R.styleable.HOverlapCardViewPager_bvp_interval, 5000);
        }
        if (typedArray.hasValue(R.styleable.HOverlapCardViewPager_bvp_auto_play)) {
            this.isAutoPlay = typedArray.getBoolean(R.styleable.HOverlapCardViewPager_bvp_auto_play, false);
        }
        typedArray.recycle();
    }

    public void setAdapter(@Nullable PagerAdapter adapter) {
        if (!(adapter instanceof HBaseViewPagerAdapter)) {
            throw new IllegalArgumentException("\u8bf7\u4f7f\u7528HBaseViewPagerAdapter\u9002\u914d\u5668");
        }
        this.mBannerPagerAdapter = (HBaseViewPagerAdapter)adapter;
        super.setAdapter(this.mBannerPagerAdapter);
    }

    @OnLifecycleEvent(value=Lifecycle.Event.ON_RESUME)
    public void onResume() {
        if (this.isAttachedToWindow() || !this.isStopLoopWhenDetachedFromWindow()) {
            this.startLoop();
        }
    }

    @OnLifecycleEvent(value=Lifecycle.Event.ON_PAUSE)
    public void onPause() {
        this.stopLoop();
    }

    @OnLifecycleEvent(value=Lifecycle.Event.ON_DESTROY)
    public void onDestroy() {
        this.stopLoop();
    }

    public boolean dispatchTouchEvent(MotionEvent ev) {
        switch (ev.getAction()) {
            case 0: {
                this.isLooping = true;
                this.stopLoop();
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                this.isLooping = false;
                this.startLoop();
                break;
            }
        }
        return super.dispatchTouchEvent(ev);
    }

    protected void onDetachedFromWindow() {
        if (this.isStopLoopWhenDetachedFromWindow()) {
            this.stopLoop();
        }
        super.onDetachedFromWindow();
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.isStopLoopWhenDetachedFromWindow()) {
            this.startLoop();
        }
    }

    private boolean isStopLoopWhenDetachedFromWindow() {
        return this.stopLoopWhenDetachedFromWindow;
    }

    public HOverlapCardViewPager<T> stopLoopWhenDetachedFromWindow(boolean stopLoopWhenDetachedFromWindow) {
        this.stopLoopWhenDetachedFromWindow = stopLoopWhenDetachedFromWindow;
        return this;
    }

    public void startLoop() {
        if (!this.isLooping && this.isAutoPlay() && this.mBannerPagerAdapter != null && this.mBannerPagerAdapter.getListSize() > 1) {
            this.mHandler.postDelayed(this.mRunnable, this.getInterval());
            this.isLooping = true;
        }
    }

    public void startLoopNow() {
        if (!this.isLooping && this.isAutoPlay() && this.mBannerPagerAdapter != null && this.mBannerPagerAdapter.getListSize() > 1) {
            this.mHandler.post(this.mRunnable);
            this.isLooping = true;
        }
    }

    public void stopLoop() {
        if (this.isLooping) {
            this.mHandler.removeCallbacks(this.mRunnable);
            this.isLooping = false;
        }
    }

    public long getInterval() {
        return this.mInterval;
    }

    public void setInterval(long interval) {
        this.mInterval = interval;
    }
}

