/*
 * Decompiled with CFR 0.152.
 */
package cn.beecp;

import cn.beecp.BeeDataSourceConfigException;
import cn.beecp.BeeDataSourceConfigJmxBean;
import cn.beecp.PasswordDecoder;
import cn.beecp.RawConnectionFactory;
import cn.beecp.RawXaConnectionFactory;
import cn.beecp.TransactionIsolation;
import cn.beecp.pool.ConnectionFactoryByDriver;
import cn.beecp.pool.ConnectionFactoryByDriverDs;
import cn.beecp.pool.FastConnectionPool;
import cn.beecp.pool.PoolStaticCenter;
import cn.beecp.pool.XaConnectionFactoryByDriverDs;
import java.io.File;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.sql.DataSource;
import javax.sql.XADataSource;

public class BeeDataSourceConfig
implements BeeDataSourceConfigJmxBean {
    private static final AtomicInteger PoolNameIndex = new AtomicInteger(1);
    private final Map<String, Object> connectProperties = new HashMap<String, Object>(2);
    private String username;
    private String password;
    private String jdbcUrl;
    private String driverClassName;
    private String poolName;
    private boolean fairMode;
    private int initialSize;
    private boolean asyncCreateInitConnection;
    private int maxActive = Math.min(Math.max(10, PoolStaticCenter.NCPUS), 50);
    private int borrowSemaphoreSize = Math.min(this.maxActive / 2, PoolStaticCenter.NCPUS);
    private long maxWait = TimeUnit.SECONDS.toMillis(8L);
    private long idleTimeout = TimeUnit.MINUTES.toMillis(3L);
    private long holdTimeout = TimeUnit.MINUTES.toMillis(3L);
    private String validTestSql = "SELECT 1";
    private int validTestTimeout = 3;
    private long validAssumeTime = 500L;
    private long timerCheckInterval = TimeUnit.MINUTES.toMillis(3L);
    private boolean forceCloseUsingOnClear;
    private long delayTimeForNextClear = 3000L;
    private String defaultCatalog;
    private String defaultSchema;
    private Boolean defaultReadOnly;
    private Boolean defaultAutoCommit;
    private Integer defaultTransactionIsolationCode;
    private String defaultTransactionIsolationName;
    private boolean enableDefaultOnCatalog = true;
    private boolean enableDefaultOnSchema = true;
    private boolean enableDefaultOnReadOnly = true;
    private boolean enableDefaultOnAutoCommit = true;
    private boolean enableDefaultOnTransactionIsolation = true;
    private Class connectionFactoryClass;
    private String connectionFactoryClassName;
    private Object connectionFactory;
    private Class passwordDecoderClass;
    private String passwordDecoderClassName;
    private String poolImplementClassName = FastConnectionPool.class.getName();
    private boolean enableJmx;
    private boolean printConfigInfo;
    private boolean printRuntimeLog;

    public BeeDataSourceConfig() {
    }

    public BeeDataSourceConfig(File propertiesFile) {
        this.loadFromPropertiesFile(propertiesFile);
    }

    public BeeDataSourceConfig(String propertiesFileName) {
        this.loadFromPropertiesFile(propertiesFileName);
    }

    public BeeDataSourceConfig(Properties configProperties) {
        this.loadFromProperties(configProperties);
    }

    public BeeDataSourceConfig(String driver, String url, String user, String password) {
        this.jdbcUrl = PoolStaticCenter.trimString(url);
        this.username = PoolStaticCenter.trimString(user);
        this.password = PoolStaticCenter.trimString(password);
        this.driverClassName = PoolStaticCenter.trimString(driver);
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = PoolStaticCenter.trimString(username);
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = PoolStaticCenter.trimString(password);
    }

    public String getUrl() {
        return this.jdbcUrl;
    }

    public void setUrl(String jdbcUrl) {
        this.jdbcUrl = PoolStaticCenter.trimString(jdbcUrl);
    }

    public String getJdbcUrl() {
        return this.jdbcUrl;
    }

    public void setJdbcUrl(String jdbcUrl) {
        this.jdbcUrl = PoolStaticCenter.trimString(jdbcUrl);
    }

    public String getDriverClassName() {
        return this.driverClassName;
    }

    public void setDriverClassName(String driverClassName) {
        this.driverClassName = PoolStaticCenter.trimString(driverClassName);
    }

    public String getPoolName() {
        return this.poolName;
    }

    public void setPoolName(String poolName) {
        this.poolName = PoolStaticCenter.trimString(poolName);
    }

    public boolean isFairMode() {
        return this.fairMode;
    }

    public void setFairMode(boolean fairMode) {
        this.fairMode = fairMode;
    }

    public int getInitialSize() {
        return this.initialSize;
    }

    public void setInitialSize(int initialSize) {
        if (initialSize >= 0) {
            this.initialSize = initialSize;
        }
    }

    public boolean isAsyncCreateInitConnection() {
        return this.asyncCreateInitConnection;
    }

    public void setAsyncCreateInitConnection(boolean asyncCreateInitConnection) {
        this.asyncCreateInitConnection = asyncCreateInitConnection;
    }

    public int getMaxActive() {
        return this.maxActive;
    }

    public void setMaxActive(int maxActive) {
        if (maxActive > 0) {
            this.maxActive = maxActive;
            this.borrowSemaphoreSize = maxActive > 1 ? Math.min(maxActive / 2, PoolStaticCenter.NCPUS) : 1;
        }
    }

    public int getBorrowSemaphoreSize() {
        return this.borrowSemaphoreSize;
    }

    public void setBorrowSemaphoreSize(int borrowSemaphoreSize) {
        if (borrowSemaphoreSize > 0) {
            this.borrowSemaphoreSize = borrowSemaphoreSize;
        }
    }

    public long getMaxWait() {
        return this.maxWait;
    }

    public void setMaxWait(long maxWait) {
        if (maxWait > 0L) {
            this.maxWait = maxWait;
        }
    }

    public long getIdleTimeout() {
        return this.idleTimeout;
    }

    public void setIdleTimeout(long idleTimeout) {
        if (idleTimeout > 0L) {
            this.idleTimeout = idleTimeout;
        }
    }

    public long getHoldTimeout() {
        return this.holdTimeout;
    }

    public void setHoldTimeout(long holdTimeout) {
        if (holdTimeout > 0L) {
            this.holdTimeout = holdTimeout;
        }
    }

    public String getValidTestSql() {
        return this.validTestSql;
    }

    public void setValidTestSql(String validTestSql) {
        if (!PoolStaticCenter.isBlank(validTestSql)) {
            this.validTestSql = PoolStaticCenter.trimString(validTestSql);
        }
    }

    public int getValidTestTimeout() {
        return this.validTestTimeout;
    }

    public void setValidTestTimeout(int validTestTimeout) {
        if (validTestTimeout >= 0) {
            this.validTestTimeout = validTestTimeout;
        }
    }

    public long getValidAssumeTime() {
        return this.validAssumeTime;
    }

    public void setValidAssumeTime(long validAssumeTime) {
        if (validAssumeTime >= 0L) {
            this.validAssumeTime = validAssumeTime;
        }
    }

    public long getTimerCheckInterval() {
        return this.timerCheckInterval;
    }

    public void setTimerCheckInterval(long timerCheckInterval) {
        if (timerCheckInterval > 0L) {
            this.timerCheckInterval = timerCheckInterval;
        }
    }

    public boolean isForceCloseUsingOnClear() {
        return this.forceCloseUsingOnClear;
    }

    public void setForceCloseUsingOnClear(boolean forceCloseUsingOnClear) {
        this.forceCloseUsingOnClear = forceCloseUsingOnClear;
    }

    public long getDelayTimeForNextClear() {
        return this.delayTimeForNextClear;
    }

    public void setDelayTimeForNextClear(long delayTimeForNextClear) {
        if (delayTimeForNextClear >= 0L) {
            this.delayTimeForNextClear = delayTimeForNextClear;
        }
    }

    public String getPoolImplementClassName() {
        return this.poolImplementClassName;
    }

    public void setPoolImplementClassName(String poolImplementClassName) {
        if (!PoolStaticCenter.isBlank(poolImplementClassName)) {
            this.poolImplementClassName = PoolStaticCenter.trimString(poolImplementClassName);
        }
    }

    public boolean isEnableJmx() {
        return this.enableJmx;
    }

    public void setEnableJmx(boolean enableJmx) {
        this.enableJmx = enableJmx;
    }

    public boolean isPrintConfigInfo() {
        return this.printConfigInfo;
    }

    public void setPrintConfigInfo(boolean printConfigInfo) {
        this.printConfigInfo = printConfigInfo;
    }

    public boolean isPrintRuntimeLog() {
        return this.printRuntimeLog;
    }

    public void setPrintRuntimeLog(boolean printRuntimeLog) {
        this.printRuntimeLog = printRuntimeLog;
    }

    public String getDefaultCatalog() {
        return this.defaultCatalog;
    }

    public void setDefaultCatalog(String defaultCatalog) {
        this.defaultCatalog = PoolStaticCenter.trimString(defaultCatalog);
    }

    public String getDefaultSchema() {
        return this.defaultSchema;
    }

    public void setDefaultSchema(String defaultSchema) {
        this.defaultSchema = PoolStaticCenter.trimString(defaultSchema);
    }

    public Boolean isDefaultReadOnly() {
        return this.defaultReadOnly;
    }

    public void setDefaultReadOnly(Boolean defaultReadOnly) {
        this.defaultReadOnly = defaultReadOnly;
    }

    public Boolean isDefaultAutoCommit() {
        return this.defaultAutoCommit;
    }

    public void setDefaultAutoCommit(Boolean defaultAutoCommit) {
        this.defaultAutoCommit = defaultAutoCommit;
    }

    public Integer getDefaultTransactionIsolationCode() {
        return this.defaultTransactionIsolationCode;
    }

    public void setDefaultTransactionIsolationCode(Integer transactionIsolationCode) {
        this.defaultTransactionIsolationCode = transactionIsolationCode;
    }

    public String getDefaultTransactionIsolationName() {
        return this.defaultTransactionIsolationName;
    }

    public void setDefaultTransactionIsolationName(String transactionIsolationName) {
        String transactionIsolationNameTemp = PoolStaticCenter.trimString(transactionIsolationName);
        this.defaultTransactionIsolationCode = TransactionIsolation.getTransactionIsolationCode(transactionIsolationNameTemp);
        if (this.defaultTransactionIsolationCode == null) {
            throw new BeeDataSourceConfigException("Invalid transaction isolation name:" + transactionIsolationNameTemp + ", value is one of[" + "0,2,1,4,8" + "]");
        }
        this.defaultTransactionIsolationName = transactionIsolationNameTemp;
    }

    public boolean isEnableDefaultOnCatalog() {
        return this.enableDefaultOnCatalog;
    }

    public void setEnableDefaultOnCatalog(boolean enableDefaultOnCatalog) {
        this.enableDefaultOnCatalog = enableDefaultOnCatalog;
    }

    public boolean isEnableDefaultOnSchema() {
        return this.enableDefaultOnSchema;
    }

    public void setEnableDefaultOnSchema(boolean enableDefaultOnSchema) {
        this.enableDefaultOnSchema = enableDefaultOnSchema;
    }

    public boolean isEnableDefaultOnReadOnly() {
        return this.enableDefaultOnReadOnly;
    }

    public void setEnableDefaultOnReadOnly(boolean enableDefaultOnReadOnly) {
        this.enableDefaultOnReadOnly = enableDefaultOnReadOnly;
    }

    public boolean isEnableDefaultOnAutoCommit() {
        return this.enableDefaultOnAutoCommit;
    }

    public void setEnableDefaultOnAutoCommit(boolean enableDefaultOnAutoCommit) {
        this.enableDefaultOnAutoCommit = enableDefaultOnAutoCommit;
    }

    public boolean isEnableDefaultOnTransactionIsolation() {
        return this.enableDefaultOnTransactionIsolation;
    }

    public void setEnableDefaultOnTransactionIsolation(boolean enableDefaultOnTransactionIsolation) {
        this.enableDefaultOnTransactionIsolation = enableDefaultOnTransactionIsolation;
    }

    public Object getConnectionFactory() {
        return this.connectionFactory;
    }

    public void setRawConnectionFactory(RawConnectionFactory factory) {
        this.connectionFactory = factory;
    }

    public void setRawXaConnectionFactory(RawXaConnectionFactory factory) {
        this.connectionFactory = factory;
    }

    public Class getConnectionFactoryClass() {
        return this.connectionFactoryClass;
    }

    public void setConnectionFactoryClass(Class connectionFactoryClass) {
        this.connectionFactoryClass = connectionFactoryClass;
    }

    public String getConnectionFactoryClassName() {
        return this.connectionFactoryClassName;
    }

    public void setConnectionFactoryClassName(String connectionFactoryClassName) {
        this.connectionFactoryClassName = PoolStaticCenter.trimString(connectionFactoryClassName);
    }

    public Class getPasswordDecoderClass() {
        return this.passwordDecoderClass;
    }

    public void setPasswordDecoderClass(Class passwordDecoderClass) {
        this.passwordDecoderClass = passwordDecoderClass;
    }

    public String getPasswordDecoderClassName() {
        return this.passwordDecoderClassName;
    }

    public void setPasswordDecoderClassName(String passwordDecoderClassName) {
        this.passwordDecoderClassName = passwordDecoderClassName;
    }

    public void removeConnectProperty(String key) {
        if (!PoolStaticCenter.isBlank(key)) {
            this.connectProperties.remove(key);
        }
    }

    public void addConnectProperty(String key, Object value) {
        if (!PoolStaticCenter.isBlank(key) && value != null) {
            this.connectProperties.put(key, value);
        }
    }

    public void addConnectProperty(String connectPropertyText) {
        if (!PoolStaticCenter.isBlank(connectPropertyText)) {
            for (String attribute : connectPropertyText.split("&")) {
                String[] pair = attribute.split("=");
                if (pair.length == 2) {
                    this.addConnectProperty(pair[0].trim(), pair[1].trim());
                    continue;
                }
                pair = attribute.split(":");
                if (pair.length != 2) continue;
                this.addConnectProperty(pair[0].trim(), pair[1].trim());
            }
        }
    }

    public void loadFromPropertiesFile(String filename) {
        if (PoolStaticCenter.isBlank(filename)) {
            throw new IllegalArgumentException("Properties file can't be null");
        }
        this.loadFromPropertiesFile(new File(filename));
    }

    public void loadFromPropertiesFile(File file) {
        if (file == null) {
            throw new IllegalArgumentException("Properties file can't be null");
        }
        if (!file.exists()) {
            throw new IllegalArgumentException("File not found:" + file.getAbsolutePath());
        }
        if (!file.isFile()) {
            throw new IllegalArgumentException("Target object is not a valid file");
        }
        if (!file.getAbsolutePath().toLowerCase(Locale.US).endsWith(".properties")) {
            throw new IllegalArgumentException("Target file is not a properties file");
        }
        InputStream stream = null;
        try {
            stream = Files.newInputStream(Paths.get(file.toURI()), new OpenOption[0]);
            Properties configProperties = new Properties();
            configProperties.load(stream);
            this.loadFromProperties(configProperties);
        }
        catch (BeeDataSourceConfigException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new BeeDataSourceConfigException("Failed to load properties file", e);
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (Throwable e) {
                    PoolStaticCenter.CommonLog.warn("Failed to close properties file inputStream,cause:", e);
                }
            }
        }
    }

    public void loadFromProperties(Properties configProperties) {
        if (configProperties == null || configProperties.isEmpty()) {
            throw new BeeDataSourceConfigException("Properties can't be null or empty");
        }
        HashMap<String, Object> setValueMap = new HashMap<String, Object>(configProperties.size());
        for (String propertyName : configProperties.stringPropertyNames()) {
            setValueMap.put(propertyName, configProperties.getProperty(propertyName));
        }
        PoolStaticCenter.setPropertiesValue(this, setValueMap);
        this.addConnectProperty(PoolStaticCenter.getPropertyValue(configProperties, "connectProperties"));
        String connectPropertiesSize = PoolStaticCenter.getPropertyValue(configProperties, "connectProperties.size");
        if (!PoolStaticCenter.isBlank(connectPropertiesSize)) {
            int size = Integer.parseInt(connectPropertiesSize.trim());
            for (int i = 1; i <= size; ++i) {
                this.addConnectProperty(PoolStaticCenter.getPropertyValue(configProperties, "connectProperties." + i));
            }
        }
    }

    public BeeDataSourceConfig check() throws SQLException {
        if (this.maxActive <= 0) {
            throw new BeeDataSourceConfigException("maxActive must be greater than zero");
        }
        if (this.initialSize < 0) {
            throw new BeeDataSourceConfigException("initialSize must not be less than zero");
        }
        if (this.initialSize > this.maxActive) {
            throw new BeeDataSourceConfigException("initialSize must not be greater than maxActive");
        }
        if (this.borrowSemaphoreSize <= 0) {
            throw new BeeDataSourceConfigException("borrowSemaphoreSize must be greater than zero");
        }
        if (this.idleTimeout <= 0L) {
            throw new BeeDataSourceConfigException("idleTimeout must be greater than zero");
        }
        if (this.holdTimeout <= 0L) {
            throw new BeeDataSourceConfigException("holdTimeout must be greater than zero");
        }
        if (this.maxWait <= 0L) {
            throw new BeeDataSourceConfigException("maxWait must be greater than zero");
        }
        if (PoolStaticCenter.isBlank(this.validTestSql)) {
            throw new BeeDataSourceConfigException("validTestSql cant be null or empty");
        }
        if (!this.validTestSql.toUpperCase(Locale.US).startsWith("SELECT ")) {
            throw new BeeDataSourceConfigException("validTestSql must be start with 'select '");
        }
        Object tempConnectionFactory = null;
        if (this.connectionFactory == null) {
            tempConnectionFactory = this.createConnectionFactory();
        }
        BeeDataSourceConfig checkedConfig = new BeeDataSourceConfig();
        this.copyTo(checkedConfig);
        if (tempConnectionFactory != null) {
            checkedConfig.connectionFactory = tempConnectionFactory;
        }
        if (PoolStaticCenter.isBlank(checkedConfig.poolName)) {
            checkedConfig.poolName = "FastPool-" + PoolNameIndex.getAndIncrement();
        }
        return checkedConfig;
    }

    void copyTo(BeeDataSourceConfig config) {
        String fieldName = "";
        try {
            for (Field field : BeeDataSourceConfig.class.getDeclaredFields()) {
                fieldName = field.getName();
                if (Modifier.isFinal(field.getModifiers()) || Modifier.isStatic(field.getModifiers()) || "connectProperties".equals(fieldName)) continue;
                Object fieldValue = field.get(this);
                if (this.printConfigInfo) {
                    PoolStaticCenter.CommonLog.info("{}.{}={}", new Object[]{this.poolName, fieldName, fieldValue});
                }
                field.set(config, fieldValue);
            }
        }
        catch (Throwable e) {
            throw new BeeDataSourceConfigException("Failed to copy field[" + fieldName + "]", e);
        }
        for (Map.Entry entry : this.connectProperties.entrySet()) {
            if (this.printConfigInfo) {
                PoolStaticCenter.CommonLog.info("{}.connectProperties.{}={}", new Object[]{this.poolName, entry.getKey(), entry.getValue()});
            }
            config.addConnectProperty((String)entry.getKey(), entry.getValue());
        }
    }

    private PasswordDecoder createPasswordDecoder() {
        PasswordDecoder passwordDecoder = null;
        Class<?> passwordDecoderClass = this.passwordDecoderClass;
        if (passwordDecoderClass == null && !PoolStaticCenter.isBlank(this.passwordDecoderClassName)) {
            try {
                passwordDecoderClass = Class.forName(this.passwordDecoderClassName);
            }
            catch (Throwable e) {
                throw new BeeDataSourceConfigException("Failed to create password decoder by class:" + this.passwordDecoderClassName, e);
            }
        }
        if (passwordDecoderClass != null) {
            try {
                passwordDecoder = (PasswordDecoder)PoolStaticCenter.createClassInstance((Class)passwordDecoderClass, PasswordDecoder.class, "password decoder");
            }
            catch (Throwable e) {
                throw new BeeDataSourceConfigException("Failed to instantiate password decoder class:" + passwordDecoderClass.getName(), e);
            }
        }
        return passwordDecoder;
    }

    private Object createConnectionFactory() throws SQLException {
        if (this.connectionFactory != null) {
            return this.connectionFactory;
        }
        PasswordDecoder passwordDecoder = this.createPasswordDecoder();
        if (this.connectionFactoryClass == null && PoolStaticCenter.isBlank(this.connectionFactoryClassName)) {
            String tempPassword;
            if (PoolStaticCenter.isBlank(this.jdbcUrl)) {
                throw new BeeDataSourceConfigException("jdbcUrl can't be null");
            }
            Driver connectDriver = null;
            if (!PoolStaticCenter.isBlank(this.driverClassName)) {
                connectDriver = PoolStaticCenter.loadDriver(this.driverClassName);
            } else if (!PoolStaticCenter.isBlank(this.jdbcUrl)) {
                connectDriver = DriverManager.getDriver(this.jdbcUrl);
            }
            if (connectDriver == null) {
                throw new BeeDataSourceConfigException("Failed to load driver:" + this.driverClassName);
            }
            if (!connectDriver.acceptsURL(this.jdbcUrl)) {
                throw new BeeDataSourceConfigException("jdbcUrl(" + this.jdbcUrl + ")can not match driver:" + connectDriver.getClass().getName());
            }
            Properties configProperties = new Properties();
            configProperties.putAll(this.connectProperties);
            if (!PoolStaticCenter.isBlank(this.username) && !configProperties.containsKey("user")) {
                configProperties.setProperty("user", this.username);
            }
            if (PoolStaticCenter.isBlank(tempPassword = configProperties.getProperty("password"))) {
                tempPassword = this.password;
            }
            if (!PoolStaticCenter.isBlank(tempPassword)) {
                if (passwordDecoder != null) {
                    tempPassword = passwordDecoder.decode(tempPassword);
                }
                configProperties.setProperty("password", tempPassword);
            }
            return new ConnectionFactoryByDriver(this.jdbcUrl, connectDriver, configProperties);
        }
        try {
            Object passwordPropVal;
            String tempPassword;
            Class<?> conFactClass = this.connectionFactoryClass != null ? this.connectionFactoryClass : Class.forName(this.connectionFactoryClassName);
            Class[] parentClasses = new Class[]{RawConnectionFactory.class, RawXaConnectionFactory.class, DataSource.class, XADataSource.class};
            Object factory = PoolStaticCenter.createClassInstance(conFactClass, parentClasses, "connection factory");
            HashMap<String, Object> propertyValueMap = new HashMap<String, Object>(this.connectProperties);
            if (!PoolStaticCenter.isBlank(this.username) && !propertyValueMap.containsKey("user")) {
                propertyValueMap.put("user", this.username);
            }
            String string = tempPassword = (passwordPropVal = propertyValueMap.get("password")) instanceof String ? (String)passwordPropVal : null;
            if (PoolStaticCenter.isBlank(tempPassword)) {
                tempPassword = this.password;
            }
            if (!PoolStaticCenter.isBlank(tempPassword)) {
                if (passwordDecoder != null) {
                    tempPassword = passwordDecoder.decode(tempPassword);
                }
                propertyValueMap.put("password", tempPassword);
            }
            if (!PoolStaticCenter.isBlank(this.jdbcUrl)) {
                if (!propertyValueMap.containsKey("url")) {
                    propertyValueMap.put("url", this.jdbcUrl);
                }
                if (!propertyValueMap.containsKey("URL")) {
                    propertyValueMap.put("URL", this.jdbcUrl);
                }
                if (!propertyValueMap.containsKey("jdbcUrl")) {
                    propertyValueMap.put("jdbcUrl", this.jdbcUrl);
                }
            }
            PoolStaticCenter.setPropertiesValue(factory, propertyValueMap);
            if (factory instanceof RawConnectionFactory || factory instanceof RawXaConnectionFactory) {
                return factory;
            }
            if (factory instanceof XADataSource) {
                return new XaConnectionFactoryByDriverDs((XADataSource)factory, this.username, this.password);
            }
            if (factory instanceof DataSource) {
                return new ConnectionFactoryByDriverDs((DataSource)factory, this.username, this.password);
            }
            throw new BeeDataSourceConfigException("Error connection factory type:" + this.connectionFactoryClassName);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BeeDataSourceConfigException("Failed to create connection factory by class:" + this.connectionFactoryClassName, e);
        }
    }
}

