/*
 * Decompiled with CFR 0.152.
 */
package com.github.dreamhead.moco.parser.deserializer;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.github.dreamhead.moco.parser.model.FailoverContainer;
import com.github.dreamhead.moco.parser.model.ProxyContainer;
import com.github.dreamhead.moco.parser.model.TextContainer;
import com.github.dreamhead.moco.util.Strings;
import java.io.IOException;

public final class ProxyContainerDeserializer
extends JsonDeserializer<ProxyContainer> {
    public ProxyContainer deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        JsonToken currentToken = jp.getCurrentToken();
        if (currentToken == JsonToken.VALUE_STRING) {
            return ProxyContainer.builder().withUrl(Strings.strip((String)jp.getText())).build();
        }
        if (currentToken == JsonToken.START_OBJECT) {
            InternalProxyContainer container = (InternalProxyContainer)jp.readValueAs(InternalProxyContainer.class);
            return container.toProxyContainer();
        }
        return (ProxyContainer)ctxt.handleUnexpectedToken(ProxyContainer.class, jp);
    }

    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
    private static class InternalProxyContainer {
        private TextContainer url;
        private String from;
        private String to;
        private FailoverContainer failover;
        private FailoverContainer playback;

        private InternalProxyContainer() {
        }

        public ProxyContainer toProxyContainer() {
            return ProxyContainer.builder().withUrl(this.url).withFrom(this.from).withTo(this.to).withFailover(this.failover).withPlayback(this.playback).build();
        }
    }
}

