/*
 * Decompiled with CFR 0.152.
 */
package com.github.dreamhead.moco.parser.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.github.dreamhead.moco.MocoRest;
import com.github.dreamhead.moco.RestIdMatcher;
import com.github.dreamhead.moco.RestSetting;
import com.github.dreamhead.moco.parser.model.ResourceSetting;
import com.github.dreamhead.moco.parser.model.RestIds;
import com.github.dreamhead.moco.util.Iterables;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
public class RestSubResourceSetting
extends ResourceSetting {
    private String id;

    @Override
    protected MoreObjects.ToStringHelper toStringHelper() {
        return super.toStringHelper().add("id", (Object)this.id);
    }

    private static Function<RestSubResourceSetting, RestSetting> toSubResourceSetting() {
        return input -> {
            Object[] settings = input.getSettings();
            return MocoRest.id((RestIdMatcher)RestIds.asIdMatcher(input.id)).name(input.getName()).settings((RestSetting)Iterables.head((Object[])settings), (RestSetting[])Iterables.tail((Object[])settings));
        };
    }

    public static Iterable<RestSetting> asSubRestSetting(List<RestSubResourceSetting> setting) {
        if (setting == null || setting.isEmpty()) {
            return ImmutableList.of();
        }
        return setting.stream().map(RestSubResourceSetting.toSubResourceSetting()).collect(Collectors.toList());
    }
}

