/*
 * Decompiled with CFR 0.152.
 */
package com.github.dreamhead.moco.parser.model.websocket;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.github.dreamhead.moco.WebSocketServer;
import com.github.dreamhead.moco.parser.model.TextContainer;
import com.github.dreamhead.moco.parser.model.websocket.PingpongSession;
import com.github.dreamhead.moco.parser.model.websocket.WebsocketSession;
import com.github.dreamhead.moco.resource.Resource;
import com.github.dreamhead.moco.util.Iterables;
import java.util.List;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
public class WebsocketSetting {
    private String uri;
    private TextContainer connected;
    private List<PingpongSession> pingpongs;
    private List<WebsocketSession> sessions;

    public final String getUri() {
        return this.uri;
    }

    private boolean hasSessions() {
        return !Iterables.isNullOrEmpty(this.sessions);
    }

    private void bindSessions(WebSocketServer webSocketServer) {
        for (WebsocketSession session : this.sessions) {
            session.bindSession(webSocketServer);
        }
    }

    public final void bind(WebSocketServer webSocketServer) {
        if (this.connected != null) {
            webSocketServer.connected((Resource)this.connected.asResource());
        }
        if (this.hasPingPongs()) {
            for (PingpongSession pingpong : this.pingpongs) {
                pingpong.bindPingPong(webSocketServer);
            }
        }
        if (this.hasSessions()) {
            this.bindSessions(webSocketServer);
        }
    }

    private boolean hasPingPongs() {
        return !Iterables.isNullOrEmpty(this.pingpongs);
    }
}

