/*
 * Decompiled with CFR 0.152.
 */
package com.github.trang.druid.datasource;

import com.alibaba.druid.filter.config.ConfigFilter;
import com.alibaba.druid.filter.logging.CommonsLogFilter;
import com.alibaba.druid.filter.logging.Log4j2Filter;
import com.alibaba.druid.filter.logging.Log4jFilter;
import com.alibaba.druid.filter.logging.Slf4jLogFilter;
import com.alibaba.druid.filter.stat.StatFilter;
import com.alibaba.druid.pool.DruidDataSource;
import com.alibaba.druid.wall.WallFilter;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.jdbc.DataSourceProperties;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.util.StringUtils;

@ConfigurationProperties(value="spring.datasource.druid")
public abstract class DruidParentDataSource
extends DruidDataSource {
    @Autowired(required=false)
    private StatFilter statFilter;
    @Autowired(required=false)
    private WallFilter wallFilter;
    @Autowired(required=false)
    private ConfigFilter configFilter;
    @Autowired(required=false)
    private Slf4jLogFilter slf4jLogFilter;
    @Autowired(required=false)
    private Log4jFilter log4jFilter;
    @Autowired(required=false)
    private Log4j2Filter log4j2Filter;
    @Autowired(required=false)
    private CommonsLogFilter commonsLogFilter;
    @Autowired
    private DataSourceProperties dataSourceProperties;

    @PostConstruct
    public void initCommonParams() {
        if (!StringUtils.isEmpty((Object)this.dataSourceProperties.getDriverClassName())) {
            super.setDriverClassName(this.dataSourceProperties.getDriverClassName());
        }
        if (!StringUtils.isEmpty((Object)this.dataSourceProperties.getUrl())) {
            super.setUrl(this.dataSourceProperties.getUrl());
        }
        if (!StringUtils.isEmpty((Object)this.dataSourceProperties.getUsername())) {
            super.setUsername(this.dataSourceProperties.getUsername());
        }
        if (!StringUtils.isEmpty((Object)this.dataSourceProperties.getPassword())) {
            super.setPassword(this.dataSourceProperties.getPassword());
        }
        List filters = super.getProxyFilters();
        Stream.of(this.statFilter, this.wallFilter, this.configFilter, this.slf4jLogFilter, this.log4jFilter, this.log4j2Filter, this.commonsLogFilter).filter(Objects::nonNull).filter(filter -> !filters.contains(filter)).forEach(filters::add);
    }
}

