/*
 * Decompiled with CFR 0.152.
 */
package com.ijpay.paypal.accesstoken;

import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.ijpay.core.utils.RetryUtils;
import java.io.Serializable;
import java.util.Map;

public class AccessToken
implements Serializable,
RetryUtils.ResultCheck {
    private static final long serialVersionUID = 150495825818051646L;
    private String access_token;
    private String token_type;
    private String app_id;
    private Integer expires_in;
    private Long expiredTime;
    private String json;
    private Integer status;

    public AccessToken(String json, int httpCode) {
        this.json = json;
        this.status = httpCode;
        try {
            JSONObject jsonObject = JSONUtil.parseObj((String)json);
            this.access_token = jsonObject.getStr((Object)"access_token");
            this.expires_in = jsonObject.getInt((Object)"expires_in");
            this.app_id = jsonObject.getStr((Object)"app_id");
            this.token_type = jsonObject.getStr((Object)"token_type");
            if (this.expires_in != null) {
                this.expiredTime = System.currentTimeMillis() + (long)((this.expires_in - 9) * 1000);
            }
            if (jsonObject.containsKey((Object)"expiredTime")) {
                this.expiredTime = jsonObject.getLong((Object)"expiredTime");
            }
            if (jsonObject.containsKey((Object)"status")) {
                this.status = jsonObject.getInt((Object)"status");
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isAvailable() {
        if (this.status != 200) {
            return false;
        }
        if (this.expiredTime == null) {
            return false;
        }
        if (this.expiredTime < System.currentTimeMillis()) {
            return false;
        }
        return StrUtil.isNotEmpty((CharSequence)this.access_token);
    }

    public String getCacheJson() {
        Map temp = (Map)JSONUtil.toBean((String)this.json, Map.class);
        temp.put("expiredTime", this.expiredTime);
        temp.remove("expires_in");
        temp.remove("scope");
        temp.remove("nonce");
        return JSONUtil.toJsonStr((Object)temp);
    }

    public String getAccessToken() {
        return this.access_token;
    }

    public void setAccessToken(String accessToken) {
        this.access_token = accessToken;
    }

    public String getTokenType() {
        return this.token_type;
    }

    public void setTokenType(String tokenType) {
        this.token_type = tokenType;
    }

    public String getAppId() {
        return this.app_id;
    }

    public void setAppId(String appId) {
        this.app_id = appId;
    }

    public Integer getExpiresIn() {
        return this.expires_in;
    }

    public void setExpiresIn(Integer expiresIn) {
        this.expires_in = expiresIn;
    }

    public Long getExpiredTime() {
        return this.expiredTime;
    }

    public void setExpiredTime(Long expiredTime) {
        this.expiredTime = expiredTime;
    }

    public boolean matching() {
        return this.isAvailable();
    }

    public String getJson() {
        return this.json;
    }

    public void setJson(String json) {
        this.json = json;
    }

    public Integer getStatus() {
        return this.status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }
}

