/*
 * Decompiled with CFR 0.152.
 */
package com.github.miemiedev.mybatis.paginator.dialect;

import com.github.miemiedev.mybatis.paginator.domain.Order;
import com.github.miemiedev.mybatis.paginator.domain.PageBounds;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.property.PropertyTokenizer;
import org.apache.ibatis.reflection.wrapper.BeanWrapper;
import org.apache.ibatis.type.TypeHandlerRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Dialect {
    protected TypeHandlerRegistry typeHandlerRegistry;
    protected MappedStatement mappedStatement;
    protected PageBounds pageBounds;
    protected Object parameterObject;
    protected BoundSql boundSql;
    protected List<ParameterMapping> parameterMappings;
    protected Map<String, Object> pageParameters = new HashMap<String, Object>();
    private String pageSQL;
    private String countSQL;

    public Dialect(MappedStatement mappedStatement, Object parameterObject, PageBounds pageBounds) {
        this.mappedStatement = mappedStatement;
        this.parameterObject = parameterObject;
        this.pageBounds = pageBounds;
        this.typeHandlerRegistry = mappedStatement.getConfiguration().getTypeHandlerRegistry();
        this.init();
    }

    protected void init() {
        String sql;
        this.boundSql = this.mappedStatement.getBoundSql(this.parameterObject);
        this.parameterMappings = new ArrayList<ParameterMapping>(this.boundSql.getParameterMappings());
        if (this.parameterObject instanceof Map) {
            this.pageParameters.putAll((Map)this.parameterObject);
        } else {
            MetaObject metaObject = this.mappedStatement.getConfiguration().newMetaObject(this.parameterObject);
            BeanWrapper wrapper = new BeanWrapper(metaObject, this.parameterObject);
            for (ParameterMapping parameterMapping : this.parameterMappings) {
                PropertyTokenizer prop = new PropertyTokenizer(parameterMapping.getProperty());
                this.pageParameters.put(parameterMapping.getProperty(), wrapper.get(prop));
            }
        }
        StringBuffer bufferSql = new StringBuffer(this.boundSql.getSql().trim());
        if (bufferSql.lastIndexOf(";") == bufferSql.length() - 1) {
            bufferSql.deleteCharAt(bufferSql.length() - 1);
        }
        this.pageSQL = sql = bufferSql.toString();
        if (this.pageBounds.getOrders() != null && !this.pageBounds.getOrders().isEmpty()) {
            this.pageSQL = this.getSortString(sql, this.pageBounds.getOrders());
        }
        if (this.pageBounds.getOffset() != 0 || this.pageBounds.getLimit() != Integer.MAX_VALUE) {
            this.pageSQL = this.getLimitString(this.pageSQL, "__offset", this.pageBounds.getOffset(), "__limit", this.pageBounds.getLimit());
        }
        this.countSQL = this.getCountString(sql);
    }

    public List<ParameterMapping> getParameterMappings() {
        return this.parameterMappings;
    }

    public Object getParameterObject() {
        return this.pageParameters;
    }

    public String getPageSQL() {
        return this.pageSQL;
    }

    protected void setPageParameter(String name, Object value, Class type) {
        ParameterMapping parameterMapping = new ParameterMapping.Builder(this.mappedStatement.getConfiguration(), name, type).build();
        this.parameterMappings.add(parameterMapping);
        this.pageParameters.put(name, value);
    }

    public String getCountSQL() {
        return this.countSQL;
    }

    protected String getLimitString(String sql, String offsetName, int offset, String limitName, int limit) {
        throw new UnsupportedOperationException("paged queries not supported");
    }

    protected String getCountString(String sql) {
        return "select count(1) from (" + sql + ") tmp_count";
    }

    protected String getSortString(String sql, List<Order> orders) {
        if (orders == null || orders.isEmpty()) {
            return sql;
        }
        StringBuffer buffer = new StringBuffer("select * from (").append(sql).append(") temp_order order by ");
        for (Order order : orders) {
            if (order == null) continue;
            buffer.append(order.toString()).append(", ");
        }
        buffer.delete(buffer.length() - 2, buffer.length());
        return buffer.toString();
    }
}

