/*
 * Decompiled with CFR 0.152.
 */
package com.github.mthizo247.cloud.netflix.zuul.web.authentication;

import com.github.mthizo247.cloud.netflix.zuul.web.authentication.AbstractHeadersCallback;
import java.util.Collections;
import org.springframework.security.core.Authentication;
import org.springframework.security.crypto.codec.Base64;
import org.springframework.web.socket.WebSocketHttpHeaders;
import org.springframework.web.socket.WebSocketSession;

public class BasicAuthPrincipalHeadersCallback
extends AbstractHeadersCallback {
    @Override
    protected void applyHeadersInternal(WebSocketSession userAgentSession, WebSocketHttpHeaders headers) {
        Authentication authentication = (Authentication)userAgentSession.getPrincipal();
        String usernameColonPwd = authentication.getName() + ":" + authentication.getCredentials().toString();
        String encodedCredentials = new String(Base64.encode((byte[])usernameColonPwd.getBytes()));
        headers.put("Authorization", Collections.singletonList("Basic " + encodedCredentials));
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Added basic authentication header for user " + authentication.getName() + " to web sockets http headers"));
        }
    }

    @Override
    protected boolean shouldApplyHeaders(WebSocketSession userAgentSession, WebSocketHttpHeaders headers) {
        return !headers.containsKey((Object)"Authorization") && userAgentSession.getPrincipal() instanceof Authentication;
    }
}

