/*
 * Decompiled with CFR 0.152.
 */
package com.github.mthizo247.cloud.netflix.zuul.web.socket;

import com.github.mthizo247.cloud.netflix.zuul.web.socket.ProxyWebSocketErrorHandler;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CompositeErrorHandler
implements ProxyWebSocketErrorHandler {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final List<ProxyWebSocketErrorHandler> errorHandlers;

    public CompositeErrorHandler(List<ProxyWebSocketErrorHandler> handlers) {
        this.errorHandlers = handlers;
    }

    public void handleError(Throwable t) {
        for (ProxyWebSocketErrorHandler handler : this.errorHandlers) {
            this.callErrorHandler(handler, t);
        }
    }

    private void callErrorHandler(ProxyWebSocketErrorHandler handler, Throwable t) {
        try {
            handler.handleError(t);
        }
        catch (Throwable e) {
            this.logger.error((Object)("Error executing error handler " + handler), e);
        }
    }
}

