/*
 * Decompiled with CFR 0.152.
 */
package com.github.mthizo247.cloud.netflix.zuul.web.socket;

import com.github.mthizo247.cloud.netflix.zuul.web.socket.ProxySessionException;
import com.github.mthizo247.cloud.netflix.zuul.web.socket.ProxyWebSocketConnectionManager;
import com.github.mthizo247.cloud.netflix.zuul.web.socket.ProxyWebSocketErrorHandler;
import com.github.mthizo247.cloud.netflix.zuul.web.util.ErrorAnalyzer;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.messaging.simp.stomp.ConnectionLostException;

public class ReconnectErrorHandler
implements ProxyWebSocketErrorHandler {
    private static final long CONNECTION_LOST_RECONNECT_INTERVAL = 10000L;
    private final Log logger = LogFactory.getLog(ReconnectErrorHandler.class);
    private ErrorAnalyzer errorAnalyzer;

    public ReconnectErrorHandler(ErrorAnalyzer errorAnalyzer) {
        this.errorAnalyzer = errorAnalyzer;
    }

    public void handleError(Throwable t) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error((Object)"Proxy web socket error occurred.", t);
        }
        if (!(t instanceof ProxySessionException)) {
            return;
        }
        ProxySessionException exception = (ProxySessionException)t;
        if (this.shouldAttemptToReconnect(exception)) {
            this.executeReconnectThread(exception.getConnectionManager());
        }
    }

    private boolean shouldAttemptToReconnect(ProxySessionException proxyException) {
        if (!this.isConnectionLost(proxyException)) {
            return false;
        }
        return proxyException.getConnectionManager().isConnectedToUserAgent();
    }

    private boolean isConnectionLost(ProxySessionException proxyException) {
        Throwable cause = proxyException.getCause();
        Throwable[] causeChain = this.errorAnalyzer.determineCauseChain(cause);
        Throwable throwable = this.errorAnalyzer.getFirstThrowableOfType(ConnectionLostException.class, causeChain);
        if (throwable != null) {
            return true;
        }
        throwable = this.errorAnalyzer.getFirstThrowableOfType(IOException.class, causeChain);
        return throwable != null && throwable.getMessage().toLowerCase().contains(" refused ");
    }

    private void executeReconnectThread(final ProxyWebSocketConnectionManager clientConnectionManager) {
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                clientConnectionManager.reconnect(10000L);
            }
        });
        t.setDaemon(true);
        t.start();
    }
}

