/*
 * Decompiled with CFR 0.152.
 */
package com.github.mthizo247.cloud.netflix.zuul.web.socket;

import com.github.mthizo247.cloud.netflix.zuul.web.authentication.BasicAuthPrincipalHeadersCallback;
import com.github.mthizo247.cloud.netflix.zuul.web.authentication.CompositeHeadersCallback;
import com.github.mthizo247.cloud.netflix.zuul.web.authentication.LoginCookieHeadersCallback;
import com.github.mthizo247.cloud.netflix.zuul.web.authentication.OAuth2BearerPrincipalHeadersCallback;
import com.github.mthizo247.cloud.netflix.zuul.web.filter.ProxyRedirectFilter;
import com.github.mthizo247.cloud.netflix.zuul.web.socket.CompositeErrorHandler;
import com.github.mthizo247.cloud.netflix.zuul.web.socket.ProxyWebSocketErrorHandler;
import com.github.mthizo247.cloud.netflix.zuul.web.socket.ProxyWebSocketHandler;
import com.github.mthizo247.cloud.netflix.zuul.web.socket.ReconnectErrorHandler;
import com.github.mthizo247.cloud.netflix.zuul.web.socket.WebSocketHttpHeadersCallback;
import com.github.mthizo247.cloud.netflix.zuul.web.socket.ZuulWebSocketProperties;
import com.github.mthizo247.cloud.netflix.zuul.web.target.CompositeProxyTargetResolver;
import com.github.mthizo247.cloud.netflix.zuul.web.target.EurekaProxyTargetResolver;
import com.github.mthizo247.cloud.netflix.zuul.web.target.LoadBalancedProxyTargetResolver;
import com.github.mthizo247.cloud.netflix.zuul.web.target.ProxyTargetResolver;
import com.github.mthizo247.cloud.netflix.zuul.web.target.UrlProxyTargetResolver;
import com.github.mthizo247.cloud.netflix.zuul.web.util.DefaultErrorAnalyzer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.cloud.client.loadbalancer.LoadBalancerClient;
import org.springframework.cloud.netflix.zuul.filters.RouteLocator;
import org.springframework.cloud.netflix.zuul.filters.ZuulProperties;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.messaging.converter.MessageConverter;
import org.springframework.messaging.simp.SimpMessagingTemplate;
import org.springframework.messaging.simp.config.MessageBrokerRegistry;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.client.WebSocketClient;
import org.springframework.web.socket.client.standard.StandardWebSocketClient;
import org.springframework.web.socket.config.annotation.AbstractWebSocketMessageBrokerConfigurer;
import org.springframework.web.socket.config.annotation.SockJsServiceRegistration;
import org.springframework.web.socket.config.annotation.StompEndpointRegistry;
import org.springframework.web.socket.config.annotation.WebSocketTransportRegistration;
import org.springframework.web.socket.handler.WebSocketHandlerDecoratorFactory;
import org.springframework.web.socket.messaging.WebSocketStompClient;
import org.springframework.web.socket.sockjs.client.SockJsClient;
import org.springframework.web.socket.sockjs.client.WebSocketTransport;

@Configuration
@ConditionalOnWebApplication
@ConditionalOnClass(value={WebSocketHandler.class})
@ConditionalOnProperty(prefix="zuul.ws", name={"enabled"}, havingValue="true", matchIfMissing=true)
@EnableConfigurationProperties(value={ZuulWebSocketProperties.class})
public class ZuulWebSocketConfiguration
extends AbstractWebSocketMessageBrokerConfigurer
implements ApplicationListener<ContextRefreshedEvent> {
    @Autowired
    ZuulWebSocketProperties zuulWebSocketProperties;
    @Autowired
    SimpMessagingTemplate messagingTemplate;
    @Autowired
    ZuulProperties zuulProperties;
    @Autowired
    @Qualifier(value="compositeProxyTargetResolver")
    ProxyTargetResolver proxyTargetResolver;
    @Autowired
    ProxyWebSocketErrorHandler proxyWebSocketErrorHandler;
    @Autowired
    WebSocketStompClient stompClient;
    @Autowired
    @Qualifier(value="compositeHeadersCallback")
    WebSocketHttpHeadersCallback webSocketHttpHeadersCallback;

    public void registerStompEndpoints(StompEndpointRegistry registry) {
        boolean wsEnabled = false;
        for (Map.Entry<String, ZuulWebSocketProperties.WsBrokerage> entry : this.zuulWebSocketProperties.getBrokerages().entrySet()) {
            ZuulWebSocketProperties.WsBrokerage wsBrokerage = entry.getValue();
            if (!wsBrokerage.isEnabled()) continue;
            this.addStompEndpoint(registry, wsBrokerage.getEndPoints());
            wsEnabled = true;
        }
        if (!wsEnabled) {
            this.addStompEndpoint(registry, UUID.randomUUID().toString());
        }
    }

    public void configureMessageBroker(MessageBrokerRegistry config) {
        for (Map.Entry<String, ZuulWebSocketProperties.WsBrokerage> entry : this.zuulWebSocketProperties.getBrokerages().entrySet()) {
            ZuulWebSocketProperties.WsBrokerage wsBrokerage = entry.getValue();
            if (!wsBrokerage.isEnabled()) continue;
            config.enableSimpleBroker(this.mergeBrokersWithApplicationDestinationPrefixes(wsBrokerage));
            config.setApplicationDestinationPrefixes(wsBrokerage.getDestinationPrefixes());
        }
    }

    private SockJsServiceRegistration addStompEndpoint(StompEndpointRegistry registry, String ... endpoint) {
        return registry.addEndpoint(endpoint).setAllowedOrigins(new String[]{"*"}).withSockJS();
    }

    private String[] mergeBrokersWithApplicationDestinationPrefixes(ZuulWebSocketProperties.WsBrokerage wsBrokerage) {
        ArrayList<String> brokers = new ArrayList<String>(Arrays.asList(wsBrokerage.getBrokers()));
        for (String adp : wsBrokerage.getDestinationPrefixes()) {
            if (brokers.contains(adp)) continue;
            brokers.add(adp);
        }
        return brokers.toArray(new String[brokers.size()]);
    }

    public void configureWebSocketTransport(WebSocketTransportRegistration registration) {
        registration.addDecoratorFactory(new WebSocketHandlerDecoratorFactory(){

            public WebSocketHandler decorate(WebSocketHandler handler) {
                ProxyWebSocketHandler proxyWebSocketHandler = new ProxyWebSocketHandler(handler, ZuulWebSocketConfiguration.this.stompClient, ZuulWebSocketConfiguration.this.webSocketHttpHeadersCallback, ZuulWebSocketConfiguration.this.messagingTemplate, ZuulWebSocketConfiguration.this.proxyTargetResolver, ZuulWebSocketConfiguration.this.zuulWebSocketProperties);
                proxyWebSocketHandler.errorHandler(ZuulWebSocketConfiguration.this.proxyWebSocketErrorHandler);
                return proxyWebSocketHandler;
            }
        });
    }

    @Bean
    @Primary
    public WebSocketHttpHeadersCallback compositeHeadersCallback(List<WebSocketHttpHeadersCallback> headersCallbacks) {
        return new CompositeHeadersCallback(headersCallbacks);
    }

    @Bean
    @ConditionalOnClass(name={"org.springframework.security.core.Authentication"})
    public WebSocketHttpHeadersCallback basicAuthPrincipalHeadersCallback() {
        return new BasicAuthPrincipalHeadersCallback();
    }

    @Bean
    @ConditionalOnClass(name={"org.springframework.security.core.OAuth2Authentication"})
    public WebSocketHttpHeadersCallback oauth2BearerPrincipalHeadersCallback() {
        return new OAuth2BearerPrincipalHeadersCallback();
    }

    @Bean
    public WebSocketHttpHeadersCallback loginCookieHeadersCallback() {
        return new LoginCookieHeadersCallback();
    }

    @Bean
    public ProxyTargetResolver urlProxyTargetResolver(ZuulProperties zuulProperties) {
        return new UrlProxyTargetResolver(zuulProperties);
    }

    @Bean
    public ProxyTargetResolver discoveryProxyTargetResolver(ZuulProperties zuulProperties, DiscoveryClient discoveryClient) {
        return new EurekaProxyTargetResolver(discoveryClient, zuulProperties);
    }

    @Bean
    public ProxyTargetResolver loadBalancedProxyTargetResolver(ZuulProperties zuulProperties, LoadBalancerClient loadBalancerClient) {
        return new LoadBalancedProxyTargetResolver(loadBalancerClient, zuulProperties);
    }

    @Bean
    @Primary
    public ProxyTargetResolver compositeProxyTargetResolver(List<ProxyTargetResolver> resolvers) {
        return new CompositeProxyTargetResolver(resolvers);
    }

    @Bean
    @ConditionalOnMissingBean(value={WebSocketStompClient.class})
    public WebSocketStompClient stompClient(MessageConverter messageConverter, ThreadPoolTaskScheduler taskScheduler) {
        int bufferSizeLimit = 0x800000;
        StandardWebSocketClient webSocketClient = new StandardWebSocketClient();
        ArrayList<WebSocketTransport> transports = new ArrayList<WebSocketTransport>();
        transports.add(new WebSocketTransport((WebSocketClient)webSocketClient));
        SockJsClient sockJsClient = new SockJsClient(transports);
        WebSocketStompClient client = new WebSocketStompClient((WebSocketClient)sockJsClient);
        client.setInboundMessageSizeLimit(bufferSizeLimit);
        client.setMessageConverter(messageConverter);
        client.setTaskScheduler((TaskScheduler)taskScheduler);
        client.setDefaultHeartbeat(new long[]{0L, 0L});
        return client;
    }

    @Bean
    @ConditionalOnMissingBean(value={TaskScheduler.class})
    public TaskScheduler stompClientTaskScheduler() {
        return new ThreadPoolTaskScheduler();
    }

    @Bean
    public ProxyWebSocketErrorHandler reconnectErrorHandler() {
        return new ReconnectErrorHandler(new DefaultErrorAnalyzer());
    }

    @Bean
    @Primary
    public ProxyWebSocketErrorHandler compositeErrorHandler(List<ProxyWebSocketErrorHandler> errorHandlers) {
        return new CompositeErrorHandler(errorHandlers);
    }

    @Bean
    public ProxyRedirectFilter proxyRedirectFilter(RouteLocator routeLocator) {
        return new ProxyRedirectFilter(routeLocator);
    }

    @PostConstruct
    public void init() {
        this.ignorePattern("**/websocket");
        this.ignorePattern("**/info");
    }

    private void ignorePattern(String ignoredPattern) {
        for (String pattern : this.zuulProperties.getIgnoredPatterns()) {
            if (!pattern.toLowerCase().contains(ignoredPattern)) continue;
            return;
        }
        this.zuulProperties.getIgnoredPatterns().add(ignoredPattern);
    }

    public void onApplicationEvent(ContextRefreshedEvent event) {
        this.init();
    }
}

