/*
 * Decompiled with CFR 0.152.
 */
package com.github.mthizo247.cloud.netflix.zuul.web.target;

import com.github.mthizo247.cloud.netflix.zuul.web.socket.ZuulWebSocketProperties;
import com.github.mthizo247.cloud.netflix.zuul.web.target.AbstractProxyTargetResolver;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.cloud.netflix.zuul.filters.ZuulProperties;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class EurekaProxyTargetResolver
extends AbstractProxyTargetResolver {
    public static final int DEFAULT_ORDER = -2147483628;
    private DiscoveryClient discoveryClient;

    public EurekaProxyTargetResolver(DiscoveryClient discoveryClient, ZuulProperties zuulProperties) {
        super(zuulProperties);
        Assert.notNull((Object)discoveryClient, (String)"discoveryClient can't be null");
        this.discoveryClient = discoveryClient;
        this.order = -2147483628;
    }

    @Override
    public URI resolveTarget(ZuulWebSocketProperties.WsBrokerage wsBrokerage) {
        ZuulProperties.ZuulRoute zuulRoute = this.resolveRoute(wsBrokerage);
        if (zuulRoute == null || StringUtils.isEmpty((Object)zuulRoute.getServiceId())) {
            return null;
        }
        List instances = this.discoveryClient.getInstances(zuulRoute.getServiceId());
        ServiceInstance serviceInstance = CollectionUtils.isEmpty((Collection)instances) ? null : (ServiceInstance)instances.get(0);
        return serviceInstance != null ? this.resolveUri(serviceInstance) : null;
    }
}

