/*
 * Decompiled with CFR 0.152.
 */
package com.github.mthizo247.cloud.netflix.zuul.web.target;

import com.github.mthizo247.cloud.netflix.zuul.web.socket.ZuulWebSocketProperties;
import com.github.mthizo247.cloud.netflix.zuul.web.target.AbstractProxyTargetResolver;
import java.net.URI;
import java.net.URISyntaxException;
import org.springframework.cloud.netflix.zuul.filters.ZuulProperties;
import org.springframework.util.StringUtils;

public class UrlProxyTargetResolver
extends AbstractProxyTargetResolver {
    public static final int DEFAULT_ORDER = -2147483618;

    public UrlProxyTargetResolver(ZuulProperties zuulProperties) {
        super(zuulProperties);
        this.order = -2147483618;
    }

    @Override
    public URI resolveTarget(ZuulWebSocketProperties.WsBrokerage wsBrokerage) {
        ZuulProperties.ZuulRoute zuulRoute = this.resolveRoute(wsBrokerage);
        if (zuulRoute == null || StringUtils.isEmpty((Object)zuulRoute.getUrl())) {
            return null;
        }
        try {
            return new URI(zuulRoute.getUrl());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }
}

