/*
 * Decompiled with CFR 0.152.
 */
package com.upokecenter.numbers;

import com.upokecenter.numbers.EContext;
import com.upokecenter.numbers.EDecimal;
import com.upokecenter.numbers.EInteger;
import com.upokecenter.numbers.ERounding;
import com.upokecenter.numbers.Extras;
import com.upokecenter.numbers.FastInteger;
import com.upokecenter.numbers.FastIntegerFixed;

final class EDecimalByteArrayString {
    private static final int MaxSafeInt = 0xCCCCCCB;

    private EDecimalByteArrayString() {
    }

    static EDecimal FromString(byte[] chars, int offset, int length, EContext ctx, boolean throwException) {
        EDecimal ed;
        int tmpoffset = offset;
        if (chars == null) {
            if (!throwException) {
                return null;
            }
            throw new NullPointerException("chars");
        }
        if (tmpoffset < 0) {
            if (!throwException) {
                return null;
            }
            throw new NumberFormatException("offset(" + tmpoffset + ") is less than 0");
        }
        if (tmpoffset > chars.length) {
            if (!throwException) {
                return null;
            }
            throw new NumberFormatException("offset(" + tmpoffset + ") is more than " + chars.length);
        }
        if (length <= 0) {
            if (length == 0) {
                if (!throwException) {
                    return null;
                }
                throw new NumberFormatException("length is 0");
            }
            if (!throwException) {
                return null;
            }
            throw new NumberFormatException("length(" + length + ") is less than 0");
        }
        if (length > chars.length) {
            if (!throwException) {
                return null;
            }
            throw new NumberFormatException("length(" + length + ") is more than " + chars.length);
        }
        if (chars.length - tmpoffset < length) {
            if (!throwException) {
                return null;
            }
            throw new NumberFormatException("chars's length minus " + tmpoffset + "(" + (chars.length - tmpoffset) + ") is less than " + length);
        }
        boolean negative = false;
        int endStr = tmpoffset + length;
        byte c = chars[tmpoffset];
        if (c == 45) {
            negative = true;
            if (++tmpoffset >= endStr) {
                if (!throwException) {
                    return null;
                }
                throw new NumberFormatException();
            }
            c = chars[tmpoffset];
        } else if (chars[tmpoffset] == 43) {
            if (++tmpoffset >= endStr) {
                if (!throwException) {
                    return null;
                }
                throw new NumberFormatException();
            }
            c = chars[tmpoffset];
        }
        int i = tmpoffset;
        if ((c < 48 || c > 57) && (ed = EDecimalByteArrayString.ParseSpecialValue(chars, i, endStr, negative, ctx, throwException)) != null) {
            return ed;
        }
        if (ctx != null && ctx.getHasMaxPrecision() && ctx.getHasExponentRange() && !ctx.isSimplified()) {
            return EDecimalByteArrayString.ParseOrdinaryNumberLimitedPrecision(chars, i, endStr, negative, ctx, throwException);
        }
        return EDecimalByteArrayString.ParseOrdinaryNumber(chars, i, endStr, negative, ctx, throwException);
    }

    private static EDecimal ParseSpecialValue(byte[] chars, int i, int endStr, boolean negative, EContext ctx, boolean throwException) {
        int mantInt = 0;
        EInteger mant = null;
        boolean haveDigits = false;
        int digitStart = 0;
        if (!(i + 8 != endStr || chars[i] != 73 && chars[i] != 105 || chars[i + 1] != 78 && chars[i + 1] != 110 || chars[i + 2] != 70 && chars[i + 2] != 102 || chars[i + 3] != 73 && chars[i + 3] != 105 || chars[i + 4] != 78 && chars[i + 4] != 110 || chars[i + 5] != 73 && chars[i + 5] != 105 || chars[i + 6] != 84 && chars[i + 6] != 116 || chars[i + 7] != 89 && chars[i + 7] != 121)) {
            if (ctx != null && ctx.isSimplified() && i < endStr) {
                if (!throwException) {
                    return null;
                }
                throw new NumberFormatException("Infinity not allowed");
            }
            return negative ? EDecimal.NegativeInfinity : EDecimal.PositiveInfinity;
        }
        if (!(i + 3 != endStr || chars[i] != 73 && chars[i] != 105 || chars[i + 1] != 78 && chars[i + 1] != 110 || chars[i + 2] != 70 && chars[i + 2] != 102)) {
            if (ctx != null && ctx.isSimplified() && i < endStr) {
                if (!throwException) {
                    return null;
                }
                throw new NumberFormatException("Infinity not allowed");
            }
            return negative ? EDecimal.NegativeInfinity : EDecimal.PositiveInfinity;
        }
        if (!(i + 3 > endStr || chars[i] != 78 && chars[i] != 110 || chars[i + 1] != 65 && chars[i + 1] != 97 || chars[i + 2] != 78 && chars[i + 2] != 110)) {
            if (ctx != null && ctx.isSimplified() && i < endStr) {
                if (!throwException) {
                    return null;
                }
                throw new NumberFormatException("NaN not allowed");
            }
            int flags2 = (negative ? 1 : 0) | 4;
            if (i + 3 == endStr) {
                return !negative ? EDecimal.NaN : new EDecimal(FastIntegerFixed.Zero, FastIntegerFixed.Zero, (byte)flags2);
            }
            i += 3;
            FastInteger digitCount = new FastInteger(0);
            FastInteger maxDigits = null;
            haveDigits = false;
            if (ctx != null && ctx.getHasMaxPrecision()) {
                maxDigits = FastInteger.FromBig(ctx.getPrecision());
                if (ctx.getClampNormalExponents()) {
                    maxDigits.Decrement();
                }
            }
            digitStart = i;
            while (i < endStr) {
                if (chars[i] >= 48 && chars[i] <= 57) {
                    int thisdigit = chars[i] - 48;
                    boolean bl = haveDigits = haveDigits || thisdigit != 0;
                    if (mantInt <= 0xCCCCCCB) {
                        mantInt *= 10;
                        mantInt += thisdigit;
                    }
                    if (haveDigits && maxDigits != null) {
                        digitCount.Increment();
                        if (digitCount.compareTo(maxDigits) > 0) {
                            if (!throwException) {
                                return null;
                            }
                            throw new NumberFormatException();
                        }
                    }
                } else {
                    if (!throwException) {
                        return null;
                    }
                    throw new NumberFormatException();
                }
                ++i;
            }
            if (mantInt > 0xCCCCCCB) {
                mant = EInteger.FromSubstring(chars, digitStart, endStr);
            }
            EInteger bigmant = mant == null ? EInteger.FromInt32(mantInt) : mant;
            flags2 = (negative ? 1 : 0) | 4;
            return EDecimal.CreateWithFlags(FastIntegerFixed.FromBig(bigmant), FastIntegerFixed.Zero, flags2);
        }
        if (!(i + 4 > endStr || chars[i] != 83 && chars[i] != 115 || chars[i + 1] != 78 && chars[i + 1] != 110 || chars[i + 2] != 65 && chars[i + 2] != 97 || chars[i + 3] != 78 && chars[i + 3] != 110)) {
            if (ctx != null && ctx.isSimplified() && i < endStr) {
                if (!throwException) {
                    return null;
                }
                throw new NumberFormatException("NaN not allowed");
            }
            if (i + 4 == endStr) {
                int flags2 = (negative ? 1 : 0) | 8;
                return !negative ? EDecimal.SignalingNaN : new EDecimal(FastIntegerFixed.Zero, FastIntegerFixed.Zero, (byte)flags2);
            }
            i += 4;
            FastInteger digitCount = new FastInteger(0);
            FastInteger maxDigits = null;
            haveDigits = false;
            if (ctx != null && ctx.getHasMaxPrecision()) {
                maxDigits = FastInteger.FromBig(ctx.getPrecision());
                if (ctx.getClampNormalExponents()) {
                    maxDigits.Decrement();
                }
            }
            digitStart = i;
            while (i < endStr) {
                if (chars[i] >= 48 && chars[i] <= 57) {
                    int thisdigit = chars[i] - 48;
                    boolean bl = haveDigits = haveDigits || thisdigit != 0;
                    if (mantInt <= 0xCCCCCCB) {
                        mantInt *= 10;
                        mantInt += thisdigit;
                    }
                    if (haveDigits && maxDigits != null) {
                        digitCount.Increment();
                        if (digitCount.compareTo(maxDigits) > 0) {
                            if (!throwException) {
                                return null;
                            }
                            throw new NumberFormatException();
                        }
                    }
                } else {
                    if (!throwException) {
                        return null;
                    }
                    throw new NumberFormatException();
                }
                ++i;
            }
            if (mantInt > 0xCCCCCCB) {
                mant = EInteger.FromSubstring(chars, digitStart, endStr);
            }
            int flags3 = (negative ? 1 : 0) | 8;
            EInteger bigmant = mant == null ? EInteger.FromInt32(mantInt) : mant;
            return EDecimal.CreateWithFlags(bigmant, EInteger.FromInt32(0), flags3);
        }
        return null;
    }

    private static EDecimal ParseOrdinaryNumberLimitedPrecision(byte[] chars, int offset, int endStr, boolean negative, EContext ctx, boolean throwException) {
        EInteger exp;
        int i;
        int tmpoffset = offset;
        if (chars == null) {
            if (!throwException) {
                return null;
            }
            throw new NullPointerException("chars");
        }
        if (ctx == null || !ctx.getHasMaxPrecision()) {
            if (!throwException) {
                return null;
            }
            throw new IllegalStateException();
        }
        boolean haveDecimalPoint = false;
        boolean haveDigits = false;
        boolean haveExponent = false;
        int newScaleInt = 0;
        long mantissaLong = 0L;
        int digitStart = i;
        int digitEnd = i;
        int decimalDigitStart = i;
        boolean haveNonzeroDigit = false;
        int decimalPrec = 0;
        int decimalDigitEnd = i;
        boolean nonzeroBeyondMax = false;
        boolean beyondMax = false;
        int lastdigit = -1;
        EInteger precisionPlusTwo = ctx.getPrecision().Add(2);
        for (i = tmpoffset; i < endStr; ++i) {
            byte ch = chars[i];
            if (ch >= 48 && ch <= 57) {
                int thisdigit = ch - 48;
                haveDigits = true;
                haveNonzeroDigit |= thisdigit != 0;
                if (beyondMax || precisionPlusTwo.compareTo(decimalPrec) < 0 && mantissaLong == Long.MAX_VALUE) {
                    beyondMax = true;
                    if (thisdigit != 0) {
                        nonzeroBeyondMax = true;
                    }
                    if (haveDecimalPoint) continue;
                    ++newScaleInt;
                    continue;
                }
                lastdigit = thisdigit;
                if (haveNonzeroDigit) {
                    ++decimalPrec;
                }
                if (haveDecimalPoint) {
                    decimalDigitEnd = i + 1;
                } else {
                    digitEnd = i + 1;
                }
                if (mantissaLong <= 0xCCCCCCCCCCCCCCCL) {
                    mantissaLong *= 10L;
                    mantissaLong += (long)thisdigit;
                } else {
                    mantissaLong = Long.MAX_VALUE;
                }
                if (!haveDecimalPoint) continue;
                --newScaleInt;
                continue;
            }
            if (ch == 46) {
                if (haveDecimalPoint) {
                    if (!throwException) {
                        return null;
                    }
                    throw new NumberFormatException();
                }
                haveDecimalPoint = true;
                decimalDigitStart = i + 1;
                decimalDigitEnd = i + 1;
                continue;
            }
            if (ch == 69 || ch == 101) {
                haveExponent = true;
                ++i;
                break;
            }
            if (!throwException) {
                return null;
            }
            throw new NumberFormatException();
        }
        if (!haveDigits) {
            if (!throwException) {
                return null;
            }
            throw new NumberFormatException();
        }
        int expInt = 0;
        int expoffset = 1;
        int expDigitStart = -1;
        int expPrec = 0;
        boolean zeroMantissa = !haveNonzeroDigit;
        haveNonzeroDigit = false;
        if (haveExponent) {
            haveDigits = false;
            if (i == endStr) {
                if (!throwException) {
                    return null;
                }
                throw new NumberFormatException();
            }
            if (chars[i] == 43 || chars[i] == 45) {
                if (chars[i] == 45) {
                    expoffset = -1;
                }
                ++i;
            }
            expDigitStart = i;
            while (i < endStr) {
                byte ch = chars[i];
                if (ch >= 48 && ch <= 57) {
                    haveDigits = true;
                    int thisdigit = ch - 48;
                    if (haveNonzeroDigit |= thisdigit != 0) {
                        ++expPrec;
                    }
                    if (expInt <= 0xCCCCCCC) {
                        expInt *= 10;
                        expInt += thisdigit;
                    } else {
                        expInt = Integer.MAX_VALUE;
                    }
                } else {
                    if (!throwException) {
                        return null;
                    }
                    throw new NumberFormatException();
                }
                ++i;
            }
            if (!haveDigits) {
                if (!throwException) {
                    return null;
                }
                throw new NumberFormatException();
            }
            expInt *= expoffset;
            if (expPrec > 12) {
                if (expoffset < 0) {
                    return EDecimal.SignalUnderflow(ctx, negative, zeroMantissa);
                }
                return EDecimal.SignalOverflow(ctx, negative, zeroMantissa);
            }
        }
        if (i != endStr) {
            if (!throwException) {
                return null;
            }
            throw new NumberFormatException();
        }
        if (expInt != Integer.MAX_VALUE && expInt > -2147483647 && mantissaLong != Long.MAX_VALUE) {
            long finalexp = (long)expInt + (long)newScaleInt;
            if (negative) {
                mantissaLong = -mantissaLong;
            }
            EDecimal eret = EDecimal.Create(mantissaLong, finalexp);
            if (negative && zeroMantissa) {
                eret = eret.Negate();
            }
            return eret.RoundToPrecision(ctx);
        }
        EInteger mant = null;
        EInteger eInteger = exp = !haveExponent ? EInteger.FromInt32(0) : EInteger.FromSubstring(chars, expDigitStart, endStr);
        if (expoffset < 0) {
            exp = exp.Negate();
        }
        exp = exp.Add(newScaleInt);
        if (nonzeroBeyondMax) {
            exp = exp.Subtract(1);
            ++decimalPrec;
        }
        if (ctx.getHasExponentRange()) {
            EInteger adjExpUpperBound = exp.Add(decimalPrec).Subtract(1);
            EInteger adjExpLowerBound = exp;
            EInteger eTiny = ctx.getEMin().Subtract(ctx.getPrecision().Subtract(1));
            if (adjExpUpperBound.compareTo(eTiny = eTiny.Subtract(1)) < 0) {
                return EDecimal.SignalUnderflow(ctx, negative, zeroMantissa);
            }
            if (adjExpLowerBound.compareTo(ctx.getEMax()) > 0) {
                return EDecimal.SignalOverflow(ctx, negative, zeroMantissa);
            }
        }
        if (zeroMantissa) {
            EDecimal ef = EDecimal.Create(EInteger.FromInt32(0), exp);
            if (negative) {
                ef = ef.Negate();
            }
            return ef.RoundToPrecision(ctx);
        }
        if (decimalDigitStart != decimalDigitEnd) {
            byte[] ctmpstr = Extras.CharsConcat(chars, digitStart, digitEnd - digitStart, chars, decimalDigitStart, decimalDigitEnd - decimalDigitStart);
            mant = EInteger.FromString(ctmpstr);
        } else {
            mant = EInteger.FromSubstring(chars, digitStart, digitEnd);
        }
        if (nonzeroBeyondMax) {
            mant = mant.Multiply(10).Add(1);
        }
        if (negative) {
            mant = mant.Negate();
        }
        return EDecimal.Create(mant, exp).RoundToPrecision(ctx);
    }

    private static EDecimal ParseOrdinaryNumberNoContext(byte[] chars, int i, int endStr, boolean negative, boolean throwException) {
        FastIntegerFixed fastIntMant;
        FastIntegerFixed fastIntScale;
        byte tch;
        int mantInt = 0;
        EInteger mant = null;
        boolean haveDecimalPoint = false;
        boolean haveExponent = false;
        int newScaleInt = 0;
        boolean haveDigits = false;
        int digitStart = 0;
        EInteger newScale = null;
        if (endStr - i == 1 && (tch = chars[i]) >= 48 && tch <= 57) {
            int si = tch - 48;
            return negative ? (si == 0 ? EDecimal.NegativeZero : EDecimal.FromCache(-si)) : EDecimal.FromCache(si);
        }
        digitStart = i;
        int digitEnd = i;
        int decimalDigitStart = i;
        boolean haveNonzeroDigit = false;
        int decimalPrec = 0;
        int firstdigit = -1;
        int decimalDigitEnd = i;
        int lastdigit = -1;
        int realDigitEnd = -1;
        int realDecimalEnd = -1;
        while (i < endStr) {
            byte ch = chars[i];
            if (ch >= 48 && ch <= 57) {
                int thisdigit = ch - 48;
                haveNonzeroDigit |= thisdigit != 0;
                if (firstdigit < 0) {
                    firstdigit = thisdigit;
                }
                haveDigits = true;
                lastdigit = thisdigit;
                if (haveNonzeroDigit) {
                    ++decimalPrec;
                }
                if (haveDecimalPoint) {
                    decimalDigitEnd = i + 1;
                } else {
                    digitEnd = i + 1;
                }
                if (mantInt <= 0xCCCCCCB) {
                    mantInt *= 10;
                    mantInt += thisdigit;
                }
                if (haveDecimalPoint) {
                    if (newScaleInt == Integer.MIN_VALUE || newScaleInt == Integer.MAX_VALUE) {
                        newScale = newScale == null ? EInteger.FromInt32(newScaleInt) : newScale;
                        newScale = newScale.Subtract(1);
                    } else {
                        --newScaleInt;
                    }
                }
            } else if (ch == 46) {
                if (haveDecimalPoint) {
                    if (!throwException) {
                        return null;
                    }
                    throw new NumberFormatException();
                }
                haveDecimalPoint = true;
                realDigitEnd = i;
                decimalDigitStart = i + 1;
                decimalDigitEnd = i + 1;
            } else {
                if (ch == 69 || ch == 101) {
                    realDecimalEnd = i++;
                    haveExponent = true;
                    break;
                }
                if (!throwException) {
                    return null;
                }
                throw new NumberFormatException();
            }
            ++i;
        }
        if (!haveDigits) {
            if (!throwException) {
                return null;
            }
            throw new NumberFormatException();
        }
        if (realDigitEnd < 0) {
            realDigitEnd = i;
        }
        if (realDecimalEnd < 0) {
            realDecimalEnd = i;
        }
        EDecimal ret = null;
        EInteger exp = null;
        int expInt = 0;
        int expoffset = 1;
        int expDigitStart = -1;
        int expPrec = 0;
        haveNonzeroDigit = false;
        if (haveExponent) {
            haveDigits = false;
            if (i == endStr) {
                if (!throwException) {
                    return null;
                }
                throw new NumberFormatException();
            }
            byte ch = chars[i];
            if (ch == 43 || ch == 45) {
                if (ch == 45) {
                    expoffset = -1;
                }
                ++i;
            }
            expDigitStart = i;
            while (i < endStr) {
                ch = chars[i];
                if (ch >= 48 && ch <= 57) {
                    haveDigits = true;
                    int thisdigit = ch - 48;
                    if (haveNonzeroDigit |= thisdigit != 0) {
                        ++expPrec;
                    }
                    if (expInt <= 0xCCCCCCB) {
                        expInt *= 10;
                        expInt += thisdigit;
                    }
                } else {
                    if (!throwException) {
                        return null;
                    }
                    throw new NumberFormatException();
                }
                ++i;
            }
            if (!haveDigits) {
                if (!throwException) {
                    return null;
                }
                throw new NumberFormatException();
            }
        }
        if (i != endStr) {
            if (!throwException) {
                return null;
            }
            throw new NumberFormatException();
        }
        if (haveExponent && expInt <= 0xCCCCCCB) {
            if (expoffset >= 0 && newScaleInt == 0 && newScale == null) {
                newScaleInt = expInt;
            } else if (newScale == null) {
                long tmplong = newScaleInt;
                if (expoffset < 0) {
                    tmplong -= (long)expInt;
                } else if (expInt != 0) {
                    tmplong += (long)expInt;
                }
                if (tmplong >= Integer.MAX_VALUE && tmplong <= Integer.MIN_VALUE) {
                    newScaleInt = (int)tmplong;
                } else {
                    newScale = EInteger.FromInt64(tmplong);
                }
            } else if (expoffset < 0) {
                newScale = newScale.Subtract(expInt);
            } else if (expInt != 0) {
                newScale = newScale.Add(expInt);
            }
        }
        int de = digitEnd;
        int dde = decimalDigitEnd;
        if (!haveExponent && haveDecimalPoint) {
            long lv = 0L;
            int expo = -(dde - decimalDigitStart);
            int digitCount = 0;
            if (mantInt <= 0xCCCCCCB) {
                lv = mantInt;
            } else {
                byte chvi;
                int vi = 0;
                for (vi = digitStart; vi < de; ++vi) {
                    chvi = chars[vi];
                    if (digitCount < 0 || digitCount >= 18) {
                        digitCount = -1;
                        break;
                    }
                    if (digitCount > 0 || chvi != 48) {
                        ++digitCount;
                    }
                    lv = lv * 10L + (long)(chvi - 48);
                }
                for (vi = decimalDigitStart; vi < dde; ++vi) {
                    chvi = chars[vi];
                    if (digitCount < 0 || digitCount >= 18) {
                        digitCount = -1;
                        break;
                    }
                    if (digitCount > 0 || chvi != 48) {
                        ++digitCount;
                    }
                    lv = lv * 10L + (long)(chvi - 48);
                }
            }
            if (negative) {
                lv = -lv;
            }
            if (!(digitCount < 0 || negative && lv == 0L)) {
                ret = EDecimal.Create(lv, (long)expo);
                return ret;
            }
        }
        if (mantInt > 0xCCCCCCB) {
            if (haveDecimalPoint) {
                if (digitEnd - digitStart == 1 && firstdigit == 0) {
                    mant = EInteger.FromSubstring(chars, decimalDigitStart, decimalDigitEnd);
                } else {
                    byte[] cdecstr = Extras.CharsConcat(chars, digitStart, digitEnd - digitStart, chars, decimalDigitStart, decimalDigitEnd - decimalDigitStart);
                    mant = EInteger.FromString(cdecstr);
                }
            } else {
                mant = EInteger.FromSubstring(chars, digitStart, digitEnd);
            }
        }
        if (haveExponent && expInt > 0xCCCCCCB) {
            exp = EInteger.FromSubstring(chars, expDigitStart, endStr);
            newScale = newScale == null ? EInteger.FromInt32(newScaleInt) : newScale;
            newScale = expoffset < 0 ? newScale.Subtract(exp) : newScale.Add(exp);
        }
        FastIntegerFixed fastIntegerFixed = fastIntScale = newScale == null ? FastIntegerFixed.FromInt32(newScaleInt) : FastIntegerFixed.FromBig(newScale);
        if (mant == null) {
            fastIntMant = FastIntegerFixed.FromInt32(mantInt);
        } else if (mant.CanFitInInt32()) {
            mantInt = mant.ToInt32Checked();
            fastIntMant = FastIntegerFixed.FromInt32(mantInt);
        } else {
            fastIntMant = FastIntegerFixed.FromBig(mant);
        }
        ret = new EDecimal(fastIntMant, fastIntScale, (byte)(negative ? 1 : 0));
        return ret;
    }

    private static EDecimal ParseOrdinaryNumber(byte[] chars, int i, int endStr, boolean negative, EContext ctx, boolean throwException) {
        FastIntegerFixed fastIntMant;
        FastIntegerFixed fastIntScale;
        int precdiff;
        byte tch;
        if (ctx == null) {
            return EDecimalByteArrayString.ParseOrdinaryNumberNoContext(chars, i, endStr, negative, throwException);
        }
        int mantInt = 0;
        EInteger mant = null;
        boolean haveDecimalPoint = false;
        boolean haveExponent = false;
        int newScaleInt = 0;
        boolean haveDigits = false;
        int digitStart = 0;
        EInteger newScale = null;
        if (endStr - i == 1 && (tch = chars[i]) >= 48 && tch <= 57) {
            EDecimal cret;
            int si = tch - 48;
            EDecimal eDecimal = negative ? (si == 0 ? EDecimal.NegativeZero : EDecimal.FromCache(-si)) : (cret = EDecimal.FromCache(si));
            if (ctx != null) {
                cret = EDecimal.GetMathValue(ctx).RoundAfterConversion(cret, ctx);
            }
            return cret;
        }
        digitStart = i;
        int digitEnd = i;
        int decimalDigitStart = i;
        boolean haveNonzeroDigit = false;
        int decimalPrec = 0;
        int decimalDigitEnd = i;
        boolean roundDown = ctx != null && ctx.getHasMaxPrecision() && !ctx.isPrecisionInBits() && (ctx.getRounding() == ERounding.Down || negative && ctx.getRounding() == ERounding.Ceiling || !negative && ctx.getRounding() == ERounding.Floor) && !ctx.getHasFlagsOrTraps();
        boolean roundHalf = ctx != null && ctx.getHasMaxPrecision() && !ctx.isPrecisionInBits() && (ctx.getRounding() == ERounding.HalfUp || ctx.getRounding() == ERounding.HalfDown || ctx.getRounding() == ERounding.HalfEven) && !ctx.getHasFlagsOrTraps();
        boolean roundUp = ctx != null && ctx.getHasMaxPrecision() && !ctx.isPrecisionInBits() && (ctx.getRounding() == ERounding.Up || !negative && ctx.getRounding() == ERounding.Ceiling || negative && ctx.getRounding() == ERounding.Floor) && !ctx.getHasFlagsOrTraps();
        boolean haveIgnoredDigit = false;
        int lastdigit = -1;
        boolean beyondPrecision = false;
        boolean ignoreNextDigit = false;
        int zerorun = 0;
        int realDigitEnd = -1;
        int realDecimalEnd = -1;
        while (i < endStr) {
            byte ch = chars[i];
            if (ch >= 48 && ch <= 57) {
                int thisdigit = ch - 48;
                haveNonzeroDigit |= thisdigit != 0;
                haveDigits = true;
                beyondPrecision |= ctx != null && ctx.getHasMaxPrecision() && !ctx.isPrecisionInBits() && ctx.getPrecision().compareTo(decimalPrec) <= 0;
                if (ctx != null) {
                    if (ignoreNextDigit) {
                        haveIgnoredDigit = true;
                        ignoreNextDigit = false;
                    }
                    if (roundDown && (haveIgnoredDigit || beyondPrecision)) {
                        haveIgnoredDigit = true;
                    } else if (roundUp && beyondPrecision && !haveIgnoredDigit) {
                        if (thisdigit > 0) {
                            ignoreNextDigit = true;
                        } else {
                            roundUp = false;
                        }
                    } else if (roundHalf && beyondPrecision && !haveIgnoredDigit) {
                        if (thisdigit >= 1 && thisdigit < 5) {
                            ignoreNextDigit = true;
                        } else if (thisdigit > 5 || thisdigit == 5 && ctx.getRounding() == ERounding.HalfUp) {
                            roundHalf = false;
                            roundUp = true;
                            ignoreNextDigit = true;
                        } else {
                            roundHalf = false;
                        }
                    }
                }
                if (haveIgnoredDigit) {
                    zerorun = 0;
                    if (newScaleInt == Integer.MIN_VALUE || newScaleInt == Integer.MAX_VALUE) {
                        newScale = newScale == null ? EInteger.FromInt32(newScaleInt) : newScale;
                        newScale = newScale.Add(1);
                    } else {
                        ++newScaleInt;
                    }
                } else {
                    lastdigit = thisdigit;
                    zerorun = beyondPrecision && thisdigit == 0 ? ++zerorun : 0;
                    if (haveNonzeroDigit) {
                        ++decimalPrec;
                    }
                    if (haveDecimalPoint) {
                        decimalDigitEnd = i + 1;
                    } else {
                        digitEnd = i + 1;
                    }
                    if (mantInt <= 0xCCCCCCB) {
                        mantInt *= 10;
                        mantInt += thisdigit;
                    }
                }
                if (haveDecimalPoint) {
                    if (newScaleInt == Integer.MIN_VALUE || newScaleInt == Integer.MAX_VALUE) {
                        newScale = newScale == null ? EInteger.FromInt32(newScaleInt) : newScale;
                        newScale = newScale.Subtract(1);
                    } else {
                        --newScaleInt;
                    }
                }
            } else if (ch == 46) {
                if (haveDecimalPoint) {
                    if (!throwException) {
                        return null;
                    }
                    throw new NumberFormatException();
                }
                haveDecimalPoint = true;
                realDigitEnd = i;
                decimalDigitStart = i + 1;
                decimalDigitEnd = i + 1;
            } else {
                if (ch == 69 || ch == 101) {
                    realDecimalEnd = i++;
                    haveExponent = true;
                    break;
                }
                if (!throwException) {
                    return null;
                }
                throw new NumberFormatException();
            }
            ++i;
        }
        if (!haveDigits) {
            if (!throwException) {
                return null;
            }
            throw new NumberFormatException();
        }
        if (realDigitEnd < 0) {
            realDigitEnd = i;
        }
        if (realDecimalEnd < 0) {
            realDecimalEnd = i;
        }
        if (!(zerorun <= 0 || lastdigit != 0 || ctx != null && ctx.getHasFlagsOrTraps())) {
            int nondec = 0;
            if (ctx == null || !ctx.getHasMaxPrecision() || (decimalPrec -= zerorun) - ctx.getPrecision().ToInt32Checked() > zerorun) {
                if (haveDecimalPoint) {
                    int decdigits = decimalDigitEnd - decimalDigitStart;
                    nondec = Math.min(decdigits, zerorun);
                    decimalDigitEnd -= nondec;
                    int remain = zerorun - nondec;
                    digitEnd -= remain;
                    nondec = zerorun;
                } else {
                    digitEnd -= zerorun;
                    nondec = zerorun;
                }
                if (newScaleInt > Integer.MIN_VALUE + nondec && newScaleInt < Integer.MAX_VALUE - nondec) {
                    newScaleInt += nondec;
                } else {
                    newScale = newScale == null ? EInteger.FromInt32(newScaleInt) : newScale;
                    newScale = newScale.Add(nondec);
                }
            }
        }
        if (roundUp && ctx != null && ctx.getPrecision().compareTo(decimalPrec) < 0 && (precdiff = decimalPrec - ctx.getPrecision().ToInt32Checked()) > 1) {
            int precchop = precdiff - 1;
            decimalPrec -= precchop;
            int nondec = precchop;
            if (haveDecimalPoint) {
                int decdigits = decimalDigitEnd - decimalDigitStart;
                decimalDigitEnd -= nondec;
                int remain = precchop - nondec;
                digitEnd -= remain;
            } else {
                digitEnd -= precchop;
            }
            if (newScaleInt < Integer.MAX_VALUE - nondec) {
                newScaleInt += nondec;
            } else {
                newScale = newScale == null ? EInteger.FromInt32(newScaleInt) : newScale;
                newScale = newScale.Add(nondec);
            }
        }
        EDecimal ret = null;
        EInteger exp = null;
        int expInt = 0;
        int expoffset = 1;
        int expDigitStart = -1;
        int expPrec = 0;
        haveNonzeroDigit = false;
        if (haveExponent) {
            haveDigits = false;
            if (i == endStr) {
                if (!throwException) {
                    return null;
                }
                throw new NumberFormatException();
            }
            if (chars[i] == 43 || chars[i] == 45) {
                if (chars[i] == 45) {
                    expoffset = -1;
                }
                ++i;
            }
            expDigitStart = i;
            while (i < endStr) {
                byte ch = chars[i];
                if (ch >= 48 && ch <= 57) {
                    haveDigits = true;
                    int thisdigit = ch - 48;
                    if (haveNonzeroDigit |= thisdigit != 0) {
                        ++expPrec;
                    }
                    if (expInt <= 0xCCCCCCB) {
                        expInt *= 10;
                        expInt += thisdigit;
                    }
                } else {
                    if (!throwException) {
                        return null;
                    }
                    throw new NumberFormatException();
                }
                ++i;
            }
            if (!haveDigits) {
                if (!throwException) {
                    return null;
                }
                throw new NumberFormatException();
            }
        }
        if (i != endStr) {
            if (!throwException) {
                return null;
            }
            throw new NumberFormatException();
        }
        if (haveExponent && expInt <= 0xCCCCCCB) {
            if (expoffset >= 0 && newScaleInt == 0 && newScale == null) {
                newScaleInt = expInt;
            } else if (newScale == null) {
                long tmplong = newScaleInt;
                if (expoffset < 0) {
                    tmplong -= (long)expInt;
                } else if (expInt != 0) {
                    tmplong += (long)expInt;
                }
                if (tmplong >= Integer.MAX_VALUE && tmplong <= Integer.MIN_VALUE) {
                    newScaleInt = (int)tmplong;
                } else {
                    newScale = EInteger.FromInt64(tmplong);
                }
            } else if (expoffset < 0) {
                newScale = newScale.Subtract(expInt);
            } else if (expInt != 0) {
                newScale = newScale.Add(expInt);
            }
        }
        if (ctx != null && (mantInt > 0xCCCCCCB || haveExponent && expInt > 0xCCCCCCB) && ctx.getHasExponentRange()) {
            EInteger ns;
            if (expInt <= 0xCCCCCCB && ctx != null) {
                ns = newScale == null ? EInteger.FromInt32(newScaleInt) : newScale;
            } else {
                EInteger trialExponent = EInteger.FromInt32(0xCCCCCCB);
                if (expPrec > 25) {
                    trialExponent = EInteger.FromInt64(Long.MAX_VALUE);
                }
                if (expoffset >= 0 && newScaleInt == 0 && newScale == null) {
                    ns = trialExponent;
                } else {
                    ns = newScale == null ? EInteger.FromInt32(newScaleInt) : newScale;
                    ns = expoffset < 0 ? ns.Subtract(trialExponent) : ns.Add(trialExponent);
                }
            }
            int expwithin = EDecimal.CheckOverflowUnderflow(ctx, decimalPrec, ns);
            if (mantInt == 0 && (expwithin == 1 || expwithin == 2 || expwithin == 3)) {
                ret = new EDecimal(FastIntegerFixed.FromInt32(0), FastIntegerFixed.FromBig(ns), (byte)(negative ? 1 : 0));
                return EDecimal.GetMathValue(ctx).RoundAfterConversion(ret, ctx);
            }
            if (expwithin == 1) {
                return EDecimal.GetMathValue(ctx).SignalOverflow(ctx, negative);
            }
            if (expwithin == 2 || expwithin == 3 && mantInt < 0xCCCCCCB) {
                ret = new EDecimal(FastIntegerFixed.FromInt32(expwithin == 3 ? mantInt : 1), FastIntegerFixed.FromBig(ns), (byte)(negative ? 1 : 0));
                return EDecimal.GetMathValue(ctx).RoundAfterConversion(ret, ctx);
            }
            if (expwithin == 3 && (ctx == null || ctx.getTraps() == 0)) {
                ret = new EDecimal(FastIntegerFixed.FromInt32(1), FastIntegerFixed.FromBig(ns), (byte)(negative ? 1 : 0));
                ret = EDecimal.GetMathValue(ctx).RoundAfterConversion(ret, ctx);
                ns = ret.getExponent().Subtract(decimalPrec - 1);
                ret = EDecimal.ChangeExponent(ret, ns);
                return ret;
            }
        }
        int de = digitEnd;
        int dde = decimalDigitEnd;
        if (!haveExponent && haveDecimalPoint && newScale == null) {
            long lv = 0L;
            int expo = newScaleInt;
            int digitCount = 0;
            if (mantInt <= 0xCCCCCCB) {
                lv = mantInt;
            } else {
                byte chvi;
                int vi = 0;
                for (vi = digitStart; vi < de; ++vi) {
                    chvi = chars[vi];
                    if (digitCount < 0 || digitCount >= 18) {
                        digitCount = -1;
                        break;
                    }
                    if (digitCount > 0 || chvi != 48) {
                        ++digitCount;
                    }
                    lv = lv * 10L + (long)(chvi - 48);
                }
                for (vi = decimalDigitStart; vi < dde; ++vi) {
                    chvi = chars[vi];
                    if (digitCount < 0 || digitCount >= 18) {
                        digitCount = -1;
                        break;
                    }
                    if (digitCount > 0 || chvi != 48) {
                        ++digitCount;
                    }
                    lv = lv * 10L + (long)(chvi - 48);
                }
            }
            if (negative) {
                lv = -lv;
            }
            if (!(digitCount < 0 || negative && lv == 0L)) {
                ret = EDecimal.Create(lv, (long)expo);
                if (ctx != null) {
                    ret = EDecimal.GetMathValue(ctx).RoundAfterConversion(ret, ctx);
                }
                return ret;
            }
        }
        if (mantInt > 0xCCCCCCB) {
            if (haveDecimalPoint) {
                if (digitEnd - digitStart == 1 && chars[digitStart] == 48) {
                    mant = EInteger.FromSubstring(chars, decimalDigitStart, decimalDigitEnd);
                } else {
                    byte[] cdecstr = Extras.CharsConcat(chars, digitStart, digitEnd - digitStart, chars, decimalDigitStart, decimalDigitEnd - decimalDigitStart);
                    mant = EInteger.FromString(cdecstr);
                }
            } else {
                mant = EInteger.FromSubstring(chars, digitStart, digitEnd);
            }
        }
        if (haveExponent && expInt > 0xCCCCCCB) {
            exp = EInteger.FromSubstring(chars, expDigitStart, endStr);
            newScale = newScale == null ? EInteger.FromInt32(newScaleInt) : newScale;
            newScale = expoffset < 0 ? newScale.Subtract(exp) : newScale.Add(exp);
        }
        FastIntegerFixed fastIntegerFixed = fastIntScale = newScale == null ? FastIntegerFixed.FromInt32(newScaleInt) : FastIntegerFixed.FromBig(newScale);
        if (mant == null) {
            fastIntMant = FastIntegerFixed.FromInt32(mantInt);
        } else if (mant.CanFitInInt32()) {
            mantInt = mant.ToInt32Checked();
            fastIntMant = FastIntegerFixed.FromInt32(mantInt);
        } else {
            fastIntMant = FastIntegerFixed.FromBig(mant);
        }
        ret = new EDecimal(fastIntMant, fastIntScale, (byte)(negative ? 1 : 0));
        if (ctx != null) {
            ret = EDecimal.GetMathValue(ctx).RoundAfterConversion(ret, ctx);
        }
        return ret;
    }
}

