/*
 * Decompiled with CFR 0.152.
 */
package com.upokecenter.numbers;

import com.upokecenter.numbers.BitShiftAccumulator;
import com.upokecenter.numbers.DigitShiftAccumulator;
import com.upokecenter.numbers.EContext;
import com.upokecenter.numbers.EDecimal;
import com.upokecenter.numbers.EFloatByteArrayString;
import com.upokecenter.numbers.EFloatCharArrayString;
import com.upokecenter.numbers.EFloatTextString;
import com.upokecenter.numbers.EInteger;
import com.upokecenter.numbers.ERounding;
import com.upokecenter.numbers.ExtendedOrSimpleRadixMath;
import com.upokecenter.numbers.FastInteger;
import com.upokecenter.numbers.FastIntegerFixed;
import com.upokecenter.numbers.IRadixMath;
import com.upokecenter.numbers.IRadixMathHelper;
import com.upokecenter.numbers.IShiftAccumulator;
import com.upokecenter.numbers.NumberUtility;
import com.upokecenter.numbers.TrappableRadixMath;

public final class EFloat
implements Comparable<EFloat> {
    private static final int CacheFirst = -24;
    private static final int CacheLast = 128;
    public static final EFloat NaN = new EFloat(FastIntegerFixed.Zero, FastIntegerFixed.Zero, 4);
    public static final EFloat NegativeInfinity = new EFloat(FastIntegerFixed.Zero, FastIntegerFixed.Zero, 3);
    public static final EFloat NegativeZero = new EFloat(FastIntegerFixed.Zero, FastIntegerFixed.Zero, 1);
    public static final EFloat One = new EFloat(FastIntegerFixed.One, FastIntegerFixed.Zero, 0);
    public static final EFloat PositiveInfinity = new EFloat(FastIntegerFixed.Zero, FastIntegerFixed.Zero, 2);
    public static final EFloat SignalingNaN = new EFloat(FastIntegerFixed.Zero, FastIntegerFixed.Zero, 8);
    public static final EFloat Ten = new EFloat(FastIntegerFixed.FromInt32(10), FastIntegerFixed.Zero, 0);
    public static final EFloat Zero = new EFloat(FastIntegerFixed.Zero, FastIntegerFixed.Zero, 0);
    private static final EFloat[] Cache = EFloat.EFloatCache(-24, 128);
    private static final IRadixMath<EFloat> MathValue = new TrappableRadixMath<EFloat>(new ExtendedOrSimpleRadixMath<EFloat>(new BinaryMathHelper()));
    private final FastIntegerFixed exponent;
    private final FastIntegerFixed unsignedMantissa;
    private final byte flags;

    private static EFloat[] EFloatCache(int first, int last) {
        EFloat[] cache = new EFloat[last - first + 1];
        for (int i = first; i <= last; ++i) {
            cache[i - first] = i == 0 ? Zero : (i == 1 ? One : (i == 10 ? Ten : new EFloat(FastIntegerFixed.FromInt32(Math.abs(i)), FastIntegerFixed.Zero, (byte)(i < 0 ? 1 : 0))));
        }
        return cache;
    }

    static IRadixMath<EFloat> GetMathValue() {
        return MathValue;
    }

    private EFloat(FastIntegerFixed unsignedMantissa, FastIntegerFixed exponent, byte flags) {
        this.unsignedMantissa = unsignedMantissa;
        this.exponent = exponent;
        this.flags = flags;
    }

    public final EInteger getExponent() {
        return this.exponent.ToEInteger();
    }

    public final boolean isFinite() {
        return (this.flags & 0xE) == 0;
    }

    public final boolean isNegative() {
        return (this.flags & 1) != 0;
    }

    public final boolean isZero() {
        return (this.flags & 0xE) == 0 && this.unsignedMantissa.isValueZero();
    }

    public final EInteger getMantissa() {
        return this.isNegative() ? this.unsignedMantissa.ToEInteger().Negate() : this.unsignedMantissa.ToEInteger();
    }

    public final int signum() {
        return (this.flags & 0xE) == 0 && this.unsignedMantissa.isValueZero() ? 0 : ((this.flags & 1) != 0 ? -1 : 1);
    }

    public final EInteger getUnsignedMantissa() {
        return this.unsignedMantissa.ToEInteger();
    }

    public EFloat Copy() {
        return new EFloat(this.unsignedMantissa, this.exponent, this.flags);
    }

    public static EFloat Create(int mantissaSmall, int exponentSmall) {
        if (exponentSmall == 0 && mantissaSmall >= -24 && mantissaSmall <= 128) {
            return Cache[mantissaSmall - -24];
        }
        if (mantissaSmall < 0) {
            if (mantissaSmall == Integer.MIN_VALUE) {
                FastIntegerFixed fi = FastIntegerFixed.FromInt64(Integer.MIN_VALUE);
                return new EFloat(fi.Negate(), FastIntegerFixed.FromInt32(exponentSmall), 1);
            }
            return new EFloat(FastIntegerFixed.FromInt32(-mantissaSmall), FastIntegerFixed.FromInt32(exponentSmall), 1);
        }
        if (mantissaSmall == 0) {
            return new EFloat(FastIntegerFixed.Zero, FastIntegerFixed.FromInt32(exponentSmall), 0);
        }
        return new EFloat(FastIntegerFixed.FromInt32(mantissaSmall), FastIntegerFixed.FromInt32(exponentSmall), 0);
    }

    public static EFloat Create(EInteger mantissa, int exponentSmall) {
        if (mantissa == null) {
            throw new NullPointerException("mantissa");
        }
        if (mantissa.CanFitInInt32()) {
            int mantissaSmall = mantissa.ToInt32Checked();
            return EFloat.Create(mantissaSmall, exponentSmall);
        }
        FastIntegerFixed fi = FastIntegerFixed.FromBig(mantissa);
        int sign = fi.signum();
        return new EFloat(sign < 0 ? fi.Negate() : fi, FastIntegerFixed.FromInt32(exponentSmall), (byte)(sign < 0 ? 1 : 0));
    }

    public static EFloat Create(EInteger mantissa, long exponentLong) {
        if (mantissa == null) {
            throw new NullPointerException("mantissa");
        }
        if (mantissa.CanFitInInt64()) {
            long mantissaLong = mantissa.ToInt64Checked();
            return EFloat.Create(mantissaLong, exponentLong);
        }
        FastIntegerFixed fi = FastIntegerFixed.FromBig(mantissa);
        int sign = fi.signum();
        return new EFloat(sign < 0 ? fi.Negate() : fi, FastIntegerFixed.FromInt64(exponentLong), (byte)(sign < 0 ? 1 : 0));
    }

    public static EFloat Create(EInteger mantissa, EInteger exponent) {
        if (mantissa == null) {
            throw new NullPointerException("mantissa");
        }
        if (exponent == null) {
            throw new NullPointerException("exponent");
        }
        if (mantissa.CanFitInInt32() && exponent.isZero()) {
            int mantissaSmall = mantissa.ToInt32Checked();
            return EFloat.Create(mantissaSmall, 0);
        }
        FastIntegerFixed fi = FastIntegerFixed.FromBig(mantissa);
        int sign = fi.signum();
        return new EFloat(sign < 0 ? fi.Negate() : fi, FastIntegerFixed.FromBig(exponent), (byte)(sign < 0 ? 1 : 0));
    }

    public static EFloat Create(long mantissaLong, int exponentSmall) {
        return EFloat.Create(mantissaLong, (long)exponentSmall);
    }

    public static EFloat Create(long mantissaLong, long exponentLong) {
        if (mantissaLong >= Integer.MIN_VALUE && mantissaLong <= Integer.MAX_VALUE && exponentLong >= Integer.MIN_VALUE && exponentLong <= Integer.MAX_VALUE) {
            return EFloat.Create((int)mantissaLong, (int)exponentLong);
        }
        if (mantissaLong == Long.MIN_VALUE) {
            FastIntegerFixed fi = FastIntegerFixed.FromInt64(mantissaLong);
            return new EFloat(fi.Negate(), FastIntegerFixed.FromInt64(exponentLong), (byte)(mantissaLong < 0L ? 1 : 0));
        }
        FastIntegerFixed fi = FastIntegerFixed.FromInt64(Math.abs(mantissaLong));
        return new EFloat(fi, FastIntegerFixed.FromInt64(exponentLong), (byte)(mantissaLong < 0L ? 1 : 0));
    }

    public static EFloat CreateNaN(EInteger diag) {
        return EFloat.CreateNaN(diag, false, false, null);
    }

    public static EFloat CreateNaN(EInteger diag, boolean signaling, boolean negative, EContext ctx) {
        if (diag == null) {
            throw new NullPointerException("diag");
        }
        if (diag.signum() < 0) {
            throw new IllegalArgumentException("Diagnostic information must be 0 or greater,  was: " + diag);
        }
        if (diag.isZero() && !negative) {
            return signaling ? SignalingNaN : NaN;
        }
        int flags = 0;
        if (negative) {
            flags |= 1;
        }
        if (ctx != null && ctx.getHasMaxPrecision()) {
            EFloat ef = new EFloat(FastIntegerFixed.FromBig(diag), FastIntegerFixed.Zero, (byte)(flags |= 4)).RoundToPrecision(ctx);
            int newFlags = ef.flags;
            newFlags &= 0xFFFFFFFB;
            return new EFloat(ef.unsignedMantissa, ef.exponent, (byte)(newFlags |= signaling ? 8 : 4));
        }
        return new EFloat(FastIntegerFixed.FromBig(diag), FastIntegerFixed.Zero, (byte)(flags |= signaling ? 8 : 4));
    }

    public static EFloat FromDoubleBits(long dblBits) {
        boolean neg;
        int floatExponent = (int)(dblBits >> 52 & 0x7FFL);
        boolean bl = neg = dblBits >> 63 != 0L;
        if (floatExponent == 2047) {
            if ((dblBits & 0xFFFFFFFFFFFFFL) == 0L) {
                return neg ? NegativeInfinity : PositiveInfinity;
            }
            boolean quiet = (dblBits >> 32 & 0x80000L) != 0L;
            long lvalue = dblBits & 0x7FFFFFFFFFFFFL;
            if (lvalue == 0L) {
                return quiet ? NaN : SignalingNaN;
            }
            int flags = (neg ? 1 : 0) | (quiet ? 4 : 8);
            return EFloat.CreateWithFlags(EInteger.FromInt64(lvalue), EInteger.FromInt32(0), flags);
        }
        long lvalue = dblBits & 0xFFFFFFFFFFFFFL;
        if (floatExponent == 0) {
            ++floatExponent;
        } else {
            lvalue |= 0x10000000000000L;
        }
        if (lvalue != 0L) {
            while ((lvalue & 1L) == 0L) {
                lvalue >>= 1;
                ++floatExponent;
            }
        } else {
            return neg ? NegativeZero : Zero;
        }
        return EFloat.CreateWithFlags(EInteger.FromInt64(lvalue), EInteger.FromInt64(floatExponent - 1075), neg ? 1 : 0);
    }

    public static EFloat FromSingle(float flt) {
        return EFloat.FromSingleBits(Float.floatToRawIntBits(flt));
    }

    public static EFloat FromDouble(double dbl) {
        long lvalue = Double.doubleToRawLongBits(dbl);
        return EFloat.FromDoubleBits(lvalue);
    }

    public static EFloat FromEInteger(EInteger bigint) {
        return EFloat.Create(bigint, 0);
    }

    public static EFloat FromSingleBits(int value) {
        boolean neg = value >> 31 != 0;
        int floatExponent = value >> 23 & 0xFF;
        int valueFpMantissa = value & 0x7FFFFF;
        if (floatExponent == 255) {
            if (valueFpMantissa == 0) {
                return neg ? NegativeInfinity : PositiveInfinity;
            }
            boolean quiet = (valueFpMantissa & 0x400000) != 0;
            EInteger bigmant = EInteger.FromInt32(valueFpMantissa &= 0x3FFFFF);
            value = (neg ? 1 : 0) | (quiet ? 4 : 8);
            if (bigmant.isZero()) {
                return quiet ? NaN : SignalingNaN;
            }
            return EFloat.CreateWithFlags(bigmant, EInteger.FromInt32(0), value);
        }
        if (floatExponent == 0) {
            ++floatExponent;
        } else {
            valueFpMantissa |= 0x800000;
        }
        if (valueFpMantissa == 0) {
            return neg ? NegativeZero : Zero;
        }
        while ((valueFpMantissa & 1) == 0) {
            ++floatExponent;
            valueFpMantissa >>= 1;
        }
        if (neg) {
            valueFpMantissa = -valueFpMantissa;
        }
        EInteger bigmant = EInteger.FromInt32(valueFpMantissa);
        return EFloat.Create(bigmant, EInteger.FromInt64(floatExponent - 150));
    }

    static EFloat SignalUnderflow(EContext ec, boolean negative, boolean zeroSignificand) {
        EInteger eTiny = ec.getEMin().Subtract(ec.getPrecision().Subtract(1));
        eTiny = eTiny.Subtract(2);
        EFloat ret = EFloat.Create(zeroSignificand ? EInteger.FromInt32(0) : EInteger.FromInt32(1), eTiny);
        if (negative) {
            ret = ret.Negate();
        }
        return ret.RoundToPrecision(ec);
    }

    static EFloat SignalOverflow(EContext ec, boolean negative, boolean zeroSignificand) {
        if (zeroSignificand) {
            EFloat ret = EFloat.Create(EInteger.FromInt32(0), ec.getEMax());
            if (negative) {
                ret = ret.Negate();
            }
            return ret.RoundToPrecision(ec);
        }
        return MathValue.SignalOverflow(ec, negative);
    }

    public static EFloat FromString(String str, int offset, int length, EContext ctx) {
        return EFloatTextString.FromString(str, offset, length, ctx, true);
    }

    public static EFloat FromString(String str) {
        return EFloat.FromString(str, 0, str == null ? 0 : str.length(), null);
    }

    public static EFloat FromString(String str, EContext ctx) {
        return EFloat.FromString(str, 0, str == null ? 0 : str.length(), ctx);
    }

    public static EFloat FromString(String str, int offset, int length) {
        return EFloat.FromString(str, offset, length, null);
    }

    public static EFloat FromString(char[] chars, int offset, int length, EContext ctx) {
        return EFloatCharArrayString.FromString(chars, offset, length, ctx, true);
    }

    public static EFloat FromString(char[] chars) {
        return EFloat.FromString(chars, 0, chars == null ? 0 : chars.length, null);
    }

    public static EFloat FromString(char[] chars, EContext ctx) {
        return EFloat.FromString(chars, 0, chars == null ? 0 : chars.length, ctx);
    }

    public static EFloat FromString(char[] chars, int offset, int length) {
        return EFloat.FromString(chars, offset, length, null);
    }

    public static EFloat FromString(byte[] bytes, int offset, int length, EContext ctx) {
        return EFloatByteArrayString.FromString(bytes, offset, length, ctx, true);
    }

    public static EFloat FromString(byte[] bytes) {
        return EFloat.FromString(bytes, 0, bytes == null ? 0 : bytes.length, null);
    }

    public static EFloat FromString(byte[] bytes, EContext ctx) {
        return EFloat.FromString(bytes, 0, bytes == null ? 0 : bytes.length, ctx);
    }

    public static EFloat FromString(byte[] bytes, int offset, int length) {
        return EFloat.FromString(bytes, offset, length, null);
    }

    public static EFloat Max(EFloat first, EFloat second, EContext ctx) {
        if (first == null) {
            throw new NullPointerException("first");
        }
        if (second == null) {
            throw new NullPointerException("second");
        }
        return MathValue.Max(first, second, ctx);
    }

    public static EFloat Max(EFloat first, EFloat second) {
        if (first == null) {
            throw new NullPointerException("first");
        }
        if (second == null) {
            throw new NullPointerException("second");
        }
        return EFloat.Max(first, second, null);
    }

    public static EFloat MaxMagnitude(EFloat first, EFloat second, EContext ctx) {
        if (first == null) {
            throw new NullPointerException("first");
        }
        if (second == null) {
            throw new NullPointerException("second");
        }
        return MathValue.MaxMagnitude(first, second, ctx);
    }

    public static EFloat MaxMagnitude(EFloat first, EFloat second) {
        if (first == null) {
            throw new NullPointerException("first");
        }
        if (second == null) {
            throw new NullPointerException("second");
        }
        return EFloat.MaxMagnitude(first, second, null);
    }

    public static EFloat Min(EFloat first, EFloat second, EContext ctx) {
        if (first == null) {
            throw new NullPointerException("first");
        }
        if (second == null) {
            throw new NullPointerException("second");
        }
        return MathValue.Min(first, second, ctx);
    }

    public static EFloat Min(EFloat first, EFloat second) {
        if (first == null) {
            throw new NullPointerException("first");
        }
        if (second == null) {
            throw new NullPointerException("second");
        }
        return EFloat.Min(first, second, null);
    }

    public static EFloat MinMagnitude(EFloat first, EFloat second, EContext ctx) {
        if (first == null) {
            throw new NullPointerException("first");
        }
        if (second == null) {
            throw new NullPointerException("second");
        }
        return MathValue.MinMagnitude(first, second, ctx);
    }

    public static EFloat MinMagnitude(EFloat first, EFloat second) {
        if (first == null) {
            throw new NullPointerException("first");
        }
        if (second == null) {
            throw new NullPointerException("second");
        }
        return EFloat.MinMagnitude(first, second, null);
    }

    public static EFloat PI(EContext ctx) {
        return MathValue.Pi(ctx);
    }

    public EFloat Abs() {
        if (this.isNegative()) {
            EFloat er = new EFloat(this.unsignedMantissa, this.exponent, (byte)(this.flags & 0xFFFFFFFE));
            return er;
        }
        return this;
    }

    public EFloat Abs(EContext context) {
        return MathValue.Abs(this, context);
    }

    public EFloat Add(int intValue) {
        return this.Add(EFloat.FromInt32(intValue));
    }

    public EFloat Subtract(int intValue) {
        return intValue == Integer.MIN_VALUE ? this.Subtract(EFloat.FromInt32(intValue)) : this.Add(-intValue);
    }

    public EFloat Multiply(int intValue) {
        return this.Multiply(EFloat.FromInt32(intValue));
    }

    public EFloat Divide(int intValue) {
        return this.Divide(EFloat.FromInt32(intValue));
    }

    public EFloat Add(long longValue) {
        return this.Add(EFloat.FromInt64(longValue));
    }

    public EFloat Subtract(long longValue) {
        return this.Subtract(EFloat.FromInt64(longValue));
    }

    public EFloat Multiply(long longValue) {
        return this.Multiply(EFloat.FromInt64(longValue));
    }

    public EFloat Divide(long longValue) {
        return this.Divide(EFloat.FromInt64(longValue));
    }

    public EFloat Add(EFloat otherValue) {
        return this.Add(otherValue, EContext.UnlimitedHalfEven);
    }

    public EFloat Add(EFloat otherValue, EContext ctx) {
        return MathValue.Add(this, otherValue, ctx);
    }

    @Override
    public int compareTo(EFloat other) {
        return MathValue.compareTo(this, other);
    }

    public int CompareToValue(EFloat other) {
        return MathValue.compareTo(this, other);
    }

    @Override
    public int compareTo(int intOther) {
        return this.CompareToValue(EFloat.FromInt32(intOther));
    }

    public int CompareToValue(int intOther) {
        return this.CompareToValue(EFloat.FromInt32(intOther));
    }

    public int CompareToValue(long intOther) {
        return this.CompareToValue(EFloat.FromInt64(intOther));
    }

    @Override
    public int compareTo(long intOther) {
        return this.CompareToValue(EFloat.FromInt64(intOther));
    }

    public EFloat CompareToSignal(EFloat other, EContext ctx) {
        return MathValue.CompareToWithContext(this, other, true, ctx);
    }

    public int CompareToTotal(EFloat other, EContext ctx) {
        if (other == null) {
            return 1;
        }
        if (this.IsSignalingNaN() || other.IsSignalingNaN()) {
            return this.CompareToTotal(other);
        }
        if (ctx != null && ctx.isSimplified()) {
            return this.RoundToPrecision(ctx).CompareToTotal(other.RoundToPrecision(ctx));
        }
        return this.CompareToTotal(other);
    }

    public int CompareToTotalMagnitude(EFloat other, EContext ctx) {
        if (other == null) {
            return 1;
        }
        if (this.IsSignalingNaN() || other.IsSignalingNaN()) {
            return this.CompareToTotalMagnitude(other);
        }
        if (ctx != null && ctx.isSimplified()) {
            return this.RoundToPrecision(ctx).CompareToTotalMagnitude(other.RoundToPrecision(ctx));
        }
        return this.CompareToTotalMagnitude(other);
    }

    public int CompareToTotal(EFloat other) {
        boolean neg2;
        if (other == null) {
            return 1;
        }
        boolean neg1 = this.isNegative();
        if (neg1 != (neg2 = other.isNegative())) {
            return neg1 ? -1 : 1;
        }
        int valueIThis = 0;
        int valueIOther = 0;
        if (this.IsSignalingNaN()) {
            valueIThis = 2;
        } else if (this.IsNaN()) {
            valueIThis = 3;
        } else if (this.IsInfinity()) {
            valueIThis = 1;
        }
        if (other.IsSignalingNaN()) {
            valueIOther = 2;
        } else if (other.IsNaN()) {
            valueIOther = 3;
        } else if (other.IsInfinity()) {
            valueIOther = 1;
        }
        if (valueIThis > valueIOther) {
            return neg1 ? -1 : 1;
        }
        if (valueIThis < valueIOther) {
            return neg1 ? 1 : -1;
        }
        if (valueIThis >= 2) {
            int cmp = this.unsignedMantissa.compareTo(other.unsignedMantissa);
            return neg1 ? -cmp : cmp;
        }
        if (valueIThis == 1) {
            return 0;
        }
        int cmp = this.compareTo(other);
        if (cmp == 0) {
            cmp = this.exponent.compareTo(other.exponent);
            return neg1 ? -cmp : cmp;
        }
        return cmp;
    }

    public int CompareToTotalMagnitude(EFloat other) {
        if (other == null) {
            return 1;
        }
        int valueIThis = 0;
        int valueIOther = 0;
        if (this.IsSignalingNaN()) {
            valueIThis = 2;
        } else if (this.IsNaN()) {
            valueIThis = 3;
        } else if (this.IsInfinity()) {
            valueIThis = 1;
        }
        if (other.IsSignalingNaN()) {
            valueIOther = 2;
        } else if (other.IsNaN()) {
            valueIOther = 3;
        } else if (other.IsInfinity()) {
            valueIOther = 1;
        }
        if (valueIThis > valueIOther) {
            return 1;
        }
        if (valueIThis < valueIOther) {
            return -1;
        }
        if (valueIThis >= 2) {
            int cmp = this.unsignedMantissa.compareTo(other.unsignedMantissa);
            return cmp;
        }
        if (valueIThis == 1) {
            return 0;
        }
        int cmp = this.Abs().compareTo(other.Abs());
        if (cmp == 0) {
            cmp = this.exponent.compareTo(other.exponent);
            return cmp;
        }
        return cmp;
    }

    public EFloat CompareToWithContext(EFloat other, EContext ctx) {
        return MathValue.CompareToWithContext(this, other, false, ctx);
    }

    public EFloat CopySign(EFloat other) {
        if (other == null) {
            throw new NullPointerException("other");
        }
        if (this.isNegative()) {
            return other.isNegative() ? this : this.Negate();
        }
        return other.isNegative() ? this.Negate() : this;
    }

    public EFloat Divide(EFloat divisor) {
        return this.Divide(divisor, EContext.ForRounding(ERounding.None));
    }

    public EFloat Divide(EFloat divisor, EContext ctx) {
        return MathValue.Divide(this, divisor, ctx);
    }

    @Deprecated
    public EFloat[] DivideAndRemainderNaturalScale(EFloat divisor) {
        return this.DivRemNaturalScale(divisor, null);
    }

    @Deprecated
    public EFloat[] DivideAndRemainderNaturalScale(EFloat divisor, EContext ctx) {
        return this.DivRemNaturalScale(divisor, ctx);
    }

    public EFloat DivideToExponent(EFloat divisor, long desiredExponentSmall, EContext ctx) {
        return this.DivideToExponent(divisor, EInteger.FromInt64(desiredExponentSmall), ctx);
    }

    public EFloat DivideToExponent(EFloat divisor, long desiredExponentSmall, ERounding rounding) {
        return this.DivideToExponent(divisor, EInteger.FromInt64(desiredExponentSmall), EContext.ForRounding(rounding));
    }

    public EFloat DivideToExponent(EFloat divisor, EInteger exponent, EContext ctx) {
        return MathValue.DivideToExponent(this, divisor, exponent, ctx);
    }

    public EFloat DivideToExponent(EFloat divisor, EInteger desiredExponent, ERounding rounding) {
        return this.DivideToExponent(divisor, desiredExponent, EContext.ForRounding(rounding));
    }

    public EFloat DivideToIntegerNaturalScale(EFloat divisor) {
        return this.DivideToIntegerNaturalScale(divisor, EContext.ForRounding(ERounding.Down));
    }

    public EFloat DivideToIntegerNaturalScale(EFloat divisor, EContext ctx) {
        return MathValue.DivideToIntegerNaturalScale(this, divisor, ctx);
    }

    public EFloat DivideToIntegerZeroScale(EFloat divisor, EContext ctx) {
        return MathValue.DivideToIntegerZeroScale(this, divisor, ctx);
    }

    public EFloat DivideToSameExponent(EFloat divisor, ERounding rounding) {
        return this.DivideToExponent(divisor, this.exponent.ToEInteger(), EContext.ForRounding(rounding));
    }

    public EFloat[] DivRemNaturalScale(EFloat divisor) {
        return this.DivRemNaturalScale(divisor, null);
    }

    public EFloat[] DivRemNaturalScale(EFloat divisor, EContext ctx) {
        EFloat[] result;
        result = new EFloat[]{this.DivideToIntegerNaturalScale(divisor, null), this.Subtract(result[0].Multiply(divisor, null), ctx)};
        result[0] = result[0].RoundToPrecision(ctx);
        return result;
    }

    public boolean equals(EFloat other) {
        return this.EqualsInternal(other);
    }

    public boolean equals(Object obj) {
        return this.EqualsInternal(obj instanceof EFloat ? (EFloat)obj : null);
    }

    public boolean EqualsInternal(EFloat otherValue) {
        if (otherValue == null) {
            return false;
        }
        return this.exponent.equals(otherValue.exponent) && this.unsignedMantissa.equals(otherValue.unsignedMantissa) && this.flags == otherValue.flags;
    }

    public EFloat Exp(EContext ctx) {
        return MathValue.Exp(this, ctx);
    }

    public EFloat ExpM1(EContext ctx) {
        EFloat ret;
        EFloat value = this;
        if (value.IsNaN()) {
            return value.Plus(ctx);
        }
        if (ctx == null || !ctx.getHasMaxPrecision()) {
            return SignalingNaN.Plus(ctx);
        }
        if (ctx.getTraps() != 0) {
            EContext tctx = ctx.GetNontrapping();
            EFloat ret2 = value.ExpM1(tctx);
            return ctx.TriggerTraps(ret2, tctx);
        }
        if (ctx.isSimplified()) {
            EContext tmpctx = ctx.WithSimplified(false).WithBlankFlags();
            EFloat ret3 = value.PreRound(ctx).ExpM1(tmpctx);
            if (ctx.getHasFlags()) {
                int flags = ctx.getFlags();
                ctx.setFlags(flags | tmpctx.getFlags());
            }
            return ret3.RoundToPrecision(ctx);
        }
        if (value.compareTo(-1) == 0) {
            return NegativeInfinity;
        }
        if (value.IsPositiveInfinity()) {
            return PositiveInfinity;
        }
        if (value.IsNegativeInfinity()) {
            return EFloat.FromInt32(-1).Plus(ctx);
        }
        if (value.compareTo(0) == 0) {
            return EFloat.FromInt32(0).Plus(ctx);
        }
        int flags = ctx.getFlags();
        EContext tmpctx = null;
        EInteger prec = ctx.getPrecision().Add(3);
        tmpctx = ctx.WithBigPrecision(prec).WithBlankFlags();
        if (value.Abs().compareTo(EFloat.Create(1, -1)) < 0) {
            EFloat oldret = ret = value.Exp(tmpctx).Add(EFloat.FromInt32(-1), ctx);
            while ((ret = value.Exp(tmpctx = ctx.WithBigPrecision(prec = prec.Add(ctx.getPrecision()).Add(3)).WithBlankFlags()).Add(EFloat.FromInt32(-1), ctx)).compareTo(0) == 0 || ret.compareTo(oldret) != 0) {
                oldret = ret;
            }
        } else {
            ret = value.Exp(tmpctx).Add(EFloat.FromInt32(-1), ctx);
        }
        flags |= tmpctx.getFlags();
        if (ctx.getHasFlags()) {
            ctx.setFlags(flags |= ctx.getFlags());
        }
        return ret;
    }

    public int hashCode() {
        int valueHashCode = 403796923;
        valueHashCode += 403797019 * this.exponent.hashCode();
        valueHashCode += 403797059 * this.unsignedMantissa.hashCode();
        return valueHashCode += 403797127 * this.flags;
    }

    public boolean IsInfinity() {
        return (this.flags & 2) != 0;
    }

    public boolean IsNaN() {
        return (this.flags & 0xC) != 0;
    }

    public boolean IsNegativeInfinity() {
        return (this.flags & 3) == 3;
    }

    public boolean IsPositiveInfinity() {
        return (this.flags & 3) == 2;
    }

    public boolean IsQuietNaN() {
        return (this.flags & 4) != 0;
    }

    public boolean IsSignalingNaN() {
        return (this.flags & 8) != 0;
    }

    public EFloat Log(EContext ctx) {
        return MathValue.Ln(this, ctx);
    }

    public EFloat Log10(EContext ctx) {
        return this.LogN(EFloat.FromInt32(10), ctx);
    }

    public EFloat Log1P(EContext ctx) {
        EFloat ret;
        EFloat value = this;
        if (value.IsNaN()) {
            return value.Plus(ctx);
        }
        if (ctx == null || !ctx.getHasMaxPrecision() || value.compareTo(-1) < 0) {
            return SignalingNaN.Plus(ctx);
        }
        if (ctx.getTraps() != 0) {
            EContext tctx = ctx.GetNontrapping();
            EFloat ret2 = value.Log1P(tctx);
            return ctx.TriggerTraps(ret2, tctx);
        }
        if (ctx.isSimplified()) {
            EContext tmpctx = ctx.WithSimplified(false).WithBlankFlags();
            EFloat ret3 = value.PreRound(ctx).Log1P(tmpctx);
            if (ctx.getHasFlags()) {
                int flags = ctx.getFlags();
                ctx.setFlags(flags | tmpctx.getFlags());
            }
            return ret3.RoundToPrecision(ctx);
        }
        if (value.compareTo(-1) == 0) {
            return NegativeInfinity;
        }
        if (value.IsPositiveInfinity()) {
            return PositiveInfinity;
        }
        if (value.compareTo(0) == 0) {
            return EFloat.FromInt32(0).Plus(ctx);
        }
        int flags = ctx.getFlags();
        EContext tmpctx = null;
        if (value.compareTo(EFloat.Create(1, -1)) < 0) {
            ret = value.Add(EFloat.FromInt32(1)).Log(ctx);
        } else {
            tmpctx = ctx.WithBigPrecision(ctx.getPrecision().Add(3)).WithBlankFlags();
            ret = value.Add(EFloat.FromInt32(1), tmpctx).Log(ctx);
            flags |= tmpctx.getFlags();
        }
        if (ctx.getHasFlags()) {
            ctx.setFlags(flags |= ctx.getFlags());
        }
        return ret;
    }

    public EFloat LogN(EFloat baseValue, EContext ctx) {
        EFloat value = this;
        if (baseValue == null) {
            throw new NullPointerException("baseValue");
        }
        if (value.IsNaN()) {
            return value.Plus(ctx);
        }
        if (baseValue.IsNaN()) {
            return baseValue.Plus(ctx);
        }
        if (ctx == null || !ctx.getHasMaxPrecision() || value.isNegative() && !value.isZero() || baseValue.isNegative() && !baseValue.isZero()) {
            return SignalingNaN.Plus(ctx);
        }
        if (ctx.getTraps() != 0) {
            EContext tctx = ctx.GetNontrapping();
            EFloat ret = value.LogN(baseValue, tctx);
            return ctx.TriggerTraps(ret, tctx);
        }
        if (ctx.isSimplified()) {
            EContext tmpctx = ctx.WithSimplified(false).WithBlankFlags();
            EFloat ret = value.PreRound(ctx).LogN(baseValue.PreRound(ctx), tmpctx);
            if (ctx.getHasFlags()) {
                int flags = ctx.getFlags();
                ctx.setFlags(flags | tmpctx.getFlags());
            }
            return ret.RoundToPrecision(ctx);
        }
        if (value.isZero()) {
            return baseValue.compareTo(1) < 0 ? PositiveInfinity : NegativeInfinity;
        }
        if (value.IsPositiveInfinity()) {
            return baseValue.compareTo(1) < 0 ? NegativeInfinity : PositiveInfinity;
        }
        if (baseValue.compareTo(2) == 0) {
            EFloat ev = value.Reduce(null);
            if (ev.getUnsignedMantissa().compareTo(1) == 0) {
                return EFloat.FromEInteger(ev.getExponent()).Plus(ctx);
            }
        } else {
            if (value.compareTo(1) == 0) {
                return EFloat.FromInt32(0).Plus(ctx);
            }
            if (value.compareTo(baseValue) == 0) {
                return EFloat.FromInt32(1).Plus(ctx);
            }
        }
        int flags = ctx.getFlags();
        EContext tmpctx = ctx.WithBigPrecision(ctx.getPrecision().Add(3)).WithBlankFlags();
        EFloat ret = value.Log(tmpctx).Divide(baseValue.Log(tmpctx), ctx);
        if (ret.IsInteger() && !ret.isZero()) {
            EFloat rtmp;
            flags |= 3;
            if (baseValue.Pow(ret).CompareToValue(value) == 0 && !(rtmp = ret.Quantize(EFloat.FromInt32(1), ctx.WithNoFlags())).IsNaN()) {
                flags &= 0xFFFFFFFC;
                ret = rtmp;
            }
        } else {
            flags |= tmpctx.getFlags();
        }
        if (ctx.getHasFlags()) {
            ctx.setFlags(flags |= ctx.getFlags());
        }
        return ret;
    }

    public EFloat MovePointLeft(int places) {
        return this.MovePointLeft(EInteger.FromInt32(places), null);
    }

    public EFloat MovePointLeft(int places, EContext ctx) {
        return this.MovePointLeft(EInteger.FromInt32(places), ctx);
    }

    public EFloat MovePointLeft(EInteger bigPlaces) {
        return this.MovePointLeft(bigPlaces, null);
    }

    public EFloat MovePointLeft(EInteger bigPlaces, EContext ctx) {
        return !this.isFinite() ? this.RoundToPrecision(ctx) : this.MovePointRight(bigPlaces.Negate(), ctx);
    }

    public EFloat MovePointRight(int places) {
        return this.MovePointRight(EInteger.FromInt32(places), null);
    }

    public EFloat MovePointRight(int places, EContext ctx) {
        return this.MovePointRight(EInteger.FromInt32(places), ctx);
    }

    public EFloat MovePointRight(EInteger bigPlaces) {
        return this.MovePointRight(bigPlaces, null);
    }

    public EFloat MovePointRight(EInteger bigPlaces, EContext ctx) {
        if (!this.isFinite()) {
            return this.RoundToPrecision(ctx);
        }
        EInteger bigExp = this.getExponent();
        if ((bigExp = bigExp.Add(bigPlaces)).signum() > 0) {
            EInteger mant = this.getUnsignedMantissa().ShiftLeft(bigExp);
            return EFloat.CreateWithFlags(mant, EInteger.FromInt32(0), (int)this.flags).RoundToPrecision(ctx);
        }
        return EFloat.CreateWithFlags(this.getUnsignedMantissa(), bigExp, (int)this.flags).RoundToPrecision(ctx);
    }

    public EFloat Multiply(EFloat otherValue) {
        if (otherValue == null) {
            throw new NullPointerException("otherValue");
        }
        if (this.isFinite() && otherValue.isFinite()) {
            EInteger exp = this.getExponent().Add(otherValue.getExponent());
            int newflags = otherValue.flags ^ this.flags;
            if (this.unsignedMantissa.CanFitInInt32() && otherValue.unsignedMantissa.CanFitInInt32()) {
                int integerA = this.unsignedMantissa.ToInt32();
                int integerB = otherValue.unsignedMantissa.ToInt32();
                long longA = (long)integerA * (long)integerB;
                return EFloat.CreateWithFlags(longA, exp, newflags);
            }
            EInteger eintA = this.getUnsignedMantissa().Multiply(otherValue.getUnsignedMantissa());
            return EFloat.CreateWithFlags(eintA, exp, newflags);
        }
        return this.Multiply(otherValue, EContext.UnlimitedHalfEven);
    }

    public EFloat Multiply(EFloat op, EContext ctx) {
        return MathValue.Multiply(this, op, ctx);
    }

    public EFloat MultiplyAndAdd(EFloat multiplicand, EFloat augend) {
        return this.MultiplyAndAdd(multiplicand, augend, null);
    }

    public EFloat MultiplyAndAdd(EFloat op, EFloat augend, EContext ctx) {
        return MathValue.MultiplyAndAdd(this, op, augend, ctx);
    }

    public EFloat MultiplyAndSubtract(EFloat op, EFloat subtrahend, EContext ctx) {
        if (op == null) {
            throw new NullPointerException("op");
        }
        if (subtrahend == null) {
            throw new NullPointerException("subtrahend");
        }
        EFloat negated = subtrahend;
        if ((subtrahend.flags & 0xC) == 0) {
            int newflags = subtrahend.flags ^ 1;
            negated = new EFloat(subtrahend.unsignedMantissa, subtrahend.exponent, (byte)newflags);
        }
        return MathValue.MultiplyAndAdd(this, op, negated, ctx);
    }

    public EFloat Negate() {
        return new EFloat(this.unsignedMantissa, this.exponent, (byte)(this.flags ^ 1));
    }

    public EFloat Negate(EContext context) {
        return MathValue.Negate(this, context);
    }

    public EFloat NextMinus(EContext ctx) {
        return MathValue.NextMinus(this, ctx);
    }

    public EFloat NextPlus(EContext ctx) {
        return MathValue.NextPlus(this, ctx);
    }

    public EFloat NextToward(EFloat otherValue, EContext ctx) {
        return MathValue.NextToward(this, otherValue, ctx);
    }

    public EFloat Plus(EContext ctx) {
        return MathValue.Plus(this, ctx);
    }

    public EFloat Pow(EFloat exponent) {
        return this.Pow(exponent, null);
    }

    public EFloat Pow(EFloat exponent, EContext ctx) {
        return MathValue.Power(this, exponent, ctx);
    }

    public EFloat Pow(int exponentSmall, EContext ctx) {
        return this.Pow(EFloat.FromInt64(exponentSmall), ctx);
    }

    public EFloat Pow(int exponentSmall) {
        return this.Pow(EFloat.FromInt64(exponentSmall), null);
    }

    public EInteger Precision() {
        if (!this.isFinite()) {
            return EInteger.FromInt32(0);
        }
        return this.isZero() ? EInteger.FromInt32(1) : this.getUnsignedMantissa().GetSignedBitLengthAsEInteger();
    }

    public boolean IsInteger() {
        if (!this.isFinite()) {
            return false;
        }
        if (this.isZero() || this.getExponent().compareTo(0) >= 0) {
            return true;
        }
        EInteger absexp = this.getExponent().Abs();
        EInteger mant = this.getUnsignedMantissa();
        return mant.GetLowBitAsEInteger().compareTo(absexp) >= 0;
    }

    public EFloat Quantize(EInteger desiredExponent, EContext ctx) {
        return this.Quantize(EFloat.Create(EInteger.FromInt32(1), desiredExponent), ctx);
    }

    public EFloat Quantize(int desiredExponentInt, EContext ctx) {
        return this.Quantize(EFloat.Create(1, desiredExponentInt), ctx);
    }

    public EFloat Quantize(EFloat otherValue, EContext ctx) {
        return MathValue.Quantize(this, otherValue, ctx);
    }

    public EFloat Reduce(EContext ctx) {
        return MathValue.Reduce(this, ctx);
    }

    public EFloat Remainder(EFloat divisor, EContext ctx) {
        return MathValue.Remainder(this, divisor, ctx, true);
    }

    public EFloat RemainderNoRoundAfterDivide(EFloat divisor, EContext ctx) {
        return MathValue.Remainder(this, divisor, ctx, false);
    }

    public EFloat RemainderNaturalScale(EFloat divisor) {
        return this.RemainderNaturalScale(divisor, null);
    }

    public EFloat RemainderNaturalScale(EFloat divisor, EContext ctx) {
        return this.Subtract(this.DivideToIntegerNaturalScale(divisor, null).Multiply(divisor, null), ctx);
    }

    public EFloat RemainderNear(EFloat divisor, EContext ctx) {
        return MathValue.RemainderNear(this, divisor, ctx);
    }

    public EFloat RoundToExponent(EInteger exponent, EContext ctx) {
        return MathValue.RoundToExponentSimple(this, exponent, ctx);
    }

    public EFloat RoundToExponent(int exponentSmall, EContext ctx) {
        return this.RoundToExponent(EInteger.FromInt32(exponentSmall), ctx);
    }

    public EFloat RoundToExponentExact(EInteger exponent, EContext ctx) {
        return MathValue.RoundToExponentExact(this, exponent, ctx);
    }

    public EFloat RoundToExponentExact(EInteger exponent, ERounding rounding) {
        return MathValue.RoundToExponentExact(this, exponent, EContext.Unlimited.WithRounding(rounding));
    }

    public EFloat RoundToExponentExact(int exponentSmall, EContext ctx) {
        return this.RoundToExponentExact(EInteger.FromInt32(exponentSmall), ctx);
    }

    public EFloat RoundToIntegerExact(EContext ctx) {
        return MathValue.RoundToExponentExact(this, EInteger.FromInt32(0), ctx);
    }

    public EFloat RoundToIntegerNoRoundedFlag(EContext ctx) {
        return MathValue.RoundToExponentNoRoundedFlag(this, EInteger.FromInt32(0), ctx);
    }

    @Deprecated
    public EFloat RoundToIntegralExact(EContext ctx) {
        return MathValue.RoundToExponentExact(this, EInteger.FromInt32(0), ctx);
    }

    @Deprecated
    public EFloat RoundToIntegralNoRoundedFlag(EContext ctx) {
        return MathValue.RoundToExponentNoRoundedFlag(this, EInteger.FromInt32(0), ctx);
    }

    public EFloat RoundToPrecision(EContext ctx) {
        return MathValue.RoundToPrecision(this, ctx);
    }

    public EFloat PreRound(EContext ctx) {
        return NumberUtility.PreRound(this, ctx, MathValue);
    }

    public EFloat ScaleByPowerOfTwo(int places) {
        return this.ScaleByPowerOfTwo(EInteger.FromInt32(places), null);
    }

    public EFloat ScaleByPowerOfTwo(int places, EContext ctx) {
        return this.ScaleByPowerOfTwo(EInteger.FromInt32(places), ctx);
    }

    public EFloat ScaleByPowerOfTwo(EInteger bigPlaces) {
        return this.ScaleByPowerOfTwo(bigPlaces, null);
    }

    public EFloat ScaleByPowerOfTwo(EInteger bigPlaces, EContext ctx) {
        if (bigPlaces == null) {
            throw new NullPointerException("bigPlaces");
        }
        if (bigPlaces.isZero()) {
            return this.RoundToPrecision(ctx);
        }
        if (!this.isFinite()) {
            return this.RoundToPrecision(ctx);
        }
        EInteger bigExp = this.getExponent();
        bigExp = bigExp.Add(bigPlaces);
        return new EFloat(this.unsignedMantissa, FastIntegerFixed.FromBig(bigExp), this.flags).RoundToPrecision(ctx);
    }

    public EFloat Sqrt(EContext ctx) {
        return MathValue.SquareRoot(this, ctx);
    }

    @Deprecated
    public EFloat SquareRoot(EContext ctx) {
        return MathValue.SquareRoot(this, ctx);
    }

    public EFloat Subtract(EFloat otherValue) {
        return this.Subtract(otherValue, null);
    }

    public EFloat Subtract(EFloat otherValue, EContext ctx) {
        if (otherValue == null) {
            throw new NullPointerException("otherValue");
        }
        EFloat negated = otherValue;
        if ((otherValue.flags & 0xC) == 0) {
            int newflags = otherValue.flags ^ 1;
            negated = new EFloat(otherValue.unsignedMantissa, otherValue.exponent, (byte)newflags);
        }
        return this.Add(negated, ctx);
    }

    public double ToDouble() {
        long value = this.ToDoubleBits();
        return Double.longBitsToDouble(value);
    }

    public int ToSingleBits() {
        if (this.IsPositiveInfinity()) {
            return 2139095040;
        }
        if (this.IsNegativeInfinity()) {
            return -8388608;
        }
        if (this.IsNaN()) {
            int nan = 2139095040;
            if (this.isNegative()) {
                nan |= Integer.MIN_VALUE;
            }
            if (this.IsQuietNaN()) {
                nan |= 0x400000;
            } else if (this.getUnsignedMantissa().isZero()) {
                nan |= 0x200000;
            }
            if (!this.getUnsignedMantissa().isZero()) {
                EInteger bigdata = this.getUnsignedMantissa().Remainder(EInteger.FromInt64(0x400000L));
                int intData = bigdata.ToInt32Checked();
                nan |= intData;
                if (intData == 0 && !this.IsQuietNaN()) {
                    nan |= 0x200000;
                }
            }
            return nan;
        }
        EFloat thisValue = this;
        if (!thisValue.isFinite() || thisValue.unsignedMantissa.CompareToInt(0x1000000) >= 0 || thisValue.exponent.CompareToInt(-95) < 0 || thisValue.exponent.CompareToInt(95) > 0) {
            thisValue = this.RoundToPrecision(EContext.Binary32);
        }
        if (!thisValue.isFinite()) {
            return thisValue.ToSingleBits();
        }
        int intmant = thisValue.unsignedMantissa.ToInt32();
        if (thisValue.isNegative() && intmant == 0) {
            return Integer.MIN_VALUE;
        }
        if (intmant == 0) {
            return 0;
        }
        int intBitLength = NumberUtility.BitLength(intmant);
        int expo = thisValue.exponent.ToInt32();
        boolean subnormal = false;
        if (intBitLength < 24) {
            int diff = 24 - intBitLength;
            if ((expo -= diff) < -149) {
                diff -= -149 - expo;
                expo = -149;
                subnormal = true;
            }
            intmant <<= diff;
        }
        int smallmantissa = intmant & 0x7FFFFF;
        if (!subnormal) {
            smallmantissa |= expo + 150 << 23;
        }
        if (this.isNegative()) {
            smallmantissa |= Integer.MIN_VALUE;
        }
        return smallmantissa;
    }

    public long ToDoubleBits() {
        if (this.IsPositiveInfinity()) {
            return 0x7FF0000000000000L;
        }
        if (this.IsNegativeInfinity()) {
            return -4503599627370496L;
        }
        if (this.IsNaN()) {
            int[] nan = new int[]{0, 0x7FF00000};
            if (this.isNegative()) {
                nan[1] = nan[1] | Integer.MIN_VALUE;
            }
            if (this.IsQuietNaN()) {
                nan[1] = nan[1] | 0x80000;
            } else if (this.getUnsignedMantissa().isZero()) {
                nan[1] = nan[1] | 0x40000;
            }
            if (!this.getUnsignedMantissa().isZero()) {
                int[] words = FastInteger.GetLastWords(this.getUnsignedMantissa(), 2);
                nan[0] = words[0];
                nan[1] = nan[1] | words[1] & 0x7FFFF;
                if ((words[0] | words[1] & 0x7FFFF) == 0 && !this.IsQuietNaN()) {
                    nan[1] = nan[1] | 0x40000;
                }
            }
            long lret = (long)nan[0] & 0xFFFFFFFFL;
            return lret |= (long)nan[1] << 32;
        }
        EFloat thisValue = this;
        if (!thisValue.isFinite() || thisValue.unsignedMantissa.CompareToInt64(0x10000000000000L) >= 0 || thisValue.exponent.CompareToInt(-900) < 0 || thisValue.exponent.CompareToInt(900) > 0) {
            thisValue = this.RoundToPrecision(EContext.Binary64);
        }
        if (!thisValue.isFinite()) {
            return thisValue.ToDoubleBits();
        }
        long longmant = thisValue.unsignedMantissa.ToInt64();
        if (thisValue.isNegative() && longmant == 0L) {
            return Long.MIN_VALUE;
        }
        if (longmant == 0L) {
            return 0L;
        }
        long longBitLength = NumberUtility.BitLength(longmant);
        int expo = thisValue.exponent.ToInt32();
        boolean subnormal = false;
        if (longBitLength < 53L) {
            int diff = 53 - (int)longBitLength;
            if ((expo -= diff) < -1074) {
                diff -= -1074 - expo;
                expo = -1074;
                subnormal = true;
            }
            longmant <<= diff;
        }
        longmant &= 0xFFFFFFFFFFFFFL;
        if (!subnormal) {
            longmant |= (long)(expo + 1075) << 52;
        }
        if (thisValue.isNegative()) {
            longmant |= Long.MIN_VALUE;
        }
        return longmant;
    }

    public EDecimal ToEDecimal() {
        return EDecimal.FromEFloat(this);
    }

    public EInteger ToEInteger() {
        return this.ToEIntegerInternal(false);
    }

    @Deprecated
    public EInteger ToEIntegerExact() {
        return this.ToEIntegerInternal(true);
    }

    public EInteger ToEIntegerIfExact() {
        return this.ToEIntegerInternal(true);
    }

    public String ToEngineeringString() {
        return this.ToEDecimal().ToEngineeringString();
    }

    @Deprecated
    public EDecimal ToExtendedDecimal() {
        return EDecimal.FromEFloat(this);
    }

    public String ToPlainString() {
        return this.ToEDecimal().ToPlainString();
    }

    private String ToDebugString() {
        return "[" + this.getMantissa().ToRadixString(2) + "," + this.getMantissa().GetUnsignedBitLengthAsEInteger() + "," + this.getExponent() + "]";
    }

    public String ToShortestString(EContext ctx) {
        if (ctx == null || !ctx.getHasMaxPrecision()) {
            return this.toString();
        }
        if (this.IsNaN()) {
            return EFloat.CreateNaN(this.getUnsignedMantissa(), this.IsSignalingNaN(), this.isNegative(), ctx).toString();
        }
        if (this.IsInfinity()) {
            return this.RoundToPrecision(ctx).toString();
        }
        EContext ctx2 = ctx.WithNoFlags();
        EFloat valueEfRnd = this.RoundToPrecision(ctx);
        if (valueEfRnd.IsInfinity()) {
            return valueEfRnd.toString();
        }
        if (this.isZero()) {
            return this.RoundToPrecision(ctx).toString();
        }
        EDecimal dec = this.ToEDecimal();
        if (ctx.getPrecision().compareTo(10) >= 0) {
            EInteger roundedPrec = ctx.getPrecision().ShiftRight(1).Add(EInteger.FromInt32(3));
            EInteger dmant = dec.getUnsignedMantissa();
            EInteger dexp = dec.getExponent();
            boolean dneg = dec.isNegative();
            DigitShiftAccumulator dsa = new DigitShiftAccumulator(dmant, 0, 0);
            dsa.ShiftToDigits(FastInteger.FromBig(roundedPrec), null, false);
            dmant = dsa.getShiftedInt();
            dexp = dexp.Add(dsa.getDiscardedDigitCount().ToEInteger());
            if ((dsa.getLastDiscardedDigit() != 0 || dsa.getOlderDiscardedDigits() != 0) && dmant.Remainder(10).ToInt32Checked() != 9) {
                dmant = dmant.Add(1);
            }
            dec = EDecimal.Create(dmant, dexp);
            if (dneg) {
                dec = dec.Negate();
            }
        }
        boolean mantissaIsPowerOfTwo = this.getUnsignedMantissa().isPowerOfTwo();
        EInteger eprecision = EInteger.FromInt32(0);
        while (true) {
            EInteger nextPrecision;
            EContext nextCtx;
            EDecimal nextDec;
            EFloat newFloat;
            if ((newFloat = (nextDec = dec.RoundToPrecision(nextCtx = ctx2.WithBigPrecision(nextPrecision = eprecision.Add(EInteger.FromInt32(1))))).ToEFloat(ctx2)).compareTo(valueEfRnd) == 0) {
                if (mantissaIsPowerOfTwo && eprecision.signum() > 0) {
                    nextPrecision = eprecision;
                    nextCtx = ctx2.WithBigPrecision(nextPrecision);
                    EDecimal nextDec2 = dec.RoundToPrecision(nextCtx);
                    newFloat = (nextDec2 = nextDec2.NextPlus(nextCtx)).ToEFloat(ctx2);
                    if (newFloat.compareTo(valueEfRnd) == 0) {
                        nextDec = nextDec2;
                    }
                }
                return nextDec.getExponent().signum() > 0 && nextDec.Abs().compareTo(EDecimal.FromInt32(10000000)) < 0 ? nextDec.ToPlainString() : nextDec.toString();
            }
            eprecision = nextPrecision;
        }
    }

    public float ToSingle() {
        int sb = this.ToSingleBits();
        return Float.intBitsToFloat(sb);
    }

    public String toString() {
        return EDecimal.FromEFloat(this).toString();
    }

    public EFloat Ulp() {
        return !this.isFinite() ? One : EFloat.Create(EInteger.FromInt32(1), this.getExponent());
    }

    static EFloat CreateWithFlags(long mantissa, EInteger exponent, int flags) {
        if (exponent == null) {
            throw new NullPointerException("exponent");
        }
        return new EFloat(FastIntegerFixed.FromInt64(mantissa).Abs(), FastIntegerFixed.FromBig(exponent), (byte)flags);
    }

    static EFloat CreateWithFlags(EInteger mantissa, EInteger exponent, int flags) {
        if (mantissa == null) {
            throw new NullPointerException("mantissa");
        }
        if (exponent == null) {
            throw new NullPointerException("exponent");
        }
        return new EFloat(FastIntegerFixed.FromBig(mantissa).Abs(), FastIntegerFixed.FromBig(exponent), (byte)flags);
    }

    private EInteger ToEIntegerInternal(boolean exact) {
        if (!this.isFinite()) {
            throw new ArithmeticException("Value is infinity or NaN");
        }
        if (this.isZero()) {
            return EInteger.FromInt32(0);
        }
        int expsign = this.getExponent().signum();
        if (expsign == 0) {
            return this.getMantissa();
        }
        if (expsign > 0) {
            boolean neg;
            EInteger curexp = this.getExponent();
            EInteger bigmantissa = this.getMantissa();
            if (bigmantissa.isZero()) {
                return bigmantissa;
            }
            boolean bl = neg = bigmantissa.signum() < 0;
            if (neg) {
                bigmantissa = bigmantissa.Negate();
            }
            bigmantissa = bigmantissa.ShiftLeft(curexp);
            if (neg) {
                bigmantissa = bigmantissa.Negate();
            }
            return bigmantissa;
        }
        if (exact && !this.unsignedMantissa.isEvenNumber()) {
            throw new ArithmeticException("Not an exact integer");
        }
        FastInteger bigexponent = FastInteger.FromBig(this.getExponent()).Negate();
        EInteger bigmantissa = this.getUnsignedMantissa();
        BitShiftAccumulator acc = new BitShiftAccumulator(bigmantissa, 0, 0);
        acc.ShiftRight(bigexponent);
        if (exact && (acc.getLastDiscardedDigit() != 0 || acc.getOlderDiscardedDigits() != 0)) {
            throw new ArithmeticException("Not an exact integer");
        }
        bigmantissa = acc.getShiftedInt();
        if (this.isNegative()) {
            bigmantissa = bigmantissa.Negate();
        }
        return bigmantissa;
    }

    private static EInteger PowerOfRadixBitsLowerBound(EInteger e) {
        return e.Abs();
    }

    private static EInteger PowerOfRadixBitsUpperBound(EInteger e) {
        return e.Abs().Add(1);
    }

    public EInteger ToSizedEInteger(int maxBitLength) {
        return this.ToSizedEInteger(maxBitLength, false);
    }

    public EInteger ToSizedEIntegerIfExact(int maxBitLength) {
        return this.ToSizedEInteger(maxBitLength, true);
    }

    private EInteger ToSizedEInteger(int maxBitLength, boolean exact) {
        if (maxBitLength < 0) {
            throw new IllegalArgumentException("maxBitLength (" + maxBitLength + ") is not greater or equal to 0");
        }
        if (!this.isFinite() || this.isZero()) {
            return exact ? this.ToEIntegerIfExact() : this.ToEInteger();
        }
        EInteger mant = this.getMantissa();
        EInteger exp = this.getExponent();
        if (exp.signum() > 0) {
            long imantbits = mant.GetSignedBitLengthAsInt64();
            if (imantbits >= (long)maxBitLength) {
                throw new ArithmeticException("Value out of range");
            }
            if (exp.compareTo(0x100000) < 0 && imantbits < 0x100000L) {
                long expBitsLowerBound = exp.ToInt64Checked();
                if (imantbits - 1L + expBitsLowerBound > (long)maxBitLength) {
                    throw new ArithmeticException("Value out of range");
                }
            } else {
                if (exp.compareTo(maxBitLength) > 0) {
                    throw new ArithmeticException("Value out of range");
                }
                EInteger mantbits = mant.GetSignedBitLengthAsEInteger();
                if (mantbits.Subtract(1).Add(EFloat.PowerOfRadixBitsLowerBound(exp)).compareTo(maxBitLength) > 0) {
                    throw new ArithmeticException("Value out of range");
                }
            }
            mant = exact ? this.ToEIntegerIfExact() : this.ToEInteger();
        } else if (exp.signum() < 0) {
            exp = exp.Abs();
            long imantbits = mant.GetSignedBitLengthAsInt64();
            if (exp.compareTo(0x100000) < 0 && imantbits < 0x100000L) {
                long expBitsUpperBound = exp.ToInt64Checked() + 1L;
                long expBitsLowerBound = exp.ToInt64Checked();
                if (imantbits - 1L - expBitsUpperBound > (long)maxBitLength) {
                    throw new ArithmeticException("Value out of range");
                }
                if (imantbits + 1L < expBitsLowerBound) {
                    if (exact) {
                        throw new ArithmeticException("Not an exact integer");
                    }
                    return EInteger.FromInt32(0);
                }
            } else {
                if (imantbits < 0x100000L && exp.compareTo(0x200000) >= 0) {
                    if (exact) {
                        throw new ArithmeticException("Not an exact integer");
                    }
                    return EInteger.FromInt32(0);
                }
                EInteger mantbits = mant.GetSignedBitLengthAsEInteger();
                if (mantbits.Subtract(1).Subtract(EFloat.PowerOfRadixBitsUpperBound(exp)).compareTo(maxBitLength) > 0) {
                    throw new ArithmeticException("Value out of range");
                }
            }
            EInteger eInteger = mant = exact ? this.ToEIntegerIfExact() : this.ToEInteger();
        }
        if (mant.GetSignedBitLengthAsEInteger().compareTo(maxBitLength) > 0) {
            throw new ArithmeticException("Value out of range");
        }
        return mant;
    }

    public EFloat Increment() {
        return this.Add(1);
    }

    public EFloat Decrement() {
        return this.Subtract(1);
    }

    public byte ToByteChecked() {
        if (!this.isFinite()) {
            throw new ArithmeticException("Value is infinity or NaN");
        }
        return this.isZero() ? (byte)0 : this.ToEInteger().ToByteChecked();
    }

    public byte ToByteUnchecked() {
        return this.isFinite() ? this.ToEInteger().ToByteUnchecked() : (byte)0;
    }

    public byte ToByteIfExact() {
        if (!this.isFinite()) {
            throw new ArithmeticException("Value is infinity or NaN");
        }
        return this.isZero() ? (byte)0 : this.ToEIntegerIfExact().ToByteChecked();
    }

    public static EFloat FromByte(byte inputByte) {
        int val = inputByte & 0xFF;
        return EFloat.FromInt32(val);
    }

    public short ToInt16Checked() {
        if (!this.isFinite()) {
            throw new ArithmeticException("Value is infinity or NaN");
        }
        return this.isZero() ? (short)0 : this.ToEInteger().ToInt16Checked();
    }

    public short ToInt16Unchecked() {
        return this.isFinite() ? this.ToEInteger().ToInt16Unchecked() : (short)0;
    }

    public short ToInt16IfExact() {
        if (!this.isFinite()) {
            throw new ArithmeticException("Value is infinity or NaN");
        }
        return this.isZero() ? (short)0 : this.ToEIntegerIfExact().ToInt16Checked();
    }

    public static EFloat FromInt16(short inputInt16) {
        short val = inputInt16;
        return EFloat.FromInt32(val);
    }

    public int ToInt32Checked() {
        if (!this.isFinite()) {
            throw new ArithmeticException("Value is infinity or NaN");
        }
        return this.isZero() ? 0 : this.ToEInteger().ToInt32Checked();
    }

    public int ToInt32Unchecked() {
        return this.isFinite() ? this.ToEInteger().ToInt32Unchecked() : 0;
    }

    public int ToInt32IfExact() {
        if (!this.isFinite()) {
            throw new ArithmeticException("Value is infinity or NaN");
        }
        return this.isZero() ? 0 : this.ToEIntegerIfExact().ToInt32Checked();
    }

    public static EFloat FromBoolean(boolean boolValue) {
        return boolValue ? One : Zero;
    }

    public static EFloat FromInt32(int inputInt32) {
        if (inputInt32 >= -24 && inputInt32 <= 128) {
            return Cache[inputInt32 - -24];
        }
        if (inputInt32 == Integer.MIN_VALUE) {
            return EFloat.FromEInteger(EInteger.FromInt32(inputInt32));
        }
        return new EFloat(FastIntegerFixed.FromInt32(Math.abs(inputInt32)), FastIntegerFixed.Zero, (byte)(inputInt32 < 0 ? 1 : 0));
    }

    public long ToInt64Checked() {
        if (!this.isFinite()) {
            throw new ArithmeticException("Value is infinity or NaN");
        }
        return this.isZero() ? 0L : this.ToEInteger().ToInt64Checked();
    }

    public long ToInt64Unchecked() {
        return this.isFinite() ? this.ToEInteger().ToInt64Unchecked() : 0L;
    }

    public long ToInt64IfExact() {
        if (!this.isFinite()) {
            throw new ArithmeticException("Value is infinity or NaN");
        }
        return this.isZero() ? 0L : this.ToEIntegerIfExact().ToInt64Checked();
    }

    public static EFloat FromInt64AsUnsigned(long longerValue) {
        return longerValue >= 0L ? EFloat.FromInt64(longerValue) : EFloat.FromEInteger(EInteger.FromInt64AsUnsigned(longerValue));
    }

    public static EFloat FromInt64(long inputInt64) {
        if (inputInt64 >= -24L && inputInt64 <= 128L) {
            return Cache[(int)inputInt64 - -24];
        }
        if (inputInt64 == Long.MIN_VALUE) {
            return EFloat.FromEInteger(EInteger.FromInt64(inputInt64));
        }
        return new EFloat(FastIntegerFixed.FromInt64(Math.abs(inputInt64)), FastIntegerFixed.Zero, (byte)(inputInt64 < 0L ? 1 : 0));
    }

    private static final class BinaryMathHelper
    implements IRadixMathHelper<EFloat> {
        private BinaryMathHelper() {
        }

        @Override
        public int GetRadix() {
            return 2;
        }

        @Override
        public int GetSign(EFloat value) {
            return value.signum();
        }

        @Override
        public EInteger GetMantissa(EFloat value) {
            return value.unsignedMantissa.ToEInteger();
        }

        @Override
        public EInteger GetExponent(EFloat value) {
            return value.exponent.ToEInteger();
        }

        @Override
        public FastInteger GetDigitLength(EInteger ei) {
            return FastInteger.FromBig(ei.GetUnsignedBitLengthAsEInteger());
        }

        @Override
        public FastIntegerFixed GetMantissaFastInt(EFloat value) {
            return value.unsignedMantissa;
        }

        @Override
        public FastIntegerFixed GetExponentFastInt(EFloat value) {
            return value.exponent;
        }

        @Override
        public IShiftAccumulator CreateShiftAccumulatorWithDigits(EInteger bigint, int lastDigit, int olderDigits) {
            return new BitShiftAccumulator(bigint, lastDigit, olderDigits);
        }

        @Override
        public IShiftAccumulator CreateShiftAccumulatorWithDigitsFastInt(FastIntegerFixed fastInt, int lastDigit, int olderDigits) {
            if (fastInt.CanFitInInt32()) {
                return new BitShiftAccumulator(fastInt.ToInt32(), lastDigit, olderDigits);
            }
            return new BitShiftAccumulator(fastInt.ToEInteger(), lastDigit, olderDigits);
        }

        @Override
        public FastInteger DivisionShift(EInteger num, EInteger den) {
            if (den.isZero()) {
                return null;
            }
            if (den.GetUnsignedBit(0) && den.compareTo(EInteger.FromInt32(1)) != 0) {
                return null;
            }
            EInteger valueELowBit = den.GetLowBitAsEInteger();
            return den.GetUnsignedBitLengthAsEInteger().equals(valueELowBit.Add(1)) ? FastInteger.FromBig(valueELowBit) : null;
        }

        @Override
        public EInteger MultiplyByRadixPower(EInteger bigint, FastInteger power) {
            EInteger tmpbigint = bigint;
            if (power.signum() <= 0) {
                return tmpbigint;
            }
            if (tmpbigint.signum() < 0) {
                tmpbigint = tmpbigint.Negate();
                tmpbigint = power.ShiftEIntegerLeftByThis(tmpbigint);
                tmpbigint = tmpbigint.Negate();
                return tmpbigint;
            }
            return power.ShiftEIntegerLeftByThis(tmpbigint);
        }

        @Override
        public FastIntegerFixed MultiplyByRadixPowerFastInt(FastIntegerFixed fbigint, FastIntegerFixed fpower) {
            if (fpower.signum() <= 0) {
                return fbigint;
            }
            EInteger ei = this.MultiplyByRadixPower(fbigint.ToEInteger(), FastInteger.FromBig(fpower.ToEInteger()));
            return FastIntegerFixed.FromBig(ei);
        }

        @Override
        public int GetFlags(EFloat value) {
            return value.flags;
        }

        @Override
        public EFloat CreateNewWithFlags(EInteger mantissa, EInteger exponent, int flags) {
            return new EFloat(FastIntegerFixed.FromBig(mantissa), FastIntegerFixed.FromBig(exponent), (byte)flags);
        }

        @Override
        public EFloat CreateNewWithFlagsFastInt(FastIntegerFixed fmantissa, FastIntegerFixed fexponent, int flags) {
            return new EFloat(fmantissa, fexponent, (byte)flags);
        }

        @Override
        public int GetArithmeticSupport() {
            return 1;
        }

        @Override
        public EFloat ValueOf(int val) {
            return EFloat.FromInt32(val);
        }
    }
}

