/*
 * Decompiled with CFR 0.152.
 */
package com.github.sd4324530.fastweixin.api;

import com.github.sd4324530.fastweixin.api.BaseAPI;
import com.github.sd4324530.fastweixin.api.config.ApiConfig;
import com.github.sd4324530.fastweixin.api.entity.CustomAccount;
import com.github.sd4324530.fastweixin.api.enums.ResultType;
import com.github.sd4324530.fastweixin.api.response.BaseResponse;
import com.github.sd4324530.fastweixin.api.response.GetCustomAccountsResponse;
import com.github.sd4324530.fastweixin.exception.WeixinException;
import com.github.sd4324530.fastweixin.message.Article;
import com.github.sd4324530.fastweixin.message.BaseMsg;
import com.github.sd4324530.fastweixin.message.ImageMsg;
import com.github.sd4324530.fastweixin.message.MpNewsMsg;
import com.github.sd4324530.fastweixin.message.MusicMsg;
import com.github.sd4324530.fastweixin.message.NewsMsg;
import com.github.sd4324530.fastweixin.message.TextMsg;
import com.github.sd4324530.fastweixin.message.VideoMsg;
import com.github.sd4324530.fastweixin.message.VoiceMsg;
import com.github.sd4324530.fastweixin.util.BeanUtil;
import com.github.sd4324530.fastweixin.util.JSONUtil;
import com.github.sd4324530.fastweixin.util.StrUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomAPI
extends BaseAPI {
    private static final Logger LOG = LoggerFactory.getLogger(CustomAPI.class);

    public CustomAPI(ApiConfig config) {
        super(config);
    }

    public ResultType sendCustomMessage(String openid, BaseMsg message) {
        BaseMsg msg;
        BeanUtil.requireNonNull(openid, "openid is null");
        BeanUtil.requireNonNull(message, "message is null");
        LOG.debug("\u53d1\u5e03\u5ba2\u670d\u6d88\u606f......");
        String url = "https://api.weixin.qq.com/cgi-bin/message/custom/send?access_token=#";
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("touser", openid);
        if (message instanceof TextMsg) {
            msg = (TextMsg)message;
            params.put("msgtype", "text");
            HashMap<String, String> text = new HashMap<String, String>();
            text.put("content", ((TextMsg)msg).getContent());
            params.put("text", text);
        } else if (message instanceof ImageMsg) {
            msg = (ImageMsg)message;
            params.put("msgtype", "image");
            HashMap<String, String> image = new HashMap<String, String>();
            image.put("media_id", ((ImageMsg)msg).getMediaId());
            params.put("image", image);
        } else if (message instanceof VoiceMsg) {
            msg = (VoiceMsg)message;
            params.put("msgtype", "voice");
            HashMap<String, String> voice = new HashMap<String, String>();
            voice.put("media_id", ((VoiceMsg)msg).getMediaId());
            params.put("voice", voice);
        } else if (message instanceof VideoMsg) {
            msg = (VideoMsg)message;
            params.put("msgtype", "video");
            HashMap<String, String> video = new HashMap<String, String>();
            video.put("media_id", ((VideoMsg)msg).getMediaId());
            video.put("thumb_media_id", ((VideoMsg)msg).getMediaId());
            video.put("title", ((VideoMsg)msg).getTitle());
            video.put("description", ((VideoMsg)msg).getDescription());
            params.put("video", video);
        } else if (message instanceof MusicMsg) {
            msg = (MusicMsg)message;
            params.put("msgtype", "music");
            HashMap<String, String> music = new HashMap<String, String>();
            music.put("thumb_media_id", ((MusicMsg)msg).getThumbMediaId());
            music.put("title", ((MusicMsg)msg).getTitle());
            music.put("description", ((MusicMsg)msg).getDescription());
            music.put("musicurl", ((MusicMsg)msg).getMusicUrl());
            music.put("hqmusicurl", ((MusicMsg)msg).getHqMusicUrl());
            params.put("music", music);
        } else if (message instanceof NewsMsg) {
            msg = (NewsMsg)message;
            params.put("msgtype", "news");
            HashMap news = new HashMap();
            ArrayList articles = new ArrayList();
            List<Article> list = ((NewsMsg)msg).getArticles();
            for (Article article : list) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("title", article.getTitle());
                map.put("description", article.getDescription());
                map.put("url", article.getUrl());
                map.put("picurl", article.getPicUrl());
                articles.add(map);
            }
            news.put("articles", articles);
            params.put("news", news);
        } else if (message instanceof MpNewsMsg) {
            msg = (MpNewsMsg)message;
            params.put("msgtype", "mpnews");
            HashMap<String, String> news = new HashMap<String, String>();
            news.put("media_id", ((MpNewsMsg)msg).getMediaId());
            params.put("mpnews", news);
        }
        BaseResponse response = this.executePost(url, JSONUtil.toJson(params));
        return ResultType.get(response.getErrcode());
    }

    public ResultType addCustomAccount(CustomAccount customAccount) {
        LOG.debug("\u6dfb\u52a0\u5ba2\u670d\u5e10\u53f7.....");
        BeanUtil.requireNonNull(customAccount.getAccountName(), "\u5e10\u53f7\u5fc5\u586b");
        BeanUtil.requireNonNull(customAccount.getNickName(), "\u6635\u79f0\u5fc5\u586b");
        String url = "https://api.weixin.qq.com/customservice/kfaccount/add?access_token=#";
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("kf_account", customAccount.getAccountName());
        params.put("nickname", customAccount.getNickName());
        if (StrUtil.isNotBlank(customAccount.getPassword())) {
            params.put("password", customAccount.getPassword());
        }
        BaseResponse response = this.executePost(url, JSONUtil.toJson(params));
        return ResultType.get(response.getErrcode());
    }

    public ResultType updateCustomAccount(CustomAccount customAccount) {
        LOG.debug("\u4fee\u6539\u5ba2\u670d\u5e10\u53f7\u4fe1\u606f......");
        BeanUtil.requireNonNull(customAccount.getAccountName(), "\u5e10\u53f7\u5fc5\u586b");
        BeanUtil.requireNonNull(customAccount.getNickName(), "\u6635\u79f0\u5fc5\u586b");
        String url = "https://api.weixin.qq.com/customservice/kfaccount/update?access_token=#";
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("kf_account", customAccount.getAccountName());
        params.put("nickname", customAccount.getNickName());
        if (StrUtil.isNotBlank(customAccount.getPassword())) {
            params.put("password", customAccount.getPassword());
        }
        BaseResponse response = this.executePost(url, JSONUtil.toJson(params));
        return ResultType.get(response.getErrcode());
    }

    public ResultType deleteCustomAccount(String accountName) {
        LOG.debug("\u5220\u9664\u5ba2\u670d\u5e10\u53f7\u4fe1\u606f......");
        String url = "https://api.weixin.qq.com/customservice/kfaccount/del?access_token=#&kf_account=" + accountName;
        BaseResponse response = this.executePost(url, null);
        return ResultType.get(response.getErrcode());
    }

    public ResultType uploadHeadImg(String accountName, File file) {
        LOG.debug("\u8bbe\u7f6e\u5ba2\u670d\u5e10\u53f7\u5934\u50cf.....");
        BeanUtil.requireNonNull(accountName, "\u5e10\u53f7\u5fc5\u586b");
        BeanUtil.requireNonNull(file, "\u6587\u4ef6\u4e3a\u7a7a");
        String fileName = file.getName().toLowerCase();
        if (!fileName.endsWith("jpg")) {
            throw new WeixinException("\u5934\u50cf\u5fc5\u987b\u662fjpg\u683c\u5f0f");
        }
        String url = "https://api.weixin.qq.com/customservice/kfaccount/uploadheadimg?access_token=#&kf_account=" + accountName;
        BaseResponse response = this.executePost(url, null, file);
        return ResultType.get(response.getErrcode());
    }

    public GetCustomAccountsResponse getCustomAccountList() {
        LOG.debug("\u83b7\u53d6\u6240\u6709\u5ba2\u670d\u5e10\u53f7\u4fe1\u606f....");
        String url = "https://api.weixin.qq.com/cgi-bin/customservice/getkflist?access_token=#";
        BaseResponse r = this.executeGet(url);
        String resultJson = this.isSuccess(r.getErrcode()) ? r.getErrmsg() : r.toJsonString();
        GetCustomAccountsResponse response = JSONUtil.toBean(resultJson, GetCustomAccountsResponse.class);
        return response;
    }
}

