/*
 * Decompiled with CFR 0.152.
 */
package com.github.sd4324530.fastweixin.api.config;

import com.github.sd4324530.fastweixin.api.config.ChangeType;
import com.github.sd4324530.fastweixin.api.config.ConfigChangeNotice;
import com.github.sd4324530.fastweixin.api.response.GetJsApiTicketResponse;
import com.github.sd4324530.fastweixin.api.response.GetTokenResponse;
import com.github.sd4324530.fastweixin.exception.WeixinException;
import com.github.sd4324530.fastweixin.handle.ApiConfigChangeHandle;
import com.github.sd4324530.fastweixin.util.JSONUtil;
import com.github.sd4324530.fastweixin.util.NetWorkCenter;
import com.github.sd4324530.fastweixin.util.StrUtil;
import java.io.Serializable;
import java.util.Observable;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ApiConfig
extends Observable
implements Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(ApiConfig.class);
    private final AtomicBoolean tokenRefreshing = new AtomicBoolean(false);
    private final AtomicBoolean jsRefreshing = new AtomicBoolean(false);
    private final String appid;
    private final String secret;
    private String accessToken;
    private String jsApiTicket;
    private boolean enableJsApi;
    private long jsTokenStartTime;
    private long weixinTokenStartTime;

    public ApiConfig(String appid, String secret) {
        this(appid, secret, false);
    }

    public ApiConfig(String appid, String secret, boolean enableJsApi) {
        this.appid = appid;
        this.secret = secret;
        this.enableJsApi = enableJsApi;
        long now = System.currentTimeMillis();
        this.initToken(now);
        if (enableJsApi) {
            this.initJSToken(now);
        }
    }

    public String getAppid() {
        return this.appid;
    }

    public String getSecret() {
        return this.secret;
    }

    public String getAccessToken() {
        long now = System.currentTimeMillis();
        long time = now - this.weixinTokenStartTime;
        try {
            if (time > 7100000L && this.tokenRefreshing.compareAndSet(false, true)) {
                LOG.debug("\u51c6\u5907\u5237\u65b0token.............");
                this.initToken(now);
            }
        }
        catch (Exception e) {
            LOG.warn("\u5237\u65b0Token\u51fa\u9519.", (Throwable)e);
            this.tokenRefreshing.set(false);
        }
        return this.accessToken;
    }

    public String getJsApiTicket() {
        if (this.enableJsApi) {
            long now = System.currentTimeMillis();
            try {
                if (now - this.jsTokenStartTime > 7100000L && this.jsRefreshing.compareAndSet(false, true)) {
                    this.getAccessToken();
                    this.initJSToken(now);
                }
            }
            catch (Exception e) {
                LOG.warn("\u5237\u65b0jsTicket\u51fa\u9519.", (Throwable)e);
                this.jsRefreshing.set(false);
            }
        } else {
            this.jsApiTicket = null;
        }
        return this.jsApiTicket;
    }

    public boolean isEnableJsApi() {
        return this.enableJsApi;
    }

    public void setEnableJsApi(boolean enableJsApi) {
        this.enableJsApi = enableJsApi;
        if (!enableJsApi) {
            this.jsApiTicket = null;
        }
    }

    public void addHandle(ApiConfigChangeHandle handle) {
        super.addObserver(handle);
    }

    public void removeHandle(ApiConfigChangeHandle handle) {
        super.deleteObserver(handle);
    }

    public void removeAllHandle() {
        super.deleteObservers();
    }

    private void initToken(long refreshTime) {
        LOG.debug("\u5f00\u59cb\u521d\u59cb\u5316access_token........");
        final long oldTime = this.weixinTokenStartTime;
        this.weixinTokenStartTime = refreshTime;
        String url = "https://api.weixin.qq.com/cgi-bin/token?grant_type=client_credential&appid=" + this.appid + "&secret=" + this.secret;
        NetWorkCenter.get(url, null, new NetWorkCenter.ResponseCallback(){

            @Override
            public void onResponse(int resultCode, String resultJson) {
                if (200 == resultCode) {
                    GetTokenResponse response = JSONUtil.toBean(resultJson, GetTokenResponse.class);
                    LOG.debug("\u83b7\u53d6access_token:{}", (Object)response.getAccessToken());
                    if (null == response.getAccessToken()) {
                        ApiConfig.this.weixinTokenStartTime = oldTime;
                        throw new WeixinException("\u5fae\u4fe1\u516c\u4f17\u53f7token\u83b7\u53d6\u51fa\u9519\uff0c\u9519\u8bef\u4fe1\u606f:" + response.getErrcode() + "," + response.getErrmsg());
                    }
                    ApiConfig.this.accessToken = response.getAccessToken();
                    ApiConfig.this.setChanged();
                    ApiConfig.this.notifyObservers(new ConfigChangeNotice(ApiConfig.this.appid, ChangeType.ACCESS_TOKEN, ApiConfig.this.accessToken));
                }
            }
        });
        this.tokenRefreshing.set(false);
    }

    private void initJSToken(long refreshTime) {
        LOG.debug("\u521d\u59cb\u5316 jsapi_ticket........");
        final long oldTime = this.jsTokenStartTime;
        this.jsTokenStartTime = refreshTime;
        String url = "https://api.weixin.qq.com/cgi-bin/ticket/getticket?access_token=" + this.accessToken + "&type=jsapi";
        NetWorkCenter.get(url, null, new NetWorkCenter.ResponseCallback(){

            @Override
            public void onResponse(int resultCode, String resultJson) {
                if (200 == resultCode) {
                    GetJsApiTicketResponse response = JSONUtil.toBean(resultJson, GetJsApiTicketResponse.class);
                    LOG.debug("\u83b7\u53d6jsapi_ticket:{}", (Object)response.getTicket());
                    if (StrUtil.isBlank(response.getTicket())) {
                        ApiConfig.this.jsTokenStartTime = oldTime;
                        throw new WeixinException("\u5fae\u4fe1\u516c\u4f17\u53f7jsToken\u83b7\u53d6\u51fa\u9519\uff0c\u9519\u8bef\u4fe1\u606f:" + response.getErrcode() + "," + response.getErrmsg());
                    }
                    ApiConfig.this.jsApiTicket = response.getTicket();
                    ApiConfig.this.setChanged();
                    ApiConfig.this.notifyObservers(new ConfigChangeNotice(ApiConfig.this.appid, ChangeType.JS_TOKEN, ApiConfig.this.jsApiTicket));
                }
            }
        });
        this.jsRefreshing.set(false);
    }
}

